/*** coff information for Hitachi SH */

/********************** FILE HEADER **********************/

struct external_filehdr {
	short f_magic;	/* magic number			*/
	short f_nscns;	/* number of sections		*/
	int  f_timdat;	/* time & date stamp		*/
	int  f_symptr;	/* file pointer to symtab	*/
	int  f_nsyms;	/* number of symtab entries	*/
	short f_opthdr;	/* sizeof(optional hdr)		*/
	short f_flags;	/* flags			*/
};



#define	SH_ARCH_MAGIC	0x0500


#define SHBADMAG(x) (((x).f_magic!=SH_ARCH_MAGIC))

#define	FILHDR	struct external_filehdr
#define	FILHSZ	20


/********************** AOUT "OPTIONAL HEADER" **********************/


typedef struct 
{
  short magic;		/* type of file				*/
  short	vstamp;		/* version stamp			*/
  int	tsize;		/* text size in bytes, padded to FW bdry*/
  int	dsize;		/* initialized data "  "		*/
  int	bsize;		/* uninitialized data "   "		*/
  int	entry;		/* entry pt.				*/
  int 	text_start;		/* base of text used for this file */
  int 	data_start;		/* base of data used for this file */
  int   flags;
  
}
AOUTHDR;


#define AOUTHDRSZ (sizeof(AOUTHDR))
#define AOUTSZ 32




/********************** SECTION HEADER **********************/


struct external_scnhdr {
	char		s_name[8];	/* section name			*/
	int		s_paddr;	/* physical address, aliased s_nlib */
	int		s_vaddr;	/* virtual address		*/
	int		s_size; 	/* section size			*/
	int		s_scnptr;	/* file ptr to raw data for section */
	int		s_relptr;	/* file ptr to relocation	*/
	int		s_lnnoptr;	/* file ptr to line numbers	*/
	short		s_nreloc;	/* number of relocation entries	*/
	short		s_nlnno;	/* number of line number entries*/
	int		s_flags;	/* flags			*/
};

/*
 * names of "special" sections
 */
#define _TEXT	".text"
#define _DATA	".data"
#define _BSS	".bss"


#define	SCNHDR	struct external_scnhdr
#define	SCNHSZ	40


/********************** LINE NUMBERS **********************/

/* 1 line number entry for every "breakpointable" source line in a section.
 * Line numbers are grouped on a per function basis; first entry in a function
 * grouping will have l_lnno = 0 and in place of physical address will be the
 * symbol table index of the function name.
 */
struct external_lineno {
	union {
		int l_symndx;	/* function name symbol index, iff l_lnno == 0*/
		int l_paddr;	/* (physical) address of line number	*/
	} l_addr;
	int l_lnno;	/* line number		*/
};

#define GET_LINENO_LNNO(abfd, ext) bfd_h_get_32(abfd, (bfd_byte *) (ext->l_lnno));
#define PUT_LINENO_LNNO(abfd,val, ext) bfd_h_put_32(abfd,val,  (bfd_byte *) (ext->l_lnno));

#define	LINENO	struct external_lineno
#define	LINESZ	sizeof(LINENO) 


/********************** SYMBOLS **********************/

#define E_SYMNMLEN	8	/* # characters in a symbol name	*/
#define E_FILNMLEN	14	/* # characters in a file name		*/
#define E_DIMNUM	4	/* # array dimensions in auxiliary entry */

struct external_syment 
{
  union {
    char e_name[E_SYMNMLEN];
    struct {
      int e_zeroes;
      int e_offset;
    } e;
  } e;
  int e_value;
  short e_scnum;
  short e_type;
  char e_sclass;
  char e_numaux;
};

#define e_name		e.e_name
#define e_zeroes	e.e.e_zeroes
#define e_offset	e.e.e_offset


#define N_BTMASK	(017)
#define N_TMASK		(060)
#define N_BTSHFT	(4)
#define N_TSHIFT	(2)
  

union external_auxent {
	struct {
		int x_tagndx;	/* str, un, or enum tag indx */
		union {
			struct {
			    short  x_lnno; /* declaration line number */
			    short  x_size; /* str/union/array size */
			} x_lnsz;
			int x_fsize;	/* size of function */
		} x_misc;
		union {
			struct {		/* if ISFCN, tag, or .bb */
			    int x_lnnoptr;	/* ptr to fcn line # */
			    int x_endndx;	/* entry ndx past block end */
			} x_fcn;
			struct {		/* if ISARY, up to 4 dimen. */
			    short x_dimen[E_DIMNUM];
			} x_ary;
		} x_fcnary;
		short x_tvndx;		/* tv index */
	} x_sym;

	union {
		char x_fname[E_FILNMLEN];
		struct {
			int x_zeroes;
			int x_offset;
		} x_n;
	} x_file;

	struct {
		int x_scnlen;			/* section length */
		short x_nreloc;	/* # relocation entries */
		short x_nlinno;	/* # line numbers */
	} x_scn;

        struct {
		int x_tvfill;	/* tv fill value */
		short x_tvlen;	/* length of .tv */
		short x_tvran[2];	/* tv range */
	} x_tv;		/* info about .tv section (in auxent of symbol .tv)) */


};

#define	SYMENT	struct external_syment
#define	SYMESZ	18	
#define	AUXENT	union external_auxent
#define	AUXESZ	18



/********************** RELOCATION DIRECTIVES **********************/

/* The external reloc has an offset field, because some of the reloc
   types on the h8 don't have room in the instruction for the entire
   offset - eg the strange jump and high page addressing modes */

struct external_reloc {
  int r_vaddr;
  int r_symndx;
  int r_offset;
  short r_type;
  short r_stuff;
};


#define RELOC struct external_reloc
#define RELSZ 16

#define DEFAULT_DATA_SECTION_ALIGNMENT 4
#define DEFAULT_BSS_SECTION_ALIGNMENT 4
#define DEFAULT_TEXT_SECTION_ALIGNMENT 4
/* For new sections we havn't heard of before */
#define DEFAULT_SECTION_ALIGNMENT 4



