#include <stdio.h>
#include <time.h>		/* Used for ctime function */

/* Headers for working with COFF files */
/*#include <aouthdr.h>
#include <filehdr.h>
#include <scnhdr.h>
#include <linenum.h>
#include <reloc.h>
#include <syms.h>
*/

#include "internal.h"
#include "sh.h"
		/* Global variables */

long	num_sections;	/* Number of section */
long	section_seek;   /* Used to seek to first section */

long	symptr;		/* File pointer to symbol table entries */
long	num_symbols;	/* Number of symbols */

char 	*str_tab;	/* Pointer to start of string char. array */
long 	str_length;	/* Length in bytes of string array */

FILE 	*fd;		/* COFF file descriptor */

main(argc,argv)
int	argc;
char	*argv[];
{
	fd = fopen(argv[1], "r");
	if (fd == 0) exit(0);

	read_headers();
	read_sections();
	read_strings();
	read_symbols();
	exit(0);

}

read_headers()
{
FILHDR  file_header;	/* File header structure */
AOUTHDR	optional_header;/* Optional header structure */

	fread(&file_header, FILHSZ, 1, fd);

	printf("FILE HEADER VALUES\n");
	printf("f_magic  = 0%o\n", file_header.f_magic);
	if(file_header.f_magic!=SH_ARCH_MAGIC)
		printf("WARNING: WRONG MAGIC NUMBER, example may dump core!!!\n");
	printf("f_nscns  = %d\n",file_header.f_nscns);
	printf("f_timdat = %s",ctime(&file_header.f_timdat));
	printf("f_symptr = %d\n",file_header.f_symptr);
	printf("f_nsyms  = %d\n",file_header.f_nsyms);
	printf("f_opthdr = %d\n",file_header.f_opthdr);
	printf("f_flags  = 0%o\n",file_header.f_flags);

	/* Save the global values */

	num_sections = file_header.f_nscns;
	num_symbols  = file_header.f_nsyms;
	symptr	     = file_header.f_symptr;

	if (file_header.f_opthdr)
	{ 
		fread(&optional_header,AOUTSZ,1,fd);
	
		printf("OPTIONAL HEADER VALUES\n");
		printf("magic      = 0%o\n", optional_header.magic);
		printf("vstamp     = %d\n",optional_header.vstamp);
		printf("tsize      = %d\n",optional_header.tsize);
		printf("dsize      = %d\n",optional_header.dsize);
		printf("bsize      = %d\n",optional_header.bsize);
		printf("entry      = 0x%x\n",optional_header.entry);
		printf("text_start = 0x%x\n",optional_header.text_start);
		printf("data_start = 0x%x\n",optional_header.data_start);
		printf("flags      = 0x%x\n",optional_header.flags);
	}

	/* File offset for first section headers */
	section_seek = FILHSZ + file_header.f_opthdr;
}

read_sections()
{
SCNHDR	sh; /* Section header structure */
RELOC	re; /* Relocation entry structure */
LINENO	le; /* Line number entry structure */
char 	*raw_data;
int	i,j;

	for (i = 0; i < num_sections; i++) 
		{
		fseek(fd,section_seek,0);
		fread(&sh,SCNHSZ,1,fd);
		section_seek += SCNHSZ;

		printf("\n %s - SECTION HEADER - \n",sh.s_name); 
		printf("s_paddr   = 0x%x\n",sh.s_paddr);
		printf("s_vaddr   = 0x%x\n",sh.s_vaddr);
		printf("s_size    = %d\n",sh.s_size);
		printf("s_scnptr  = %d\n",sh.s_scnptr);
		printf("s_relptr  = %d\n",sh.s_relptr);
		printf("s_lnnoptr = %d\n",sh.s_lnnoptr);
		printf("s_nreloc  = %d\n",sh.s_nreloc);
		printf("s_nlnno   = %d\n",sh.s_nlnno);
		printf("s_flags   = 0x%x\n",sh.s_flags);
	
		/* Output raw data only for text and data sections */
		if (strcmp(sh.s_name,".bss") && (sh.s_flags!=STYP_BSS))
			{
			raw_data = (char *)malloc(sh.s_size);
			fseek(fd,sh.s_scnptr,0);
			fread(raw_data,sh.s_size,1,fd);
   
			printf("RAW DATA\n");
			j=0;
   			while(j<sh.s_size) 
			  {
			    printf("%02x ",(*raw_data&0xFF));
			    *raw_data++; j++;
			    if (j%16==0) printf("\n");
			  }
			printf("\n");
			free(raw_data-j);
		      }
	
		if (sh.s_nreloc) 
			{	
			printf("\nRELOCATION ENTRIES\n");
			fseek(fd,sh.s_relptr,0);
			j=0;	
			while(j<sh.s_nreloc) 
				{
				fread(&re,RELSZ,1,fd);
				printf("r_vaddr = 0x%x",re.r_vaddr);
            			printf(" r_symndx = 0x%x",re.r_symndx);
				printf(" r_offset = 0x%x\n",re.r_offset);
				j++;
				}
			}

		if (sh.s_nlnno) 
			{
			printf("\nLINE NUMBER ENTRIES \n");
			fseek(fd,sh.s_lnnoptr,0);
			j=0;	
			while(j<sh.s_nlnno) 
				{
				fread(&le,LINESZ,1,fd);
				if (le.l_lnno == 0)
	printf("function address 0x%x\n",le.l_addr.l_symndx);
				else 
	printf("line# %d at address 0x%x\n",le.l_lnno,le.l_addr.l_paddr);
				j++;
				}
			}

	}
}

read_strings()
{
int 	strings;
char	*str_ptr;

	strings = symptr+SYMESZ*num_symbols;
	fseek(fd,strings,0);
	fread(&str_length,4,1,fd);
	if (str_length) {
		printf("\nSTRING TABLE DUMP\n");
		str_length-=4;
		str_tab = (char *)malloc(str_length);
		fseek(fd,(strings+4),0);
		fread(str_tab,str_length,1,fd);
		str_ptr=str_tab;
		do	{
			printf("%s\n",str_ptr);
			while(*str_ptr++ !='\0');
			}
		while(str_ptr<(str_tab+str_length));
		}
}

read_symbols()
{
SYMENT	se;
AUXENT  ae;
int	i;
int	j;

	fseek(fd,symptr,0);

	printf("\nSYMBOL TABLE ENTRIES\n");
	i = 0;
	while (i  != num_symbols) 
		{
		fread(&se,SYMESZ,1,fd);
		printf("0x%05x ", i);
		print_se(&se); i++;
		for (j = 0; j < se.e_numaux; j++) 
			{
			fread(&ae,AUXESZ,1,fd);
			print_ae(&ae);
			i++;
			}
		}
}


print_se(se)
SYMENT  *se;
{
int i;
	if (se->e_zeroes) 
		{
		for ( i = 0; i < 8; i++) 
			{
		    	if ((se->e_name[i] > 0x1f) && (se->e_name[i] < 0x7f))
		       		printf("%c",se->e_name[i]);
		    	else 
				printf(" ");
			}
		} 
	else
		 printf("%s",&str_tab[(se->e_offset-4)]);

	printf(" n_scnum=%d ",se->e_scnum);

	switch (se->e_type & 0xf) 
		{
	 	case T_CHAR:   printf("T_CHAR"); break;
		case T_SHORT:  printf("T_SHORT"); break;
	 	case T_INT:    printf("T_INT"); break;
	 	case T_LONG:   printf("T_LONG"); break;
	 	case T_FLOAT:  printf("T_FLOAT"); break;
	 	case T_DOUBLE: printf("T_DOUBLE"); break;
	 	case T_STRUCT: printf("T_STRUCT"); break;
	 	case T_UNION:  printf("T_UNION"); break;
	 	case T_ENUM:   printf("T_ENUM"); break;
	 	case T_MOE:    printf("T_MOE"); break;
	 	case T_UCHAR:  printf("T_UCHAR"); break;
	 	case T_USHORT: printf("T_USHORT"); break;
	 	case T_UINT:   printf("T_UINT"); break;
	 	case T_ULONG:  printf("T_ULONG"); break;
	 	default:       printf("n_type=%d",se->e_type&0xf); break;
		}

	if (ISFCN(se->e_type))       
		printf(",DT_FCN ");
	else 
		if (ISPTR(se->e_type))  
			printf(",DT_PTR ");
	else 
		if (ISARY(se->e_type))  
			printf(",DT_ARY ");

	switch (se->e_sclass)  
		{
	 	case C_NULL   : printf(" C_NULL=0x%x",se->e_value); break;
	 	case C_STAT   : printf(" C_STAT=0x%x",se->e_value); break;
	 	case C_EXT    : printf(" C_EXT=0x%x",se->e_value); break;
	 	case C_AUTO   : printf(" C_AUTO=0x%x",se->e_value); break;
	 	case C_FILE   : printf(" C_FILE"); break;
	 	case C_STRTAG : printf(" C_STRTAG"); break;
	 	case C_EOS    : printf(" C_EOS=0x%x",se->e_value); break;
	 	case C_FCN    : printf(" C_FCN=0x%x",se->e_value); break;
	 	case C_EFCN   : printf(" C_EFCN=0x%x",se->e_value); break;
	 	default       : printf(" n_sclass=0x%x",se->e_sclass); break;
		}

	printf(" n_numaux=%d\n",se->e_numaux);
}

print_ae(ae)
char	*ae;
{
int i;
	printf(" Aux. = ");
	for( i = 1; i <= AUXESZ; i++ ) 
		{
		printf("%1x",(*ae>>4)&0xF);
		printf("%1x ",(*ae&0xF));
		*ae++; 
		}

	printf("\n");
}

