/* string.c  for Fork95 compiler   930316  CWK */

#include <string.h>
#include <stdlib.h>
#define CONST const
#define PTR void *
#define UINT_MAX ((unsigned)0xffffffff)
#define INT_MAX 0xffffffff
#define UCHAR_MAX UINT_MAX
#define CHAR_MAX INT_MAX

int errno;


char *pr3s( int n, char *__buf3, int leading ) {
 /* prints 3 digits of unsigned n ranging from 0 to 999 */
 /*assert( n < 1000 ); assert( n >= 0 );*/
 int x = n/100;
 if (x||leading)
   { *(__buf3++) = x+48; leading = 1; }
 x = (n/10)%10;
 if (x||leading)
   *(__buf3++) = x + 48;
 *(__buf3++) = n%10+48;
 return __buf3;
}


void itoa( int number, char *buf ) {
   int leading;
 /* prints signed integer number ranging from -10^12+1 to 10^12-1 */
 /* leading!=0 indicates that leading zeroes are to be printed */
 /* Vorteil: kleine Zahlen gehen schneller zu drucken */
 register int d;
 register int n;
 if (number<0) { *(buf++) = '-'; n = (-number); }
 else n = number;
 /* 1000000000 is max. power of 10 that fits into an int */
 if (n>1000000000) { buf = pr3s( (d=(n/1000000000)), buf, leading ); leading = 1; n = n - (d*1000000000); }
 else if (leading) buf = pr3s( 0, buf, 1 );
 if (n>1000000) { buf = pr3s( (d=(n/1000000)), buf, leading ); leading = 1; n = n - (d*1000000); }
 else if (leading) buf = pr3s( 0, buf, 1 );
 if (n>1000) { buf = pr3s( (d=(n/1000)), buf, leading ); leading = 1; n = n - (d*1000); }
 else if (leading) buf = pr3s( 0, buf, 1 );
 pr3s( n, buf, leading ) ;
}


/* Compare S1 and S2, returning less than, equal to or
   greater than zero if the collated form of S1 is lexiographically
   less than, equal to or greater than the collated form of S2.  */

size_t strcoll( char *s1, size_t maxsize, const char *s2)
{
#if 0
  if (_collate_info == NULL || _collate_info->values == NULL)
#endif
    return strcmp(s1, s2);
#if 0
  else {
      CONST unsigned char *CONST values = _collate_info->values;
      CONST unsigned char *CONST offsets = _collate_info->offsets;

      while (*s1 != '\0' && *s2 != '\0') {
	  CONST unsigned char c1 = *s1++, c2 = *s2++;
	  CONST unsigned char v1 = values[c1], v2 = values[c2];
	  CONST unsigned char o1 = offsets[c1], o2 = offsets[c2];

	  if (v1 == UCHAR_MAX && o1 == 0)
	    /* This is a non-collating element.  Skip it.  */
	    --s2;
	  else if (v2 == UCHAR_MAX && o2 == 0)
	    --s1;
	  else if (v1 == UCHAR_MAX && o1 == CHAR_MAX)
	    {
	      /* This element collates lower than anything else.  */
	      if (v2 != UCHAR_MAX || o2 != CHAR_MAX)
		return -1;
	    }
	  else if (v2 == UCHAR_MAX && o2 == CHAR_MAX)
	    return 1;
	  else if (v1 != v2)
	    return v1 - v2;
	  else if (o1 != o2)
	    return o1 - o2;
	}

      if (*s1 == '\0')
	return *s2 == '\0' ? 0 : -1;
      else if (*s2 == '\0')
	return 1;
      return 0;
    }
#endif
}


/* Return a string descibing the errno code in ERRNUM.
   The storage is good only until the next call to strerror.
   Writing to the storage causes undefined behavior.  */

static char *__strerror_msg = "strerror:             \n";

char *strerror (int errnum)
{
  itoa( errno, __strerror_msg + 10 );
  return __strerror_msg;
}


static char *olds = NULL;

/* Parse S into tokens separated by characters in DELIM.
   If S is NULL, the last string strtok() was called with is
   used.  For example:
	char s[] = "-abc=-def";
	x = strtok(s, "-");		// x = "abc"
	x = strtok(NULL, "=-");		// x = "def"
	x = strtok(NULL, "=");		// x = NULL
		// s = "abc\0-def\0"
*/

#if 0
char *strtok (char *s, const char *delim)
{
  char *token;
  if (s == NULL) {
      if (olds == NULL) {
	  errno = EINVAL;
	  return NULL;
      }
      else s = olds;
  }
  /* Scan leading delimiters.  */
  s += strspn(s, delim);
  if (*s == '\0') {
      olds = NULL;
      return NULL;
  }
  /* Find the end of the token.  */
  token = s;
  s = strpbrk(token, delim);
  if (s == NULL)
    /* This token finishes the string.  */
    olds = NULL;
  else {
      /* Terminate the token and make OLDS point past it.  */
      *s = '\0';
      olds = s + 1;
  }
  return token;
}
#endif


void __swab ( char *from, char *to, size_t n)
{
  while (n > 1)
    {
      CONST char b0 = from[--n], b1 = from[--n];
      to[n] = b0;
      to[n + 1] = b1;
    }
}



/* Search no more than N bytes of S for C.  */

void *memchr( CONST PTR s, int c, size_t n)
{
  CONST unsigned char *char_ptr;

  c = (unsigned char) c;

  for (char_ptr = s; n > 0; --n, ++char_ptr)
    if (*char_ptr == c)
      return (PTR) char_ptr;

  return NULL;
}


PTR memset ( PTR dstpp, int c, size_t len)
{
  char *dstp = dstpp;

  while (len > 0)
    {
      *dstp++ = c;
      len -= 1;
    }

  return dstpp;
}


#if 0
/* Initialize STREAM as necessary.
   This may change I/O functions, give a buffer, etc.
   If no buffer is allocated, but the bufsize is set,
   the bufsize will be used to allocate the buffer.  */

void __stdio_init_stream (FILE *stream)
{
  if (stream->__buffer != NULL || stream->__userbuf)
    /* If's unbuffered by request, we can't do anything useful.  */
    return;
  if ((int)stream->__cookie < 2)
    stream->__linebuf = 1;
  stream->__bufsize = BUFSIZ;
}
#endif


/* Copyright (C) 1991, 1993 Free Software Foundation, Inc.
   Based on strlen implemention by Torbjorn Granlund (tege@sics.se),
   with help from Dan Sahlin (dan@sics.se) and
   bug fix and commentary by Jim Blandy (jimb@ai.mit.edu);
   adaptation to strchr suggested by Dick Karpinski (dick@cca.ucsf.edu),
   and implemented by Roland McGrath (roland@ai.mit.edu).*/

/* Find the first ocurrence of C in S.  */

char *strchr (char *s, int c)
{
  char *char_ptr;

  /* Handle the first few characters by reading one character at a time.
     Do this until CHAR_PTR is aligned on a longword boundary.  */
  for (char_ptr = s; *char_ptr; ++char_ptr)
    if (*char_ptr == c)
      return (PTR) char_ptr;
  return (c? NULL: char_ptr);
}


char *strncpy ( char *dest, const char *src, unsigned int size )
{
  asm("ldg %dest,par2\nldg %src,par1\nldg %size,par3\nbsrg spp,forklib_movb\n");
  return dest;
}


void *memcpy ( void *dest, const void *src, unsigned int size )
{
  asm("ldg %dest,par2\nldg %src,par1\nldg %size,par3\nbsrg spp,forklib_movb\n");
  return dest;
}
