#include <fork.h>
#include <math.h>
#include <io.h>
#include <syscall.h>
#include <stdlib.h>
#include <stdarg.h>
#include <ctype.h>
#include <string.h>

float zehnkommanull = 10.0;
float vierkommanull = 4.0;
float nullkommanulleins = 0.01;
int zehn = 10;
int neun = 9;

/* 8 bit exponent, decimal digits: */
#define	MAXEXP		38
/* 23 bit mantissa, decimal digits: */
#define	MAXFRACT	20

#define	DEFPREC		6

#define	BUF		(MAXEXP+MAXFRACT+1)	/* + decimal point */


void PUTC(char ch)
{
 write(1,&ch,1);
}
                        /* if( fputc(ch, fp) == EOF ) return EOF;*/

#define TEN_MUL(X)	(zehn*(X))

#define isascii(c)	((c)<256)
#define	todigit(c)	((int)(c) - '0')
#define	tochar(n)	((int)(n) + '0')

#define	LONGINT		0x01		/* long integer */
#define	LONGDBL		0x02		/* long double; unimplemented */
#define	SHORTINT	0x04		/* short integer */
#define	ALT		0x08		/* alternate form */
#define	LADJUST		0x10		/* left adjustment */
#define	ZEROPAD		0x20		/* zero (as opposed to blank) pad */
#define	HEXPREFIX	0x40		/* add 0x or 0X prefix */

char *exponent(char *, int, int);
char *round(double, int *, char *, char *, int, char *);
int  cvt(double, int, int, char *, int, char *, char *);

char lowerdigs[] = "0123456789abcdef"; /* digits for [diouxX] conversion */
char upperdigs[] = "0123456789ABCDEF";

int _doprnt(char *fmt0, /*va_list*/ va_list argp)
	/*vormals 1. arg. FILE *fp;*/
{
        char *fmt;	/* format string */
	int ch;	/* character from fmt */
	int cnt;	/* return value accumulator */
	int n;		/* random handy integer */
	char *t;	/* buffer pointer */
	double _double;		/* double precision arguments %[eEfgG] */
	int    _ulong;		/* integer arguments %[diouxX] */
	short base;		/* base for [diouxX] conversion */
	short dprec;		/* decimal precision in [diouxX] */
	short fieldsz;		/* field size expanded by sign, etc */
	short flags;		/* flags as above */
	short fpprec;		/* `extra' floating precision in [eEfgG] */
	short prec;		/* precision from format (%.3d), or -1 */
	short realsz;		/* field size expanded by decimal precision */
	short size;		/* size of converted field or string */
	short width;		/* width from format (%8d), or 0 */
	char sign;		/* sign prefix (' ', '+', '-', or \0) */
	char softsign;		/* temporary negative sign for floats */
	char buf[BUF];		/* space for %c, %[diouxX], %[eEfgG] */
        char *digs = lowerdigs;
        char cas;

	fmt = (char *) fmt0;
	for (cnt = 0;; ++fmt) {
		if (!(ch = *fmt))
			return (cnt);
		if (ch != '%') {
			PUTC(ch);
			cnt++;
			continue;
		}
		flags = 0; dprec = 0; fpprec = 0; width = 0;
		prec = -1;
		sign = '\0';

rflag:		cas = (*++fmt); /*switch{*/
		if (cas== ' ') {
			/*
			 * ``If the space and + flags both appear, the space
			 * flag will be ignored.''
			 *	-- ANSI X3J11
			 */
			if (!sign)
				sign = ' ';
			goto rflag;
                }
		if (cas=='#') {
			flags |= ALT;
			goto rflag;
                }
		if (cas=='*') {
			/*
			 * ``A negative field width argument is taken as a
			 * - flag followed by a  positive field width.''
			 *	-- ANSI X3J11
			 * They don't exclude field widths read from args.
			 */
			if ((width = (short)(_ulong = va_arg(argp, int))) >= 0)
				goto rflag;
			width = -width;
			/* FALLTHROUGH */
                }
		if (cas=='-') {
			flags |= LADJUST;
			goto rflag;
		}
                if (cas=='+') {
			sign = '+';
			goto rflag;
                }
		if (cas=='.') {
			if (*++fmt == '*')
				n = _ulong = va_arg( argp, int);
			else {
				n = 0;
				while (isascii(*fmt) && isdigit(*fmt))
					n = TEN_MUL(n) + todigit(*fmt++);
				--fmt;
			}
			prec = n < 0 ? -1 : n;
			goto rflag;
                }
		if (cas=='0') {
			/* ``Note that 0 is taken as a flag, not as the
			 * beginning of a field width.'' -- ANSI X3J11 */
			flags |= ZEROPAD;
			goto rflag;
                }
		if (cas>='1'&&cas<='9') {
			n = 0;
			do {
				n = TEN_MUL(n) + todigit(*fmt);
			} while (isascii(*++fmt) && isdigit(*fmt));
			width = n;
			--fmt;
			goto rflag;
                }
		if (cas=='L') {
			flags |= LONGDBL;
			goto rflag;
                }
		if (cas=='h') {
			flags |= SHORTINT;
			goto rflag;
                }
		if (cas=='l') {
			flags |= LONGINT;
			goto rflag;
                }
		if (cas=='c') {
			*(t = buf) = _ulong = va_arg(argp, int);
			size = 1;
			sign = '\0';
			goto pforw;
                }
		if (cas=='D')
			flags |= LONGINT;
			/*FALLTHROUGH*/
		if (cas=='d'|| cas=='i') {
			_ulong = va_arg(argp,int);
			if ((long)_ulong < 0) {
				_ulong = -_ulong;
				sign = '-';
			}
			base = zehn;
			goto number;
                }
		if (cas=='e'|| cas=='E'|| cas=='f'|| cas=='g'|| cas=='G') {
			_double = va_arg(argp, double);
			/*
			 * don't do unrealistic precision; just pad it with
			 * zeroes later, so buffer size stays rational.
			 */
			if (prec > MAXFRACT) {
				if (*fmt != 'g' && *fmt != 'G' || (flags&ALT))
					fpprec = prec - MAXFRACT;
				prec = MAXFRACT;
			}
			else if (prec == -1)
				prec = DEFPREC;
			/* softsign avoids negative 0 if _double is < 0 and
			 * no significant digits will be shown */
			if (_double < 0) {
				softsign = '-';
				_double = -_double;
			}
			else    softsign = 0;
			/* cvt may have to round up past the "start" of the
			 * buffer, i.e. ``intf("%.2f", (double)9.999);'';
			 * if the first char isn't NULL, it did.  */
			*buf = (char)NULL;
			size = cvt(_double, (int)prec, (int)flags, &softsign,
				   *fmt, buf, buf + (int)sizeof(buf)); 
			if (softsign)
				sign = '-';
			t = (*buf) ? buf : buf + 1;
			goto pforw;
                }
		if (cas=='n') {
			if (flags & LONGINT)
				_ulong = *(int *)va_arg(argp, long *) = cnt;
			else if (flags & SHORTINT)
				_ulong = *(int *)va_arg(argp, short *) = cnt;
			else
				_ulong = *(int *)va_arg(argp, int *) = cnt;
			goto breakswitch;
                }
		if (cas=='O')
			flags |= LONGINT;
			/*FALLTHROUGH*/
		if (cas=='o') {
			_ulong = va_arg(argp,int); /*unsigned*/
			base = 8;
			goto nosign;
                }
		if (cas=='p') {
			/* ``The argument shall be a pointer to void.  The
			 * value of the pointer is converted to a sequence
			 * of printable characters, in an implementation-
			 * defined manner.'' -- ANSI X3J11 */ /* NOSTRICT */
			_ulong = (long)va_arg(argp, void *);
			base = 16;
			goto nosign;
                }
		if (cas=='s') {
			if (!(t = (char *) va_arg(argp, char *)))
				t = "(null)";
			if (prec >= 0) {
				/*
				 * can't use strlen; can only look for the
				 * NUL in the first `prec' characters, and
				 * strlen() will go further.
				 */
				char *p;
				if (p = (char *)memchr(t, 0, (size_t)prec)) {
					size = p - t;
					if (size > prec)
						size = prec;
				} else
					size = prec;
			} else
				size = (int)strlen(t);
			sign = '\0';
			goto pforw;
                }
		if (cas=='U')
			flags |= LONGINT;
			/*FALLTHROUGH*/
		if (cas=='u') {
			_ulong = va_arg(argp,int); /*unsigned*/
			base = zehn;
			goto nosign;
                }
		if (cas=='X')
			digs = upperdigs;
			/* FALLTHROUGH */
		if (cas=='x') {
			_ulong = va_arg(argp,int);  /*unsigned);*/
			base = 16;
			/* leading 0x/X only if non-zero */
			if (flags & ALT && _ulong != 0)
				flags |= HEXPREFIX;

			/* unsigned conversions */
nosign:			sign = '\0';
			/*
			 * ``... diouXx conversions ... if a precision is
			 * specified, the 0 flag will be ignored.''
			 *	-- ANSI X3J11
			 */
number:			if ((dprec = prec) >= 0)
				flags &= ~ZEROPAD;

			/*
			 * ``The result of converting a zero value with an
			 * explicit precision of zero is no characters.''
			 *	-- ANSI X3J11
			 */
			t = buf + BUF;
			if (_ulong != 0 || prec != 0) {
				do {
					*--t = digs[_ulong % base];
					_ulong /= base;
				} while (_ulong);
				digs = lowerdigs;
				if (flags & ALT && base == 8 && *t != '0')
					*--t = '0'; /* octal leading 0 */
			}
			size = buf + BUF - t;

pforw:
			/* All reasonable formats wind up here.  At this point,
			 * `t' points to a string which (if not flags&LADJUST)
			 * should be padded out to `width' places.  If
			 * flags&ZEROPAD, it should first be prefixed by any
			 * sign or other prefix; otherwise, it should be blank
			 * padded before the prefix is emitted.  After any
			 * left-hand padding and prefixing, emit zeroes
			 * required by a decimal [diouxX] precision, then print
			 * the string proper, then emit zeroes required by any
			 * leftover floating precision; finally, if LADJUST,
			 * pad with blanks.  */
			/*  compute actual size, so we know how much to pad
			 * fieldsz excludes decimal prec; realsz includes it */
			fieldsz = size + fpprec;
			if (sign)
				fieldsz++;
			if (flags & HEXPREFIX)
				fieldsz += 2;
			realsz = dprec > fieldsz ? dprec : fieldsz;

			/* right-adjusting blank padding */
			if ((flags & (LADJUST|ZEROPAD)) == 0 && width)
				for (n = realsz; n < width; n++)
					PUTC(' ');
			/* prefix */
			if (sign)
				PUTC(sign);
			if (flags & HEXPREFIX) {
				PUTC('0');
				PUTC((char)*fmt);
			}
			/* right-adjusting zero padding */
			if ((flags & (LADJUST|ZEROPAD)) == ZEROPAD)
				for (n = realsz; n < width; n++)
					PUTC('0');
			/* leading zeroes from decimal precision */
			for (n = fieldsz; n < dprec; n++)
				PUTC('0');

			/* the string or number proper */
			for (n = size; --n >= 0; )
				PUTC(*t++);
			/* trailing f.p. zeroes */
			while (--fpprec >= 0)
				PUTC('0');
			/* left-adjusting padding (always blank) */
			if (flags & LADJUST)
				for (n = realsz; n < width; n++)
					PUTC(' ');
			/* finally, adjust cnt */
			cnt += (width > realsz) ? width : realsz;
			goto breakswitch;
                }
		if (cas=='\0')	/* "%?" prints ?, unless ? is NULL */
			return (cnt);
		/*default:*/
		PUTC((char)*fmt);
		cnt++;
	   /* } endswitch*/

breakswitch:  cnt = cnt;
	} /*for*/
	/* NOTREACHED */
}

extern double modf(double, double *);
extern char *exponent(char *, int, int),
            *round (double, int *, char *, char *, int, char *);

double nullkommaeins = 0.1;

int cvt(double number,
        int prec, 
        int flags,
        char *signp,
        int fmtch,
        char *startp,
        char *endp)
{
	char *p, *t;
	int dotrim, expcnt, gformat;
        double fract;
        double integer, tmp;

	dotrim = expcnt = gformat = 0;
        fract = modf( number, &integer );
	/* get an extra slot for rounding. */
	t = ++startp;

	/* get integer portion of number; put into the end of the buffer; the
	 * .01 is added for modf(356.0 / 10, &integer) returning .59999999...  */
	for (p = endp - 1; ftoi(integer); ++expcnt) {
		tmp = modf(integer * nullkommaeins , &integer);
		*p-- = tochar((int)((tmp + nullkommanulleins) * zehnkommanull));
	}
	/*switch(fmtch) { */
	if (fmtch=='f') {
		/* reverse integer into beginning of buffer */
		if (expcnt)
			for (; ++p < endp; *t++ = *p) ;
		else
			*t++ = '0';
		/* if precision required or alternate flag set, add in a
		 * decimal point.  */
		if (prec || flags&ALT)
			*t++ = '.';
		/* if requires more precision and some fraction left */
		if (fract!=0.0) {
			if (prec)
				do {
					fract = modf(fract * zehnkommanull, &tmp);
					*t++ = tochar((int)tmp);
				} while (--prec && fract!=0.0);
			if (fract!=0.0)
				startp = round(fract, (int *)NULL, startp,
				    t - 1, (char)0, signp);
		}
		for (; prec--; *t++ = '0');
		goto breakswitchfmtch;
        }
	if (fmtch=='e'||fmtch=='E') {
eformat:	if (expcnt) {
			*t++ = *++p;
			if (prec || flags&ALT)
				*t++ = '.';
			/* if requires more precision and some integer left */
			for (; prec && ++p < endp; --prec)
				*t++ = *p;
			/*
			 * if done precision and more of the integer component,
			 * round using it; adjust fract so we don't re-round
			 * later.
			 */
			if (!prec && ++p < endp) {
				fract = 0.0;
				startp = round((double)0.0, &expcnt, startp,
				    t - 1, *p, signp);
			}
			/* adjust expcnt for digit in front of decimal */
			--expcnt;
		}
		/* until first fractional digit, decrement exponent */
		else if (fract!=0.0) {
			/* adjust expcnt for digit in front of decimal */
			for (expcnt = -1;; --expcnt) {
				fract = modf(fract * zehnkommanull, &tmp);
				if (tmp)
					break; /*for*/
			}
			*t++ = tochar((int)tmp);
			if (prec || flags&ALT)
				*t++ = '.';
		}
		else {
			*t++ = '0';
			if (prec || flags&ALT)
				*t++ = '.';
		}
		/* if requires more precision and some fraction left */
		if (fract!=0.0) {
			if (prec)
				do {
					fract = modf(fract * zehnkommanull, &tmp);
					*t++ = tochar((int)tmp);
				} while (--prec && (fract!=0.0));
			if (fract!=0.0)
				startp = round(fract, &expcnt, startp,
				    t - 1, (char)0, signp);
		}
		/* if requires more precision */
		for (; prec--; *t++ = '0');

		/* unless alternate flag, trim any g/G format trailing 0's */
		if (gformat && !(flags&ALT)) {
			while (t > startp && *--t == '0');
			if (*t == '.')
				--t;
			++t;
		}
		t = exponent(t, expcnt, fmtch);
		goto breakswitchfmtch;
        }
	if (fmtch=='g' || fmtch=='G') {
		/* a precision of 0 is treated as a precision of 1. */
		if (!prec)
			++prec;
		/*
		 * ``The style used depends on the value converted; style e
		 * will be used only if the exponent resulting from the
		 * conversion is less than -4 or greater than the precision.''
		 *	-- ANSI X3J11
		 */
		if (expcnt > prec || !expcnt && fract!=0.0 && fract < .0001) {
			/*
			 * g/G format counts "significant digits, not digits of
			 * precision; for the e/E format, this just causes an
			 * off-by-one problem, i.e. g/G considers the digit
			 * before the decimal point significant and e/E doesn't
			 * count it as precision.
			 */
			--prec;
			fmtch -= 2;		/* G->E, g->e */
			gformat = 1;
			goto eformat;
		}
		/*
		 * reverse integer into beginning of buffer,
		 * note, decrement precision
		 */
		if (expcnt)
			for (; ++p < endp; *t++ = *p, --prec);
		else
			*t++ = '0';
		/*
		 * if precision required or alternate flag set, add in a
		 * decimal point.  If no digits yet, add in leading 0.
		 */
		if (prec || flags&ALT) {
			dotrim = 1;
			*t++ = '.';
		}
		else
			dotrim = 0;
		/* if requires more precision and some fraction left */
		if (fract!=0.0) {
			if (prec) {
				if (0 == expcnt) {
				    /* if no significant digits yet */
					do {
						fract = modf(fract * zehnkommanull, &tmp);
						*t++ = tochar((int)tmp);
					} while(!tmp);
				}
				while (--prec && fract!=0.0) {
					fract = modf(fract * zehnkommanull, &tmp);
					*t++ = tochar((int)tmp);
				}
			}
			if (fract!=0.0)
				startp = round(fract, (int *)NULL, startp,
				    t - 1, (char)0, signp);
		}
		/* alternate format, adds 0's for precision, else trim 0's */
		if (flags&ALT)
			for (; prec--; *t++ = '0');
		else if (dotrim) {
			while (t > startp && *--t == '0');
			if (*t != '.')
				++t;
		}
        }
breakswitchfmtch:
	/* endswitchfmtch }*/
	return((int)(t - startp));
}

char *round(
	double fract,
	int *exp,
	char *sstart,
        char *end,
	int ch,
	char *signp)
{
	double tmp;

	if (fract!=0.0) (void)modf(fract * zehnkommanull, &tmp);
	else                      tmp = todigit(ch);
	if (tmp > vierkommanull)
		for (;; --end) {
			if (*end == '.')
				--end;
			if (++*end <= '9')
				break; /*for*/
			*end = '0';
			if (end == sstart) {
				if (exp) {	/* e/E; increment exponent */
					*end = '1';
					++*exp;
				}
				else {		/* f; add extra digit */
					*--end = '1';
					--sstart;
				}
				break; /*for*/
			}
		}
	/* ``"%.3f", (double)-0.0004'' gives you a negative 0. */
	else if (*signp == '-')
		for (;; --end) {
			if (*end == '.')
				--end;
			if (*end != '0')
				break; /*for*/
			if (end == sstart)
				*signp = 0;
		}
	return(sstart);
}


char *exponent(
	char *p,
	int exp,
	int fmtch)
{
	char *t;
	char expbuf[MAXEXP];

	*p++ = fmtch;
	if (exp < 0) {
		exp = -exp;
		*p++ = '-';
	}
	else
		*p++ = '+';
	t = expbuf + MAXEXP;
	if (exp > 9) {
		do {
			*--t = tochar(exp % zehn);
		} while ((exp /= zehn) > neun);
		*--t = tochar(exp);
		for (; t < expbuf + MAXEXP; *p++ = *t++);
	}
	else {
		*p++ = '0';
		*p++ = tochar(exp);
	}
	return(p);
}






int sprintf(char *buf, char *fmt, ...)
{
	int n;
	va_list argp;
/*
	FILE sf = {0L, (unsigned char *)buf, (unsigned char *)buf,
	     _IOWRT|_IOBIN|_IOSTRING|_IOFBF, 0, LONG_MAX,'\0'};
*/
	
	va_start(argp, fmt);
	n = _doprnt(/*&sf,*/ fmt, argp);
	/* *(sf._ptr) = '\0';		/* always tie of the string */
	return(n);
}

int vsprintf(
	char *buf,
	char *fmt,
	va_list args)
{
	int n;
/*
	FILE sf = 
	{0L, (unsigned char *)buf, (unsigned char *)buf,
	     _IOWRT|_IOBIN|_IOSTRING|_IOFBF, 0, LONG_MAX,'\0'};
*/
	n = _doprnt(/* &sf,*/ fmt, args);
	/* *(sf._ptr) = '\0';		/* always tie of the string */
	return(n);
}



#if 0
int fprintf(FILE *fp, char *fmt, ...)
{
	va_list argp;
	va_start(argp, fmt);
	return(_doprnt(fp, fmt, argp));
}

int vfprintf(FILE *fp, char *fmt, va_list args)
{
	return(_doprnt(fp, fmt, args));
}
#endif


int __printf( char *fmt, ...)
{
	va_list argp;
	va_start(argp, fmt);
	return(_doprnt(/*stdout,*/ fmt, argp));
}

int vprintf( char *fmt, va_list args)
{
	return(_doprnt(/*stdout,*/ fmt, args));
}






/* ================================================================*/
/*        old stuff, was former file print.c for pprintf()         */
/* ================================================================*/

/* This file  "print.c" was originally called "writef.c" and 
 * written by Jochen Roehrig,  (C) 1995 by bird@cs.uni-sb.de 
 * at Saarbruecken University, LS Prof. W.J. Paul, SB-PRAM project,
 * within the framework of the p4gcc compiler libraries.
 * Documentation will be contained in Jochen's Master thesis
 * which will appear 1995 at Saarbruecken University, Germany.
 * Jochen's contribution is greatly appreciated.
 * ---- Christoph W. Kessler, in March 1995.
 */
/*
 * Implementation of a printf()-like write-routine that runs only
 * on stack (without using any kind of private data)
 *
 * ported to Fork95 by C.W. Kessler, March 1995
 *
 * Floatingpoint still doesn't work properly;
 * please use prF() from <io.h> instead.
 */



#define SBO_WRITE_BUFF_LEN 160  /* that many characters fit in two lines CWK*/

/* Header stdarg.h     CWK 950309 */

/* definitions for varargs */

#define va_list char *        /*all SB-PRAM data types have size 1 CWK*/
#undef va_arg
#define va_arg(ptr,sometype) (*((ptr)++))
#define va_end(ap)

char itoabuff[33];

#define I2S_BIN  1
#define I2S_OCT  2
#define I2S_SINT 3
#define I2S_UINT 4
#define I2S_HEX  5

#define I2S_BIN_BUFF_LEN  33
#define I2S_OCT_BUFF_LEN  12
#define I2S_UINT_BUFF_LEN 11
#define I2S_SINT_BUFF_LEN 12
#define I2S_HEX_BUFF_LEN   9

#define I2S_LO_CASE 0
#define I2S_UP_CASE 1

/*
 * some useful functions
 */

int _isdigit(char c)
{
	return ((c >= '0') && (c <= '9'));
}


/*
 * int_to_string()
 *
 * converts an integer into a string representing it in either
 *
 *   - binary  (unsigned) or
 *   - octal   (unsigned) or
 *   - decimal (unsigned or signed) or
 *   - hexadezimal (unsigned)
 *
 * system
 *
 * digit specifies a minimal field width for the output string
 * lcase specifies whether [a..f] or [A..F] are used for hex-numbers
 * fill  specifies a character that is used to fill up the resulting
 *       representation up to the field width given by digits
 * buff  specifies a buffer where the result is written to
 *
 * returns the position in buff, where the result of the conversion starts
 */


const char digit[2][16] = { "0123456789abcdef", "0123456789ABCDEF"};

char *int_to_string(unsigned int num, unsigned int system,
				unsigned int digits, unsigned int lcase,
				char fill, char *buff)
{
/* THIS FUNCTION NEEDS NO PRIVATE MEMORY AREA TO BE EXECUTED
   IT CAN BE EXECUTED EVEN IF THE CALLING PROCESS RUNS ON
   THE ISTACK

   converts a 32-bit integer into a string representing num
   in a number system specified by system
   digits gives the minimal number of digits to print
   buff must be large enough to hold the representation of num
   (including the \0-character that terminates the string)

   returns the position in buff, where the string begins
           if conversion was succesfull
   returns NULL otherwise
 */


  unsigned int shift, mask, radix;
  int iter, i, pot, sig;
  char *rval, *cpt;
  
  shift = 0;
  mask = 0;

  if (system == I2S_BIN) {
		radix = 2;
		iter = I2S_BIN_BUFF_LEN-1;
		shift = 1;
		mask = 0x1;
		pot = 1;
		sig = 0;
   } else if (system == I2S_OCT) {
		radix = 8;
		iter = I2S_OCT_BUFF_LEN-1;
		shift = 3;
		mask = 0x7;
		pot = 1;
		sig = 0;
   } else if (system == I2S_UINT) {
		radix = 10;
		iter = I2S_UINT_BUFF_LEN-1;
		pot = 0;
		sig = 0;
   } else if (system == I2S_SINT) {
		if(num & 0x80000000) {
			num = (~num) + 1; /* two's complement */
			/*num = ~(num & 0xffffffff) + 1; /* two's complement */
			sig = 1;
		}
		else { sig = 0; }
		radix = 10;
		iter = I2S_SINT_BUFF_LEN-1;
		pot = 0;
   } else if (system == I2S_HEX) {
		radix = 16;
		iter = I2S_HEX_BUFF_LEN-1;
		shift = 4;
		mask = 0xf;
		pot = 0;
		sig = 0;
    } else { write(1,"Mist",4); return NULL;}

  if(buff == NULL)       return NULL;

  /* when we're here we can do the conversion */
  if(pot) {
	/* radix is a power of two */
	for(i = iter-1; i >= 0; i--) {
		buff[i] = digit[lcase][num & mask];
		num >>= shift;
	}
  }
  else { /* radix is not a power of two */
	for(i = iter-1; i >= 0; i--) {
		unsigned int numdiv, nummod;
		numdiv = num / radix;
		nummod = num - numdiv * radix;
		buff[i] = digit[lcase][nummod];
		num = numdiv;
	}
  }
  buff[iter] = '\0';

  /* shift leading zeros taking care of digits
	   (calculate start of string in buff) */

  if (digits > iter) { digits = iter; }
  else if(digits < 1) { digits = 1; }

	for(i = 0, rval = buff; i < iter-digits; i++) {
		if(buff[i] != '0') { break; }
		rval++;
	}
	cpt = rval;
	
	for( ; i < iter-1 ; i++) {
		if(buff[i] != '0') { break; }
		*cpt++ = fill;
	}
	if(sig) { *(--cpt) = '-'; }
	return (cpt < rval ? cpt : rval);
} /* int_to_string() */

/* ====================================================================== */

/*
 * parse_build_write()
 *
 * THIS FUNCTION NEEDS NO PRIVATE MEMORY AREA TO BE EXECUTED
 * IT CAN BE EXECUTED EVEN IF THE CALLING PROCESS RUNS ON
 * THE ISTACK
 *
 * writes a formatted sequence of characters to the file specified by 
 * descriptor fd (fd must have been obtained by system call open())   
 *
 * buff specifies a buffer of length buff_len which is used to build up the
 *      formatted sequence of characters
 *
 * procnum specifies a decimal number (of 4 digits at most) that will be
 *         written to fd before writing the formatted sequence of characters
 *         IF PROCNUM < 0, IT WILL NOT BE WRITTEN!
 *
 * fs   is the format string given in a printf()-like matter
 *
 *      exceptions for conversion specifications (cf. printf()-man page):
 *
 *       - the additional conversion character "b" specifies a conversion  
 *         to binary representation                                        
 *       - the flag "#" is not supported                                   
 *       - the precision field is not supported                            
 *       - floating point conversion (conversion characters (f, e, E, g, G)
 *         are not supported
 *
 * ap   specifies the arguments by which the format directives in fs are
 *      replaced
 *
 * system call write() will be called each time buff is full and at the end
 *        of parse_build_write()
 *
 * returns the total number of written characters in case of success
 * returns -1 in case of failure (the formatted sequence of characters
 *         may be written partially)
 *
 */

char __procid[I2S_UINT_BUFF_LEN];
char ccc[2];

int parse_build_write(int fd, char *buff, unsigned int buff_len,
				 int procnum, char *fs, va_list ap)
{

#define JUSTIFY_RIGHT 0
#define JUSTIFY_LEFT  1

	char *buff_pos, fill;
	unsigned int num_buffered, num_total;
	unsigned int field_width, justify, sign_always, sign_blank;
	
#define APPEND_CHAR(c)\
 {\
	 if(num_buffered == buff_len)\
     {\
		  if(write(fd, buff, buff_len)==-1)\
		      return -1;\
		  num_buffered = 0;\
		  buff_pos = buff;\
     }\
	 *buff_pos++ = c;\
	 num_buffered++;\
	 num_total++;\
}

#define STRING_CAT_JUST_BUFF(string)\
 {\
do\
{\
	 unsigned int sl, i;\
	 int diff;\
	 char *sp;\
	 \
	 sl = strlen(string);\
	 diff = field_width-sl;\
	 \
	 if((diff > 0) && (justify == JUSTIFY_RIGHT))\
     {\
	  for(i = 0; i < diff; i++)\
	      {\
		   APPEND_CHAR(fill);\
	      }\
     }\
	 for(i = 0, sp = string; i < sl; i++, sp++)\
     {\
		   APPEND_CHAR(*sp);\
     }\
	 if((diff > 0) && (justify == JUSTIFY_LEFT))\
     {\
	  for(i = 0; i < diff; i++)\
	      {\
		   APPEND_CHAR(fill);\
	      }\
     }\
} while(0);\
}

#define APPEND_NUMBER(system, case) {\
do\
{\
	 char /*lbuff=malloc(system ## _BUFF_LEN),*/ *lbuffpos; \
	 unsigned int num;\
	 \
	 num = (unsigned int) va_arg(ap, unsigned int);\
	 if((lbuffpos=int_to_string(num, system, 0, case, fill, itoabuff))==NULL)\
	     write(2, "hoppl1\7\n", sizeof("hoppla\7\n"));\
	 STRING_CAT_JUST_BUFF(lbuffpos);\
}  while(0);}

#define APPEND_NUMBER_SIG(system, case) \
do\
{\
	 char /*lbuff=malloc(system ## _BUFF_LEN),*/ *lbuffpos; \
	 unsigned int num;\
	 \
	 num = (unsigned int) va_arg(ap, unsigned int);\
	 if((lbuffpos=int_to_string(num, system, 0, case, fill, itoabuff))==NULL)\
	     write(2, "hoppla\7\n", sizeof("hoppla\7\n"));\
	 if(sign_always && (*lbuffpos != '-'))\
     {\
		  *--lbuffpos = '+';\
     }\
	 else if(sign_blank && (*lbuffpos !='-'))\
     {\
		  *--lbuffpos = ' ';\
     }\
	 STRING_CAT_JUST_BUFF(lbuffpos);\
}  while(0)

    buff_pos = buff;
    num_buffered = 0;
    num_total = 0;
    fill = ' ';
    field_width = 0;
    justify = 0;

    /*
     * write procid
     */

    if(procnum >= 0) {
        char *pos;

	if((pos = int_to_string(procnum, I2S_UINT, 4, I2S_LO_CASE, '0',
							__procid))==NULL)
		write(2, "hoppl3\7\n", sizeof("hoppla\7\n"));
	else {
		char *pt;
		*--pos='#';
		pt =  pos + strlen(pos);
		*pt++ = '#';
		*pt++ = ' ';
		*pt++ = '\0';
		field_width = 0;
		STRING_CAT_JUST_BUFF(pos);
	}
    }

    while(*fs != '\0') {
	if(*fs != '%') {
		APPEND_CHAR(*fs);
		fs++;
	}
	else {
		char c;
		int flags_left;
		fs++;

		/*
		 *  parse the flags
		 */

		flags_left = 1; /* TRUE */
		justify = JUSTIFY_RIGHT;
		sign_always = 0; /* FALSE */
		sign_blank = 0;  /*   "  */
		
		while(flags_left) {
		   switch(*fs) {
			case '-': {
				justify = JUSTIFY_LEFT;
				fs++;
				break;
			}
			case '+': {
				sign_always = 1;
				fs++;
				break;
			}
			case ' ': {
				sign_blank = 1;
				fs++;
				break;
			}
			case '#': {
				fs++;
				STRING_CAT_JUST_BUFF("[flag \'#\' will be ignored]\7");
				break; /* ( ##### IGNORED ##### ) */
			}
			default: {
				flags_left = 0; /* FALSE */
			}
		   }
		}
		
		/*
		 * parse the field width
		 */

		field_width = 0;
		fill = ' ';
		c = *fs;
		if(_isdigit(c)) {
			if(c == '0') {
				fill = '0';
				fs++;
			}
			for( ; c = *fs, _isdigit(c); fs++) {
				field_width = 10*field_width + c-'0';
			}
		}

		/*
		 * parse the precision (##### IGNORED #####)
		 */

		if(*fs == '.') {
		  fs++;
		  for( ; _isdigit(*fs); fs++);
		  STRING_CAT_JUST_BUFF("[precision specifier will be ignored]\7");
		}

		/*
		 * parse "long" - indicator
		 *
		 */

		if(*fs == 'l') {
			fs++; /* since all integers have the same size we can ignore
					 the "long"-inidicator */
		}

		/*
		 * parse the conversion specifier
		 */

		if(*fs=='\0') ; /* end of format string; do nothing */
		else if (*fs=='%') {
			APPEND_CHAR('%');
		}
		else if (*fs== 'c') {
			ccc[0] = (char) va_arg(ap, char);
			ccc[1] = '\0';
			STRING_CAT_JUST_BUFF(ccc);
		}
		else if (*fs=='s') {
			char *s;
			s = (char *) va_arg(ap, char *);
			STRING_CAT_JUST_BUFF(s);
		}
                else if (*fs=='b') {
			APPEND_NUMBER(I2S_BIN, I2S_LO_CASE);
		}
		else if (*fs=='o') {
			APPEND_NUMBER(I2S_OCT, I2S_LO_CASE);
		}
		else if (*fs=='d'||*fs=='i') {
			APPEND_NUMBER_SIG(I2S_SINT, I2S_LO_CASE);
		}
		else if (*fs=='u') {
			APPEND_NUMBER(I2S_UINT, I2S_LO_CASE);
		}
		else if (*fs=='x'||*fs=='p') {
			APPEND_NUMBER(I2S_HEX, I2S_LO_CASE);
		}
		else if (*fs=='X') {
			APPEND_NUMBER(I2S_HEX, I2S_UP_CASE);
		}
                else if (*fs=='f' || *fs=='e' || *fs=='E'||*fs=='g'||*fs=='G') {
                        float xx = va_arg(ap, unsigned int);
	                STRING_CAT_JUST_BUFF( "!Please use printf() to print floatingpoint numbers!\n" );
                        if (xx<0.0) {
                            xx = -xx;
                            APPEND_CHAR('-');
                        }
                        APPEND_CHAR('0');
                        APPEND_CHAR('.');
	                /*STRING_CAT_JUST_BUFF( pr33(fltausend*xx-(1000*ftoi(xx))));*/
                        APPEND_CHAR('0');
		} else write(1,"DEFAULT",7); 
		fs++;
	}
    }
    va_end(ap);

    if(write(fd, buff, num_buffered)==-1)
        return -1;
    else
        return num_total;

} /* parse_build_write() */

/* ====================================================================== */

/*
 * int pprintf(char *format, ...)
 * int fpprintf(int fd, char *format, ...)
 *
 * function:
 *
 *    - writes a formatted sequence S of characters to stdout (printf()/
 *      pprintf()) or to the file specified by descriptor fd
 *      (fprintf/fpprintf());
 *      fd must have been obtained by using the system call open()
 *    - the p-variants (pprintf()/fpprintf()) additionally write
 *      the processor-id __PROC_NR__ at the
 *      beginning of S
 *
 *    - formating follows the principles of printf() with some
 *      exceptions (cf. printf()-man page):
 *
 *      + the additional conversion character "b" specifies a conversion  
 *		  to binary representation                                        
 *		+ the flag "#" is not supported                                   
 *		+ the precision field is not supported                            
 *		+ floating point conversion (conversion characters (f, e, E, g, G)
 *        are not supported
 *
 * return:
 *
 *    -  total number of written characters in case of success
 *    -  -1 in case of failure (S may be written partially to stdout (fd))
 *
 * remark:
 *
 *    - these functions use a buffer B of size 160 (2 lines on a 80 column
 *      terminal) to build up the formatted sequence of characters;
 *      this implies that every 160 characters B is written to stdout (fd)
 *      even if S is longer;
 *      therefore S may be truncated in several subsequence which may cause
 *      unexpected effects if several processors write simultaneously to
 *      stdout (fd)
 *
 */

pr char buff[SBO_WRITE_BUFF_LEN];


int pprintf(char *format, ...)
{
	va_list ap;
        asm(" add app,2,r31\n stg r31,%ap \n");  /*CWK va_start(ap, format);*/

	return(parse_build_write(1, buff, SBO_WRITE_BUFF_LEN, __PROC_NR__,
							 format, ap));
} /* pprintf() */


int fpprintf(int fd, char *format, ...) {
	va_list ap;
        asm(" add app,3,r31\n stg r31,%ap ");   /*CWK*/ /*va_start(ap, format);*/
	return(parse_build_write(fd, buff, SBO_WRITE_BUFF_LEN, __PROC_NR__,
							 format, ap));
} /* fpprintf() */


