/*  io.c   by C.W.Kessler 03/95
 *
 *  simple I/O routines for Fork95 compiler
 */

#include <syscall.h>
#include <assert.h>
#include <io.h>
#include <math.h>
#include <stdlib.h>



/*-----------output routines----------------------------------------*/

sh char __CR[] = "\n";
pr char __buf3[] = "   ";

void pr3( int n, int leading ) {
 /* prints 3 digits of unsigned n ranging from 0 to 999 */
 pr register char *out = __buf3;
 pr register int len=3;
 pr register int x;
 /*assert( n < 1000 ); assert( n >= 0 );*/
 x = n/100;
 if (!(x||leading)) { out++; len--; }
 else { __buf3[0] = x+48; leading = 1; }
 x = (n/10)%10;
 if (!(x||leading)) { out++; len--; }
 else __buf3[1] = x + 48;
 __buf3[2] = n%10+48;
 write(1,out,len);
}

void prI( int number, int leading ) {
 /* prints signed integer number ranging from -10^12+1 to 10^12-1 */
 /* leading!=0 indicates that leading zeroes are to be printed */
 /* Vorteil: kleine Zahlen gehen schneller zu drucken */
 int d;
 int n;
 if (number<0) { write(1,"-",1); n = (-number); }
 else n = number;
 if (n>1000000000) { pr3( (d=(n/1000000000)), leading ); leading = 1; n = n - (d*1000000000); }
 else if (leading) pr3( 0, 1 );
 if (n>1000000) { pr3( (d=(n/1000000)), leading ); leading = 1; n = n - (d*1000000); }
 else if (leading) pr3( 0, 1 );
 if (n>1000) { pr3( (d=(n/1000)), leading ); leading = 1; n = n - (d*1000); }
 else if (leading) pr3( 0, 1 );
 pr3( n, leading );
}


static char __hexdigit[] = "0123456789abcdef";

void prX( int x ) {
 int e;
 int pos;
 if (x==0) { write(1,"0x0",3); return; }
 write(1,"0x",2); 
 for (pos=28; pos>=0; pos-=4 ) {
   e = x<<(28-pos);
   e = e>>28;
   assert(e <= 15);
   assert(e >= 0 );
   write(1,__hexdigit + e, 1);
 }
}


float tausend = 1000.0;

void prF( float xx ) {
 /* prints signed float x ranging from -10^12+1 to 10^12-1 */
 if (xx<0.0) { xx = -xx; write(1,"-",1); }
 prI(xx,0);
 write(1,".",1);
 pr3(tausend * xx - (1000 * ftoi(xx)),1);
 /* x1 = ftoi( x ); x2 = x - itof(x1) ; if (x2 < 0.0) x2 = itof(x1) - x;*/
 /*assert(ftoi(x2*1000.0));         /* hier kracht's immer, und zwar
                                        aus ungeklaerter Ursache! */
 /* 3 Nachkommastellen: pr3( x1, 1 );*/
}
 
 
extern pr int __PROC_NR__;

void prstat( void ) {
 prI(__PROC_NR__, 0);
 write(1,": $=",4); prI($,0);
 write(1,": @=",4); prIln(@);
}



/* ============ scanf()   CWK  ! THIS IS A HACK !   3.11.1995 ====== */


#include <ctype.h>
#include <string.h>
#include <stdarg.h>

#define EOF 4    /* control d CWK */
    
#ifndef __NO_FLOAT__
#define FLOATS 1
#endif

#ifndef TRUE
#define TRUE  1
#define FALSE 0
#endif

char _numstr[] = "00123456789ABCDEF";

#define	skip()	while(isspace(c)) { if ((c=(*get)(ip))<1) goto done; }

#define TEN_MUL(X) (10*(X))      /*((((X) << 2) + (X)) << 1)*/

#if FLOATS
/* fp scan actions */
#define F_NADA	0	/* just change state */
#define F_SIGN	1	/* set sign */
#define F_ESIGN	2	/* set exponent's sign */
#define F_INT	3	/* adjust integer part */
#define F_FRAC	4	/* adjust fraction part */
#define F_EXP	5	/* adjust exponent part */
#define F_QUIT	6

#define NSTATE	8
#define FS_INIT		0	/* initial state */
#define FS_SIGNED	1	/* saw sign */
#define FS_DIGS		2	/* saw digits, no . */
#define FS_DOT		3	/* saw ., no digits */
#define FS_DD		4	/* saw digits and . */
#define FS_E		5	/* saw 'e' */
#define FS_ESIGN	6	/* saw exp's sign */
#define FS_EDIGS	7	/* saw exp's digits */

#define FC_DIG		0
#define FC_DOT		1
#define FC_E		2
#define FC_SIGN		3

/* given transition,state do what action? */
int fp_do[][NSTATE] = {
{F_INT,F_INT,F_INT, F_FRAC,F_FRAC, F_EXP,F_EXP,F_EXP},	/* see digit */
{F_NADA,F_NADA,F_NADA, F_QUIT,F_QUIT,F_QUIT,F_QUIT,F_QUIT},	/* see '.' */
{F_QUIT,F_QUIT, F_NADA,F_QUIT,F_NADA, F_QUIT,F_QUIT,F_QUIT},	/* see e/E */
{F_SIGN,F_QUIT,F_QUIT,F_QUIT,F_QUIT, F_ESIGN,F_QUIT,F_QUIT},	/* see sign */ };
/* given transition,state what is new state? */
int fp_ns[][NSTATE] = {
{FS_DIGS,FS_DIGS,FS_DIGS,FS_DD,FS_DD,FS_EDIGS,FS_EDIGS,FS_EDIGS},/* see digit */
{FS_DOT,FS_DOT,FS_DD, 0, 0, 0, 0, 0},/* see '.' */
{0,0,FS_E,0,FS_E, 0, 0, 0},/* see e/E */
{FS_SIGNED,0,0,0,0,FS_ESIGN,0,0}/* see sign */
};
/* which states are valid terminators? */
int fp_sval[NSTATE] = {0,0,1,0,1,0,0,1};
#endif

#define stdin_linebufsize 256
char stdin_linebuf[stdin_linebufsize];
static int stdin_linecurrent = 0;
#define stdin_buffersize 16
char stdin_buffer[stdin_buffersize];  /* stack of ungetchar'd chars*/
static int stdin_current = 0;    /* stack pointer */

int getchar( char *stdin_buffer )
{
   char x;
   assert( stdin_linecurrent >= 0 );
   assert( stdin_current >= 0 );
   if (stdin_current) {
      x = stdin_buffer[--stdin_current];
      if (x=='\0') x = EOF;
   }
   else {
#if BUFFERING
      if (stdin_linebuf[stdin_linecurrent] != '\0') {
         x = stdin_linebuf[stdin_linecurrent++];
         if (stdin_linecurrent >= stdin_linebufsize)
            write(2,"stdin line buffer overflow!\n", 25);
      }
      else {
         read ( 0, stdin_linebuf, 1 );
         stdin_linecurrent = 1;
         x = stdin_linebuf[0];
      }
#else
      read( 0, &x, 1 );
#endif
   }
   return x;
}

int ungetchar( int x, char *stdin_buffer )
{
   if (x==EOF)  x = (int) '\0';
   assert( stdin_current >= 0 );
   if (stdin_current >= stdin_buffersize)
      write(2,"stdin buffer overflow!\n", 20);
   else
      stdin_buffer[stdin_current++] = (char) x;
   return x;
}

static char delim[128], digits[17];

int _scanf(
   char *ip,
   async int (*get)(char *),
   async int (*unget)(int,char *),
   char *fmt, 
   char **args)
{
    long n;
    int c, width, lval, sval, cnt = 0;
    char hilf;  /* CWK */
    int store, neg, base, wide1, endnull, rngflag, c2;
    char *p, *q;
#if FLOATS
    double fx;
    char fbuf[128], *fbp;
    int fstate, trans;
#endif
    
    if (!*fmt)
	return(0);
    
    c = (*get)(ip);
    while(c > 0) {
	store = FALSE;
	if (*fmt == '%') {
	    n	= 0;
	    width	= -1;
	    wide1	= 1;
	    base	= 10;
	    lval	= FALSE;
	    sval	= FALSE;
	    store	= TRUE;
	    endnull	= TRUE;
	    neg	= -1;
	    
	    strcpy((char *)delim,  "\011\012\013\014\015 ");
	    strcpy((char *)digits, (char *)_numstr); 
	    
	    if (fmt[1] == '*') {
		endnull = store = FALSE;
		++fmt;
	    }
	    
	    while (isdigit(*++fmt)) {		/* width digit(s) */
		if (width == -1)
		    width = 0;
		wide1 = width = TEN_MUL(width) + (*fmt - '0');
	    }
	    --fmt;
	  fmtnxt:
	    ++fmt;
	    /*switch(tolower(*fmt)) 	/* tolower() is a MACRO! */
	    hilf = tolower(*fmt);   {	/* tolower() is a MACRO! */
	      /*case '*':*/
              if (hilf=='*') {
		endnull = store = FALSE;
		goto fmtnxt;
	      }
	      /*case 'l':	/* long data */
              if (hilf=='l')
		lval = TRUE;
	      /*case 'h':	/* short data (for compatibility) */
              if (hilf=='h') {
		sval = TRUE;
		goto fmtnxt;
              }	
	      /*case 'i':	/* any-base numeric */
              if (hilf=='i') {
		base = 0;
		goto numfmt;
              }
	      /*case 'b':	/* unsigned binary */
              if (hilf=='b') {
		base = 2;
		goto numfmt;
	      }
	      /*case 'o':	/* unsigned octal */
              if (hilf=='o') {
		base = 8;
		goto numfmt;
              }	
	      /*case 'x':	/* unsigned hexadecimal */
              if (hilf=='x') {
		base = 16;
		goto numfmt;
              }
	      /*case 'd':	/* SIGNED decimal */
              if (hilf=='d') {
		neg = FALSE;
		goto numfmt; /* FALL-THRU */
              }	
	      /*case 'u':	/* unsigned decimal */
              if (hilf=='u') {
	      numfmt:					skip();
		
		if (isupper(*fmt))
		    lval = TRUE;
		
		if (!base) {
		    base = 10;
		    neg = FALSE;
		    if (c == '%') {
			base = 2;
			goto skip1;
		    }
		    else if (c == '0') {
			c = (*get)(ip);
			if (c < 1)
			    goto savnum;
			if ((c != 'x') && (c != 'X')) {
			    base = 8;
			    digits[8]= '\0';
			    goto zeroin;
			}
			base = 16;
			goto skip1;
		    }
                 }
		
		if ((neg == FALSE) && (base == 10)
		    && ((neg = (c == '-')) || (c == '+'))) {
		  skip1:
		    c = (*get)(ip);
		    if (c < 1)
			goto done;
		}
		
		digits[base] = '\0';
		p = ((char *) strchr((char *)digits,toupper(c)));
		
		if ((!c || !p) && width)
		    goto done;
		
		while (p && width-- && c) {
		    n = (n * base) + (p - digits);
		    c = (*get)(ip);
		  zeroin:
		    p = ((char *) strchr((char *)digits,toupper(c)));
		}
	      savnum:
		if (store) {
		    p = ((char *) *args);
		    if (neg == TRUE)
			n = -n;
		    if (lval)
			*((long*) p) = n;
		    else if (sval)
			*((short *) p) = n;
		    else
			*((int *) p) = n;
		    ++cnt;
		}
		goto breakouterswitch;
              }		
#if FLOATS
	      /*case 'e':	/* float */ /*case 'f': case 'g':*/
              if (hilf=='e'||hilf=='f'||hilf=='g') {
		skip();
		if (isupper(*fmt)) lval = TRUE;
		fstate = FS_INIT;
		fbp = fbuf;
		while (c && width--) {
		    if (c >= '0' && c <= '9')
			trans = FC_DIG;
		    else if (c == '.')
			trans = FC_DOT;
		    else if (c == '+' || c == '-')
			trans = FC_SIGN;
		    else if (tolower(c) == 'e')
			trans = FC_E;
		    else
			goto fdone;
		    
		    *fbp++ = c;

		    if (fp_do[trans][fstate] == F_QUIT)
			goto fdone;
		    fstate = fp_ns[trans][fstate];
		    c = (*get)(ip);
		}
	      fdone:
		*fbp = '\0';
		if (!fp_sval[fstate])
		    goto done;
		if (store) {
		    fx = (*fbuf == '\0') ? 0.0 : atof(fbuf);
		    p = (char *) *args;
		    if (lval)    *((double *) p) = fx;
		    else         *((float *) p) = (float)fx;
		    ++cnt;
		}
		goto breakouterswitch;
              }
#endif
	      /*case 'n':*/
              if (hilf=='n') {
		if (store) {
		  p = (char *) *args;
		  *((int *) p) = cnt;
		}
		goto breakouterswitch;
              }
	      /*case 'c':	/* character data */
              if (hilf=='c') {
		width = wide1;
		endnull	= FALSE;
		delim[0] = '\0';
		goto strproc;
	      }
	      /*case '[':	/* string w/ delimiter set */
              if (hilf=='[') {
		/* get delimiters */
		p = delim;
		if (*++fmt == '^') fmt++;
		else               lval = TRUE;
		rngflag = 2;
		if ((*fmt == ']') || (*fmt == '-')) {
		    *p++ = *fmt++;
		    rngflag = FALSE;
		}
		while (*fmt != ']') {
		    if (*fmt == '\0')
			goto done;
		    /*switch (rngflag)*/ {
		      /*case TRUE:*/
                    if (rngflag==TRUE) {
			c2 = *(p-2);
			if (c2 <= *fmt) {
			    p -= 2;
			    while (c2 < *fmt)
				*p++ = c2++;
			    rngflag = 2;
			    goto breakinnerswitch;
			}
			/* fall thru intentional */
	             }	
		     if (rngflag==FALSE) {
			rngflag = (*fmt == '-');  
                        goto breakinnerswitch;
	             }	else
                     if (rngflag==2) /*case 2:*/
			rngflag = FALSE;
		    }
                    breakinnerswitch:
		    *p++ = *fmt++;
		}
		*p = '\0';
		goto strproc;
              }		
	      /*case 's':	/* string data */
              if (hilf=='s') {
		skip();
	      strproc:
		/* process string */
		p = ((char *) *args);
		
		/* if the 1st char fails, match fails */
		if (width) {
		    q = ((char *)
			 strchr((char *)delim, c));
		    if((c < 1) || (lval ? !q : (int) q)) {
			if (endnull)
			    *p = '\0';
			goto done;
		    }
		}
		
		for (;;) /* FOREVER */
		{
		    if (store)
			*p++ = c;
		    if (((c = (*get)(ip)) < 1) ||
			(--width == 0))
			break;
		    
		    q = ((char *)
			 strchr((char *)delim, c));
		    if (lval ? !q : (int) q)
			break;
		}
		
		if (store) {
		    if (endnull)
			*p = '\0';
		    ++cnt;
		}
		goto breakouterswitch;
              }		
	      /*case '\0':	/* early EOS */
              if (hilf=='\0')
		--fmt;
		/* FALL THRU */
		
	      /*default:*/
		goto cmatch;
            breakouterswitch:  /* */;
	    }
	}
	else if (isspace(*fmt))		/* skip whitespace */
	{
	    skip();
	}
	else {			/* normal match char */
	  cmatch:
	    if (c != *fmt) 
		break; /*while*/
	    c = (*get)(ip);
	}
	
	if (store) {
	    args++; 
        }
	if (!*++fmt)
	    break; /*while*/
    }
    
  done:						/* end of scan */
    if ((c < 0) && (cnt == 0))
	return(EOF);
    
    (*unget)(c, ip);
    return(cnt);
}


int sgetc( char *s )
{
	char c;

	c = *(s++);
	return((c == '\0') ? EOF : c);
}

int sungetc( int c, char *s )
{
  if(c == EOF)   c = '\0';
  return (*(--s) = c);
}

int sscanf( char *buf, char *fmt, ... )
{
  va_list argp;

  va_start(argp, fmt);
  return(_scanf((char *) &buf, sgetc, sungetc, fmt, (char **)argp)); /* &buf */
}

int vsscanf ( char *buf, char *fmt, va_list args )
{
  return(_scanf((char *) &buf, sgetc, sungetc, fmt, (char **)args));/*&buf*/
}



/* nothing like from Dale Schumacher's dLibs */

#if 0

int fgetc (FILE *);

int fungetc (int, FILE *);

int fscanf(FILE *fp, char *fmt, ...)
{
	va_list argp;

	va_start(argp, fmt);
	return(_scanf(fp, fgetc, fungetc, fmt, argp));
}
#endif

int scanf(char *fmt, ...)
{
	va_list argp;

	va_start(argp, fmt);
	return(_scanf(stdin_buffer, getchar, ungetchar, fmt, (char **)argp + 1));
}

#if 0
int vscanf( char *fmt, va_list args )
{
	return(_scanf(stdin, fgetc, fungetc, fmt, args));
}

int vfscanf( FILE *fp, char *fmt, va_list args )
{
	return(_scanf(fp, fgetc, fungetc, fmt, args));
}
#endif

