/*  io.h   by C.W.Kessler 03/95
 *
 *  header for io.c, simple I/O routines for Fork95 compiler
 */

#ifndef __IO_HEADER__
#define __IO_HEADER__

#ifndef SYSCALLHEADER
#include <syscall.h>
#endif

extern unsigned int strlen( const char * );
#define prS(mystring) write(1,mystring,strlen(mystring))

extern void pr3( int n, int leading );
 /* prints 3 digits of unsigned n ranging from 0 to 999 */

extern void prI( int n, int leading );
 /* prints signed integer n ranging from -10^12+1 to 10^12-1 */
 /* leading!=0 indicates that leading zeroes are to be printed */

extern void prX( int x );

extern void prG( float x );

extern void prF( float x );
 /* prints signed float x with 3 digits after decimal point */
 
extern void prstat( void );
 /* prints status message containing Processor ID, current $ and @ values */

extern sh char __CR[];

#define prIln(n) {prI(n,0);write(1,"\n",1);}
#define prXln(n) {prX(n);write(1,"\n",1);}
#define prFln(n) {prF(n);write(1,"\n",1);}
#define prGln(n) {prG(n);write(1,"\n",1);}


/* source is in print.c: */

extern int __printf(char *format, ...);
#define printf __printf        /*to make things work properly CWK*/
extern int fprintf(int fd, char *format, ...);


/* The following 2 routines have been extracted from sbo.h,
 * written by Jochen Roehrig,  (c) 1994 by bird@cs.uni-sb.de */
/* ported to Fork95 by CWK 950320. Source is "print.c". */

extern int  pprintf(char *format, ...);
extern int  fpprintf(int fd, char *format, ...);

/* - writes a formatted sequence S of characters to stdout (printf()/
 *   pprintf()) or to the file specified by descriptor fd
 *   (fprintf/fpprintf());
 *   fd must have been obtained by using the system call open()
 * - the p-variants (pprintf()/fpprintf()) additionally write
 *   the processor-id __PROC_NR__
 * 
 * - formating follows the principles of common printf() with some
 *   exceptions (cf. printf()-man page):
 *
 *   + the additional conversion character "b" specifies a conversion  
 *     to binary representation                                        
 *   + the flag "#" is not supported                                   
 *   + the precision field is not supported                            
 *   + floating point conversion (conversion characters (f, e, E, g, G)
 *     is not yet working correctly
 *
 * return:
 *
 * -  total number of written characters in case of success
 * -  -1 in case of failure (S may be written partially to stdout (fd))
 *
 * remark:
 *
 * - these functions use a buffer B of size 160 (2 lines on a 80 column
 *   terminal) to build up the formatted sequence of characters;
 *   this implies that every 160 characters B is written to stdout (fd)
 *   even if S is longer;
 *   therefore S may be truncated in several subsequence which may cause
 *   unexpected effects if several processors write simultaneously to
 *   stdout (fd)
 */


/* in io.c stehen folgende zusammengeknaupte Routinen: */

extern int scanf( char *fmt, ...);
extern int sscanf( char *string, char *fmt, ...);
extern int getchar( char *stdin_buffer );
extern int ungetchar( int c, char *stdin_buffer ); 

#endif
