/* SBPRAM-FORK header fork.h     CWK 940628 */
/* last change: March 23, 1995 */

#ifndef __FORK_HEADER__
#define __FORK_HEADER__
/* required declarations for this header file: */
extern int write ( int, const void *, int );
extern pr void *reltoabs( pr void * );
extern void exit( int );
extern unsigned int strlen( const char * );
#define prS(mystring) write(1,mystring,strlen(mystring))
extern void prI( int n, int leading );
#define prIln(n) {prI(n,0);write(1,"\n",1);}
#define assert(x) if(x==0){write(1,"\nASSERTION FAILED! file ",24);\
                           prS(__FILE__); write(1," line ",6);\
                           prIln(__LINE__);\
                           exit(1);}

extern sh int __STARTED_PROCS__;    /* number of started processors */
                                    /* generally unknown at compile time */
extern pr int __PROC_NR__;          /* original consecutive process ID,
                                     * starting with 0 */
#define NULL 0

extern char *malloc( unsigned int );   /*allocate private heap space. No free() */
extern sync char *sync_malloc( unsigned int );
                                     /*same as malloc(), without synchronization*/
extern sync char *shalloc( sh unsigned int );
                                        /*allocate shared heap space. No free() */

extern void exit( int );
extern int getct( void );                /* get global time counter, 1 == 4msec */

extern sync int groupsize( void );
extern async int async_groupsize( void );   /* same function, but other prototype */
                                            /* required for consistency reasons */


/* =================  L O C K S :  ======================================== */

/* Lock types, as proposed by J. Roehrig in his Master Thesis, 1995,
 *             Saarbruecken University, taken from his p4 library implementation
 *             for the SB-PRAM: 
 *
 * 4 different locks are provided:
 *
 *     simple locks, safe locks, fair locks & reader/writer-locks
 *
 * simple locks work faster than safe locks and fair locks
 * safe locks provide some features useful for debugging
 * fair locks guarantee access to a lock in demand order (when using simple
 *   or safe locks, processors with low IDs will always get access before
 *   processors with high IDs because of the multiprefix order)
 *
 * reader/writer-locks provide the following mechanism:
 * - several readers can own the lock simultaneously
 * - a reader and a writer can't own the lock simultaneously
 * - two different writers can't own the lock simultaneously
 *
 * the locking mechanism is based on the following functions:
 * (MODULO is the modulo bit which toggels on each round)
 *
 * initialization of a lock  - must be called before any attempt to catch
 * a lock and should only be executed by one process (master)
 *
 *    void simple_lock_init(simple_lock *lock)
 *    void safe_lock_init(safe_lock *lock)
 *    void fair_lock_init(fair_lock *lock)
 *    void rw_lock_init(rw_lock *lock)
 *
 * catch a lock - lock must be initialized
 * (will loop until the lock could be locked - there's no timeout !) 
 *
 *    void simple_lockup(simple_lock *lock)
 *    void safe_lockup(safe_lock *lock)
 *    void fair_lockup(fair_lock *lock)
 *    void rw_lockup(rw_lock *lock, PTYPE)
 *         where "PTYPE" in {SBP_RW_READER, SBP_RW_WRITER)
 *
 * unlock a lock - executing process must be owner of the lock
 *
 *  simple version/fair version
 *  ---------------------------  
 *  (theoretically it's possible that a proccess that doesn't hold a lock l
 *  can unlock l - this will lead to unpredictable results and must be
 *  avoided by the programmer)
 * 
 *  this function will always return 0 (for compatibility with the safe version)
 *
 *    int simple_unlock(lock *lock)
 *    int fair_unlock(fair_lock *lock)
 * 
 *  safe version
 *  ------------ 
 *  (return code:
 *      0 - unlock was successful
 *      1 - tried to unlock a lock that wasn't locked
 *      2 - tried to unlock a lock whose owner was another process
 *   in case 1 and 2, the state of the lock isn't changed)
 *
 *    int safe_unlock(safe_lock *lock)
 * 
 *  reader/writer-lock
 *  ------------------
 * 
 *   void rw_unlock(rw_lock *lock, PTYPE, int wait)
 *        "PTYPE" in {SBP_RW_READER, SBP_RW_WRITER)
 *        "wait" is the delay a writer waits before freeing the rw-lock
 *               for other writers after having freed it for readers
 *               (delay corresponds to wait*3 SBPRAM-rounds
 */

typedef int simple_lock;     /* simple locks */

typedef struct {             /* fair locks */
   int nextnum;
   int actnum;
} fair_lock;

typedef struct {             /* safe locks */
   int cell;                     /* memory cell holding the lock */
   int owner;                    /* process ID of lock owner */
} safe_lock;

typedef struct {             /* reader-writer-locks */
   unsigned int readercounter;   /* Bits 0-29 used as reader counter */
                                 /* Bit 30 is used as writer flag */
   fair_lock writerlock;         /* current and next number */
} rw_lock;

#define RW_READ 0
#define RW_WRITE 1
   
/* the following routines are implemented in forklib2.asm */

#define simple_lock_init(slock) slock=0
extern void simple_lockup( simple_lock * );
#define simple_unlock(slock) *(slock)=0

#define fair_lock_init(flock) flock={0,0}
extern void fair_lockup( fair_lock * );
extern int fair_unlock( fair_lock * );

#define safe_lock_init(slock) slock={0,-1}
extern void safe_lockup( safe_lock * );
extern int safe_unlock( safe_lock * );

/* the following routines are implemented in async.c: */
extern void rw_lock_init( rw_lock * );
extern void rw_lockup( rw_lock *, int );
extern int rw_unlock( rw_lock *, int, int );


/* critical sections: some useful macros */

#define _enter_crit_sect(adr) simple_lockup(adr) 
#define _exit_crit_sect(adr) simple_unlock(adr)

#if 0
/*other alternatives:*/
#define _enter_crit_sect(adr) fair_lockup(adr)
#define _exit_crit_sect(adr) fair_unlock(adr)
/*or*/
#define _enter_crit_sect(adr) safe_lockup(adr)
#define _exit_crit_sect(adr) safe_unlock(adr)
/*or*/
#define _enter_crit_sect(adr) rw_lockup(adr,RW_WRITE)
#define _exit_crit_sect(adr) rw_unlock(adr,RW_WRITE,10)
#endif

/*#define DEBUG_CRIT_SECT      /* print locking and unlocking events on screen */
#ifdef DEBUG_CRIT_SECT
#define enter_crit_sect(adr) {\
      write(1,"Eingang",7);prIln(__LINE__);\
      _enter_crit_sect(adr);}
#else
#define enter_crit_sect(adr) _enter_crit_sect(adr);
#endif

#ifdef DEBUG_CRIT_SECT
#define exit_crit_sect(adr) {_exit_crit_sect(adr);write(1,"Ausgang",7);prIln(__LINE__);} 
#else
#define exit_crit_sect(adr) assert(!_exit_crit_sect(adr)) /*alock=0*/
#endif

#undef assert
#undef prS
#undef prIln


/* simple global forall and group-wide forall loop as macros: */

#define forall(i,lb,ub) for(i=__PROC_NR__+(lb);i<(ub);i+=__STARTED_PROCS__)
#define gforall(i,lb,ub) for(i=$+(lb);i<(ub);i+=groupsize())



/* ======      B A R R I E R     (group-relative resynchronization) ===== */

#define barrier asm("bsrg\t spp,forklib_sync\n")


/* ==============    J O I N    ---    the bus concept    950918 ============= */

/* global variables for the bus concept: */

#define _MAXJOINS 8         /* maximal number of joins in my user program */

extern sh char *_SM;/*[_MAXJOINS];    /* contains ptr to shmemory section of each join*/
extern sh int _gone;/*[_MAXJOINS];    /* guards access to _ticket */
extern sh int _ticket;/*[_MAXJOINS];  /* semaphore to control entry of passengers */

#if 0
#define init_joins() \
   /* to be called as early as possible. */\
{ pr int i; \
  for (i=0; i<_MAXJOINS; i++)  _gone[i] = _ticket[i] = 0; \
}
#endif

#define str( s ) #s
#define force_modulo_0 asm("bmc\t 0")

/* the following macro implements a simplified variant of the bus concept. */
/* it should only be applied in asynchronous context. */
/* switching to synchronous context is done by two pragma-like directives */
/* that should not be used in common Fork95 programs. *./

/* Parameters:
    _delaystmt should evaluate to != 0 as soon as the bus should go.
    _throwoutcond  should evaluate to !=0 if a processor that entered the bus
                   should leave immediately when starting. 
    _SMsize the memory size to be allocated by the driver for the bus's shared memory
    _retry  whether procs that missed the bus or sprang off should retry from beginning
    _body   the bus tour.
    _busywait the statement to be executed by procs that missed the bus or spring off
 */

#define join(joinID,_delaystmt,_throwoutcond,_SMsize,_retry,_body,_busywait) { \
  pr int _old_dollar = $;  \
  pr int _redo = 0;  \
  do { \
    asm("gethi\t __gone,Ret"); \
    asm("add\t Ret,__gone&0x1fff,Ret"); \
    asm("gethi\t __ticket,par1"); \
    asm("add\t par1,__ticket&0x1fff,par1"); \
    force_modulo_0; \
    asm("ldg\t Ret,0,Ret"); \
    asm("getlo 1,r31"); \
    asm("mov\t Ret,pc"); \
    asm("beq\t GONE"); \
    asm("mpadd\t par1,0,r31"); \
    /* pull a ticket */ \
    asm("nop\nnop"); \
    asm("stg\t r31,gpp,2"); /*set $*/ \
    /* I am allowed to enter the bus. */ \
    if ($==0) { \
            /* I am the bus driver and set up its shared memory: */ \
            _SM = (char *)malloc(_SMsize); /*malloc returns abs.value*/\
            pprintf("driver\n"); \
            asm("pshg\t gps,spp"); \
            asm("pshg\t eps,spp"); \
            asm("pshg\t sps,spp"); \
            asm("pshg\t gpp,spp"); \
            asm("add\t spp,-1,gpp"); \
            asm("pshgc\t spp"); /* @ = 0 */ \
            asm("pshgc\t spp"); /* new $ is 0 */ \
            asm("gethi\t __SM,gps"); /* compute new gps: */ \
            asm("add\t gps,__SM & 0x1fff,gps"); \
            force_modulo_0; \
            asm("ldg\t gps,0,gps"); \
            asm("nop"); \
            asm("mov\t gps,sps"); \
            asm("pshgc\t sps"); /* no previous gps */ \
            asm("getlo\t " str(_SMsize-1) ",r30"); \
            asm("add\t gps,r30,eps"); /* compute new sps */ \
            asm("pshgc\t sps"); /* preset sync cell */ \
            /* now the bus is ready for departure. Close the door: */ \
            _delaystmt; /*wait*/ ; \
            /*write(1,"gone!\n",6);*/ \
            _gone = 1; \
            asm("nop\nnop\nnop\nnop\nnop\nnop\nnop\nnop\nnop\nnop"); \
            asm("gethi\t __ticket,r30"); /* r30 <- _ticket:*/ \
            asm("add\t r30,__ticket & 0x1fff,r30"); \
            force_modulo_0; \
            asm("ldg\t r30,0,r30"); \
            asm("nop"); \
            asm("stg\t r30,gps,1"); /* set sync cell */ \
      } \
      else { \
           /* I am not the bus driver. I build my private group frame. */ \
           /* Then I have to wait until he has set up shared */ \
           /* memory for me; then I can adjust my shared pointers. */ \
            asm("ldg\t gpp,2,r31"); /* new $ */ \
            asm("pshg\t gps,spp"); \
            asm("pshg\t eps,spp"); \
            asm("pshg\t sps,spp"); \
            asm("pshg\t gpp,spp"); \
            asm("add\t spp,-1,gpp"); \
            asm("pshgc\t spp"); /* @ = 0 */ \
            asm("pshg\t r31,spp"); /* new $ is my ticket number */ \
            while (!_gone) /*wait*/; \
            pprintf(" see gone=1, ticket=%d, $=%d\n",_ticket, $); \
            /* now the value in _SM is valid: */ \
            asm("gethi\t __SM,gps"); /* compute new gps as _SM: */ \
            asm("add\t gps,__SM & 0x1fff,gps"); \
            force_modulo_0; \
            asm("ldg\t gps,0,gps"); \
            asm("nop"); \
            asm("mov\t gps,sps"); \
            asm("getlo\t " str(_SMsize-1) ",r30"); \
            asm("add\t gps,r30,eps"); /* compute new sps */ \
            asm("add\t gps,2,sps"); \
      } \
      /* departure of the bus: _gone=1, and _ticket is fixed */ \
      if (_throwoutcond) { \
            /* I am thrown out of the bus. My membership must be cancelled: */ \
            asm("getlo\t -1,r31"); \
            asm("mpadd\t gps,1,r31"); \
            $ = _old_dollar;    /* restore old $ */ \
            write(1,"thrown out\n",10); \
            /* now remove the frames and reset the stack pointers: */ \
            asm("ldg\t gpp,0,gpp"); \
            asm("mov\t gpp,spp"); \
            asm("popg\t spp,sps"); \
            asm("popg\t spp,eps"); \
            asm("popg\t spp,gps"); \
            _busywait; \
            if (_retry) _redo = 1; \
      } \
      else { \
            /* I ride: synchronize and take off */ \
            asm("bsrg\t spp,forklib_sync"); \
            beginsync { /* enter a synchronous section */\
               _body; \
            }           /* quit a synchronous section */\
            /*if ($==0) write(1,"returned\n",9);*/ \
            /* Now the bus has returned: */ \
            _ticket = 0; \
            _gone = 0; /* re-open ticket automaton */ \
            _redo = 0; \
            /* now remove the frames and reset the stack pointers: */ \
            asm("ldg\t gpp,0,gpp"); \
            asm("mov\t gpp,spp"); \
            asm("popg\t spp,sps"); \
            asm("popg\t spp,eps"); \
            asm("popg\t spp,gps"); \
            $ = _old_dollar;    /* restore old $ value */ \
      } \
      asm("bra CONTINUE"); \
    asm("GONE:"); \
    { \
      /* The bus has gone; I am not allowed to enter. */ \
      $ = _old_dollar;    /* restore old $ */ \
      _busywait; \
      if (_retry) _redo = 1; \
    } \
    asm("CONTINUE:"); \
  } \
  while (_redo); \
} \
/* end of join macro. */


#endif
