/* CRCW Quicksort using fork DC strategy.    C.W. Kessler 11/95 */
/* uses as many processors as there are elements to sort.       */

#include <fork.h>
#include <assert.h>
#include <io.h>

#define N 8
sh int a[] = { 17, 3, 5, -1, 9, 4, 8, 3 };

pr int mine, myindex;

sync void qs( sh int n )
{
 sh int num[3];
 sh int pivot;
 pr int mynewsubgroup;
 num[0] = num[1] = num[2] = 0;
 farm if ($==0) pprintf(" qs(%d)\n", n);
 if (n>2) {
   if ($==0)  pivot = mine;
   if (mine<pivot)       mynewsubgroup = 0;
   else if (mine==pivot) mynewsubgroup = 1;
        else             mynewsubgroup = 2;
   farm pprintf(" mynewsubgroup=%d\n", mynewsubgroup);
   fork ( 3; @=mynewsubgroup; $=mpadd( &(num[mynewsubgroup]), 1) )  {
      farm assert( num[@] < n );
      qs( num[@] );   /* computes local part of myindex */
      if (@==1)  myindex += num[0]; 
      else if (@==2)  myindex += num[0]+num[1];
   }
 } 
 else {
   farm pprintf("trivial case\n");
   if (n==2) {
      num[$] = mine;              /* misuse num[] as temporary storage */
      if (num[1-$] > mine) myindex = 0;  /* the other value is greater */
      else 
      if (num[1-$] < mine) myindex = 1;  /* my value is greater */
      else                 myindex = $;  /* both values are equal */
                             /* to obtain subsequent rank numbers */
   }
   else myindex = 0;
 }
}

main()
{
 start {
   mine = a[$];
   myindex = 0;
   qs( N ); 
   a[myindex] = mine;
 }
 pprintf("%d rank: %d\n", mine, myindex);
 barrier; exit(0);
}

