/**********************************************************************
From marr@dcs.ed.ac.uk  Mon Mar 27 16:25:50 1995
Date: Mon, 27 Mar 1995 15:22:16 +0100
From: Marcus Marr <marr@dcs.ed.ac.uk>
Subject: Fork95 bug in mpmax()?
To: "Christoph W. Kessler" <kessler@TI.Uni-Trier.DE>
Content-Length: 1549
X-Lines: 73
Status: RO

The mpmax() function only works for arrays of positive integers.

eg:
		val[$]=-5;
		val[$]=mpmax(&max,val[$]);
                              ^^^ 
                              max was uninitialized and has value 0
                              in this program run. --- Christoph
	Before mpmax():
		[0.0] array := { -5, -5, -5, -5, -5, -5, -5, -5 }

	After mpmax():
		[0.0] array := { 0, 0, 0, 0, 0, 0, 0, 0 }
		[0.0] max   := 0


I would have hoped for the following behaviour.
inclusive max scan: mpmax(&max,val[0]) --> val[0]
exclusive max scan: mpmax(&max,val[0]) --> minus infinity, or INT_MIN



Secondly, the function cannot be used twice on the same input.  For
example: 

	val[$]=8-($-5)*($-5);
	printf_array(val,nprocs);
	res[$]=mpmax(&max,val[$]);
	printf_array(res,nprocs);
	res[$]=mpmax(&max,val[$]);
	printf_array(res,nprocs);

With output:
	[0.0] initial array:		{ -17, -8, -1, 4, 7, 8, 7, 4 }
	[0.0] after first mpmax():	{ 0, 0, 0, 0, 4, 7, 8, 8 }
	[0.0] after second mpmax():	{ 8, 8, 8, 8, 8, 8, 8, 8 }



Thirdly, I notice that there is no equivalent mpmin() function.  I'm
using the following function:
*/
	sync int mpmin(int *min, int val) {
	    int ret;
	    ret=-mpmax(min,-val);
	    *min=-*min;
	    return ret;
	}

/* To create inclusive functions, I have the following functions: */

sync int minimum(pr int a, pr int b) {
    if (a<=b) return a; else return b;
}

sync int maximum(pr int a, pr int b) {
    if (a>=b) return a; else return b;
}

sync int mpmin_inc(sh int *min, pr int val) {
    return minimum(val,mpmin(min,val));
}

sync int mpmax_inc(sh int *max, pr int val) {
    return maximum(val,mpmax(max,val));
}


/* Thanks for the suggestions. --- Christoph */
