/* PRIME TWINS
 *
 * eratosthenes.c      alternative algorithm, synchronous implementation
 *                     greatly profits from cheap multiplication on SB-PRAM
 *                     (integer division is approx. 300 times more expensive!)
 * C.W. Kessler 1.12.95
 */

#include <fork.h>
#include <io.h>
#include <stdlib.h>
#include <math.h>

#define n 10000

sh int sieb[n];     /* flag array for Eratosthenes */

sync void Eratosthenes( sh int N )
{
  sh int r;
  pr int i;
  
  for (i=$; 2*i<N; i+=__STARTED_PROCS__) {   /* synchronous loop */
     sieb[2*i] = 0;
     sieb[2*i+1] = 1;    /*initialize*/
  }
  for (r=3; r*r<N; r+=2) {   /* sequential synchronous loop */
     /* farm pprintf("Runde r=%d\n", r);*/
     farm
       for (i=$; (i+2)*r<N; i+=__STARTED_PROCS__) {  /* parallel synchronous loop */
         sieb[r*(i+2)] = 0;   /* kill all proper multiples of r */
       }
  }
}

sh int cnt = 0;
sh int iter = 1;

main()
{
  int z;
  int i;

  if ($==0)
     pprintf("Untersuche Bereich 1...%d\n", n);

  start 
     Eratosthenes( n );

  while (1) {
    i = mpadd(&iter,1);           /* self-balancing parallel loop */
    if (6*i>n)  break;            /* exit loop */
    z = 6*i-1;
    if (sieb[z] && sieb[z+2]) {
          mpadd(&cnt,1);
          pprintf(" %d, %d ", z, z+2);
    }
  }
  if ($==0)
     pprintf("\n Das waren %d Primzahlzwillingspaare.\n", cnt);
  barrier;
  exit(0);
}
  
