/* ForkLight code generator, made from lcc1.9's VAX subset code generator */

#include "c.h"

extern int STARTED_PROCS;  /*CWK: compile-time constant, set by -nprocs option */
int STARTED_PROCS = 4;     /*Defaultwert*/
extern int Pcodepar;/*CWK: zur schnellen Parameteruebergabe von emitcode() an emit()*/
extern int Kflag;   /*CWK: if!=0, gen. consistency checking code after closing grps */
int shglobalptr = 0;       /*stack-like allocation of sh global variables*/
                           /*relative to _gsstack */
static char argtyp[32];    /*CWK: gib zu jedem gepassten Parameter Typkuerzel*/

#ifdef DEBUG
#define debug(x,y) if (x) y
static void lprint(Node, char *);
static void nprint(Node);
static char *rnames(unsigned);
static int id;
static Node lhead;

#else
#define debug(x,y)
#endif

static int rflag;      /* != 0 to trace register allocation */
static int shframesize, prframesize;      /* CWK: size of sh/pr activation record */
       int shframedepth;  /* CWK 970902, used in dag.c*/
static int proffset = 0;      /* CWK: vormals offset, current private frame offset */
       int shoffset;      /* CWK: current shared frame offset */
       int resetshoffset=0; /*970903: flag indicates that a new group has just started*/
static int argbuildsize;   /* size of argument build area */
static int argoffset;      /* offset from top of stack for next argument */
static int nregs = FREE_REGS;   /* number of allocatable registers */
static unsigned rmask;      /* rmask&(1<<r) == 0 if register r is free */
static unsigned usedmask;   /* usedmask&(1<<r) == 1 if register r was used */
static int reginfo[] = {   /*      1<<x if op+x is legal; */
   0,         /* 0x1000<<x if op+x needs a register */
#include "reginfo.h"
};
static int sargnr = 0;     /*CWK, zaehlt shared Argumente*/
static int pargnr = 0;     /*CWK, zaehlt private Argumente*/
static int mylabelnr = 1;  /*CWK, labels fuer spezielle Zwecke*/
#define mylabel() (mylabelnr++)

static void genreloads(Node, Node, Symbol);
static Symbol genspill(Node);
static void getreg(Node);
static Node *linearize(Node, Node *, Node);
static int needsreg(Node);
static void putreg(Node);
static void ralloc(Node);
static void restore(unsigned);
static void save(unsigned);
static int spillee(Node, unsigned);
static void spill(int, unsigned, Node);
static unsigned uses(Node);
static int valid(int);
static void Epilog(int);   /*CWK*/
static void retflush(Node);  /*CWK*/

#define typecode(p) (optype(p->op) == U ? I : optype(p->op) == B ? P : optype(p->op))
#define sets(p) ((p)->x.rmask<<(p)->x.reg)

static int besetzt = 0; /*CWK*/

/* firstfreeparreg() - gibt erstes freies Parameter-Register.  CWK */
static int firstfreeparreg()
{
 if (++besetzt > MAX_PARAMS_IN_REGISTER)  assert(0);
    /* darf nie Parreg anfordern und alle besetzt! */
 return besetzt;
}

/* freeallparregs() - gib alle Parameter-Register wieder frei.  CWK */
#define freeallparregs() besetzt=0

/* address - initialize q for addressing expression p+n */
void address(Symbol q, Symbol p, int n) {
   if (p->scope == GLOBAL || p->sclass == STATIC || p->sclass == EXTERN)
      q->x.name = stringf("%s%s%d", p->x.name, n >= 0 ? "+" : "", n);
   else {
      q->x.offset = p->x.offset + n;
      if (p->scope == PARAM) {       /* formaler Parameter */
         q->x.name = stringf("%d(ap)", q->x.offset);  /*CWK*/
      }
      else {                          /* lokale Variable */
        if (p->shared) {
          assert(0);
          q->x.name = stringf("fps+%d /*via address*/", 2+q->x.offset ); /*CWK*/
        }
        else
          q->x.name = stringf("%s+%d /*via address*/", p->x.name , n );
/* Achtung!
 * in asmcode muss hier auf sh locals verzichtet werden.
 */
      }
   }
}

/* asmcode - emit assembly language specified by asm */
void asmcode(char *str, Symbol argv[]) {
   for ( ; *str; str++)
      if (*str == '%' && str[1] >= 0 && str[1] <= 9)
         print("%s", argv[*++str]->x.name);
      else
         print("%c", *str);
   print("\n");
}

/* blockbeg - begin a compound statement */
void blockbeg(Env *e) {
   assert(rmask == (((~0)<<nregs)|1));
   e->rmask = rmask;
   e->proffset = proffset;  /* statt offset CWK */
   e->shoffset = shoffset; /*CWK*/
   assert(shframedepth>=0);
   e->framedepth = shframedepth;  /*970902*/
   if (resetshoffset) {
       print("/*RESET shoffset, vorher %d*/\n",shoffset);
       shoffset = 0; /*970903*/
       resetshoffset = 0;
   }
}

/* blockend - end a compound statement */
void blockend(Env *e) {
   //if (proffset > prframesize)   prframesize = proffset;  /*CWK*/
   if (shoffset > shframesize)   shframesize = shoffset;  /*CWK*/
   //proffset = e->proffset;
   shoffset = e->shoffset;
   shframedepth = e->framedepth;  /*970902*/
   rmask = e->rmask;
}

/* defconst - define a constant */
void defconst(int ty, Value v, int ignore) { // 980720
 if (ignore) {
   error("initializers for global shared variables not supported, sorry!\n");
   print("/*");
 }
 switch (ty) {
   case C: print("%d;\n",   v.uc); break;
   case S: print("%d;\n",   v.us); break;
   case I: print("%d;\n",   v.i ); break;
   case U: print("0x%x;\n", v.u ); break;
   case P: print("0x%x;\n", v.p ); break;
#ifdef vax
   case F:
      print(".long 0x%x\n", ((unsigned *) &v.f)[0]);
      break;
   case D: 
      print(".long 0x%x,0x%x\n", ((unsigned *) &v.d)[0],
         ((unsigned *) &v.d)[1]);
      break;
#else
   case F: {
      char buf[MAXLINE];
      /*sprintf(buf, ".float 0f%.8e\n", v.f);*/
      sprintf(buf, "%.8e;\n", v.f); /*fl*/
      outs(buf);
      break;
      }
   case D: {
      char buf[MAXLINE];
      /*sprintf(buf, ".double 0d%.18e\n", v.d);*/
      sprintf(buf, "%.18lf;\n", v.d); /*fl*/
      outs(buf);
      break;
      }
#endif
   default: assert(0);
   }
   if (ignore) 
     print("*/\n");
}

/* defstring - emit a string constant */
void defstring(int len, char *s) {
   print("\"");       /*CWK*/
   while (len-- > 0)
      if (isspace(*s) && *s!=' ' || iscntrl(*s))
         switch(*s++) {
            case '\n': print("\\n");break;
            case '\t': print("\\t");break;
            case '\f': print("\\f");break;
            case '\r': print("\\r");break;
            case '\v': print("\\v");break;
            default: print("\\%o", *(s-1) ); break;  /*control characters*/
         }
      else
         print("%c", *s++);
      /*print(".byte %d\n", *s++); CWK 950331*/
   print("\";\n");       /*CWK*/
}

/* defsymbol - initialize p's Xsymbol fields */
void defsymbol(Symbol p) {
   if (p->scope == CONSTANTS)
      p->x.name = p->name;
   else if (p->scope >= LOCAL && p->sclass == STATIC)
      p->x.name = stringf("L%d", genlabel(1));
   else if (p->generated)  // jump labels and outofline constants
      p->x.name = stringf("L%s", p->name);
   else
      p->x.name = stringf("%s", p->name); /*FL*/
      /* vorher p->x.name = stringf("_%s", p->name);*/
}

        /* " FDCSIUPVB" */
#define suffix(p)    ".fdbwllll."[optype((p)->op)]
/*#define binary(inst) print("%s%c3 r%d,r%d,r%d\n", inst, suffix(p), \CWK*/
#define prebinary(inst) print("r%d = %s(r%d,r%d);\n", r, inst, \
                        a->x.reg+ROFF, b->x.reg+ROFF)
#define dprebinary(inst) print("dr%d = %s(dr%d,dr%d);\n", r, inst, \
                        a->x.reg+ROFF, b->x.reg+ROFF)
#define binary(inst) print("r%d = r%d %s r%d;\n", r, a->x.reg+ROFF, inst, b->x.reg+ROFF)
#define fbinary(inst) print("fr%d = fr%d %s fr%d;\n", r, a->x.reg+ROFF, inst, b->x.reg+ROFF)
#define dbinary(inst) print("dr%d = dr%d %s dr%d;\n", r, a->x.reg+ROFF, inst, b->x.reg+ROFF)
/*#define unary(inst)  print("%s%c r%d,r%d\n", inst, suffix(p), a->x.reg, r)CWK*/
#define unary(inst)  print("r%d = %s r%d;\n", r, inst, a->x.reg+ROFF)
#define funary(inst)  print("fr%d = %s r%d;\n", r, inst, a->x.reg+ROFF)
#define funaryf(inst)  print("fr%d = %s fr%d;\n", r, inst, a->x.reg+ROFF)
/*#define compare(cp)  print("cmp%c r%d,r%d; j%s %s\n", suffix(p), \CWK*/
                        /*a->x.reg, b->x.reg, cp, p->syms[0]->x.name)*/
#define compare(cp)  print("if (r%d %s r%d) goto %s;\t /*compare*/\n", \
                        a->x.reg+ROFF, cp, b->x.reg+ROFF, p->syms[0]->x.name)
#define fcompare(fcp)  print("if (fr%d %s fr%d) goto %s;\t /*fcompare*/\n", \
                        a->x.reg+ROFF, fcp, b->x.reg+ROFF, p->syms[0]->x.name)
#define dcompare(dcp)  print("if (dr%d %s dr%d) goto %s;\t /*dcompare*/\n", \
                        a->x.reg+ROFF, dcp, b->x.reg+ROFF, p->syms[0]->x.name)
/*PRAM: sub b,a,x bedeutet x = a - b. CWK*/

/* emit - emit the dags on list p */
void emit(Node p) {
   int parreg;  /*CWK*/
   int label1, label2;  /*CWK*/
   for (; p; p = p->x.next) {
      Node a = p->kids[0], b = p->kids[1];
      int r = p->x.reg+ROFF;  /*CWK: Registernummer - Offset*/
      if (p->ignore) {  /*CWK 980716*/
         print(" /* ignored a node */\n");
         continue;
      }
      switch (p->op) {
      case BANDU:                         binary("&");   break; /*CWK*/
      case BORU:                          binary("|");   break; /*CWK*/
      case BXORU:                         binary("^");   break; /*CWK*/
      case ADDD:                          dbinary("+");   break; /*CWK*/
      case ADDF:                          fbinary("+");   break; /*CWK*/
      case ADDI:  case ADDU:  binary("+");   break;
      case ADDP:  if (ismyaddrop(p->kids[0]->op) && ismyaddrop(p->kids[1]->op))
                    print("pr%d = pr%d + (int)pr%d;   /*ADDP*/\n",
                       r, a->x.reg+ROFF, b->x.reg+ROFF); 
                  else
                  if (ismyaddrop(p->kids[0]->op) && !ismyaddrop(p->kids[1]->op))
                    print("pr%d = pr%d + r%d;   /*ADDP*/\n",
                       r, a->x.reg+ROFF, b->x.reg+ROFF); 
                  else
                  if (!ismyaddrop(p->kids[0]->op) && ismyaddrop(p->kids[1]->op))
                    print("pr%d = pr%d + r%d;   /*ADDP*/\n",
                       r, b->x.reg+ROFF, a->x.reg+ROFF); 
                  else { // (!ismyaddrop(p->kids[0]) && !ismyaddrop(p->kids[1]))
                    print("pr%d = (void *)(r%d + r%d);   /*ADDP*/\n",
                       r, a->x.reg+ROFF, b->x.reg+ROFF); 
                    assert(0);
                  }
                  break;
      case SUBD:                          dbinary("-");   break;
      case SUBF:        		  fbinary("-");   break;
      case SUBI:  case SUBU:  binary("-");   break;
      case SUBP:  print("pr%d = pr%d - r%d;   /*SUBP*/\n", 
                           r,    a->x.reg+ROFF, b->x.reg+ROFF);
                    // Tausch a b ???
                 break;
      case MULD:                          dbinary("*");   break; /*CWK*/
      case MULF:                          fbinary("*");   break; /*CWK*/
      case MULI:  case MULU:              binary("*");   break; /*CWK*/
      case DIVD:              
         print("dr%d = dr%d / dr%d;\t /*DIVD*/\n", r, a->x.reg+ROFF, b->x.reg+ROFF); 
         break;
      case DIVF:
         print("fr%d = fr%d / fr%d;\t /*DIVF*/\n", r, a->x.reg+ROFF, b->x.reg+ROFF); 
         break;
      case DIVI:  case DIVU:              binary("/"); break;
         print("r%d = r%d / r%d;\t /*DIVI*/\n", r, a->x.reg+ROFF, b->x.reg+ROFF); 
         break;
      case MODI:  /* a%b == a - (a/b)*b  */
         print("r%d = r%d %% r%d;\t /*MODI*/\n",
                r, a->x.reg+ROFF, b->x.reg+ROFF);
         break;
      case MODU:  /* a%b == a - (a/b)*b  */
         print("r%d = r%d %% r%d;\t /*MODU*/\n",
                r, a->x.reg+ROFF, b->x.reg+ROFF);
         break;
      case ILOG2I:
         print("r%d = _ilog2(r%d);  \t /*ILOG2*/\n", r, a->x.reg+ROFF);
         break;
      case MPADDI:                                                    /*CWK*/
         print("r%d = fetch_add((void **)pr%d,r%d);\t /*MPADD*/\n",
                r, a->x.reg+ROFF, b->x.reg+ROFF);            /*CWK*/
         break;
      case MPANDI:                                                    /*CWK*/
         error("mpand() does not exist in ForkLight. Try to use fetch_add().\n");
         print("r%d = fetch_and(r%d,r%d);\t /*MPAND*/\n",
                r, a->x.reg+ROFF, b->x.reg+ROFF);            /*CWK*/
         break;
      case MPMAXI:                                                    /*CWK*/
         error("mpmax() does not exist in ForkLight. Try to use fetch_add().\n");
         print("r%d = fetch_max(r%d,r%d);\t /*MPMAX*/\n",
                r, a->x.reg+ROFF, b->x.reg+ROFF);            /*CWK*/
         break;
      case MPORI:                                                     /*CWK*/
         error("mpor() does not exist in ForkLight. Try to use fetch_add().\n");
         print("r%d = fetch_or(r%d,r%d);\t /*MPOR*/\n",
                r, a->x.reg+ROFF, b->x.reg+ROFF);            /*CWK*/
         break;
      case RSHU:
         /*print("subl3 r%d,$32,r0; extzv r%d,r0,r%d,r%d\n",
            b->x.reg, b->x.reg, a->x.reg, r); */
         print("r%d = r%d >> r%d;\t /*RSHU*/\n",         /*CWK*/
            r, a->x.reg+ROFF, b->x.reg+ROFF);
         break;
      case RSHI:       /* lsr statt asr CWK 950306 */
         print("r%d = r%d >> r%d;\t /*RSHI*/\n",
                r, a->x.reg+ROFF, b->x.reg+ROFF );
         break;
      case LSHI: 
         print("r%d = r%d << r%d;\t /*LSHI*/\n", r, a->x.reg+ROFF, b->x.reg+ROFF );
         break;
      case LSHU:
         print("r%d = r%d << r%d;\t /*LSHU*/\n", r, a->x.reg+ROFF, b->x.reg+ROFF );
         break;
      case INDIRB:
         /*print("moval (r%d),r%d\n", a->x.reg+ROFF, r);*/
         if (a->syms[0] && a->syms[0]->shared)
           print("_SMread( (void **)pr%d, pr%d, %s);\t /*INDIRB shared*/\n",
                  r, a->x.reg+ROFF, p->syms[0]->x.name );
         else {
           if (!a->syms[0]) {
             print("if (_isshared((void**)pr%d))\n", a->x.reg+ROFF);
             print("_SMread( (void **)pr%d, pr%d, %s);\t /*INDIRB if shared*/\n",
                    r, a->x.reg+ROFF, p->syms[0]->x.name );
             print("else\n");
           }
           print("memcpy( pr%d, pr%d, %s);\t /*INDIRB private*/\n",
                  r, a->x.reg+ROFF, p->syms[0]->x.name );
         }
         break;
      case INDIRD:
         if (a->syms[0] && a->syms[0]->shared)
           print("_SMread( (void **)&dr%d, (void *)pr%d, 8);\t /*INDIRD shared*/\n", r, a->x.reg+ROFF);
         else {
           if (!a->syms[0]) {
             print("if (_isshared((void**)pr%d))\n", a->x.reg+ROFF);
             print("_SMread( (void **)&dr%d, (void *)pr%d, 8);\t /*INDIRD if shared*/\n", r, a->x.reg+ROFF);
             print("else\n");
           }
           print("dr%d = *((double *)pr%d);\t /*INDIRD private*/\n", r, a->x.reg+ROFF);
         }
         break;
      case INDIRF:
         if (a->syms[0] && a->syms[0]->shared)
           print("_SMread( (void **)&fr%d, (void *)pr%d, %d);\t /*INDIRF shared*/\n",
                  r, a->x.reg+ROFF, floattype->size);
         else {
           if (!a->syms[0]) {
             print("if (_isshared((void**)pr%d))\n", a->x.reg+ROFF);
             print("_SMread( (void **)&fr%d, (void *)pr%d, %d);\t /*INDIRF if shared*/\n", 
                    r, a->x.reg+ROFF, floattype->size);
             print("else\n");
           }
           print("fr%d = *((float *)pr%d);\t /*INDIRF private*/\n", r, a->x.reg+ROFF);
         }
         break;
      case INDIRC: 
         if (a->syms[0] && a->syms[0]->shared)
           print("_SMread( (void **)&r%d, (void *)pr%d, 1);\t /*INDIRC shared*/\n", r, a->x.reg+ROFF);
         else {
           if (!a->syms[0]) {
             print("if (_isshared((void**)pr%d))\n", a->x.reg+ROFF);
             print("_SMread( (void **)&r%d, (void *)pr%d, 1);\t /*INDIRC if shared*/\n", r, a->x.reg+ROFF);
             print("else\n");
           }
           print("r%d = (char)*((char *)pr%d);\t /*INDIRC private*/\n", r, a->x.reg+ROFF);
         }
         break;
      case INDIRI:
      case INDIRS:
         if (a->syms[0] && a->syms[0]->shared)
           print("_SMread( (void **)&r%d, (void *)pr%d, %d);\t /*INDIRI shared*/\n",
                   r, a->x.reg+ROFF, inttype->size);
         else {
           if (!a->syms[0]) {
             print("if (_isshared((void**)pr%d))\n", a->x.reg+ROFF);
             print("_SMread( (void **)&r%d, (void *)pr%d, %d);\t /*INDIRI if shared*/\n",
                   r, a->x.reg+ROFF, inttype->size);
             print("else\n");
           }
           print("r%d = (int)*((void **)pr%d);\t /*INDIRI private*/\n", r, a->x.reg+ROFF);
         }
         break;
      case INDIRP:
         if (a->syms[0] && a->syms[0]->shared)
           print("_SMread( (void **)&pr%d, (void *)pr%d, %d);\t /*INDIRP shared*/\n", 
                 r, a->x.reg+ROFF, voidptype->size);
         else {
           if (!a->syms[0]) {
             print("if (_isshared((void**)pr%d))\n", a->x.reg+ROFF);
             print("_SMread( (void **)&pr%d, (void *)pr%d, %d);\t /*INDIRP if shared*/\n", 
                    r, a->x.reg+ROFF, voidptype->size);
             print("else\n");
           }
           print("pr%d = *((void **)pr%d);\t /*INDIRP private*/\n", r, a->x.reg+ROFF);/*CWK*/
         }
         break;
      case BCOMU:
         print("r%d = ~r%d;\n", r, a->x.reg+ROFF); 
         break;
      case NEGD:  case NEGF:
         print("fr%d = ((double)fr%d<0.0000001);\t /*NEGF*/\n", r, a->x.reg+ROFF);
         break;
      case NEGI:
         print("r%d = !r%d;\t /*NEGI*/\n", r, a->x.reg+ROFF); break;
      /* PRAM: D=F und C=S=U=I=P  CWK*/
      case CVDI: print("r%d = (int)dr%d;\t /*CVDI*/\n", r, a->x.reg+ROFF); break;
      case CVID: print("dr%d = (double)r%d;\t /*CVID*/\n", r, a->x.reg+ROFF); break;
      case CVCI: print("r%d = (int)r%d;\t /*CVCI*/\n", r, a->x.reg+ROFF); break;
      case CVCU: print("r%d = (unsigned int)r%d;\t /*CVCU*/\n", r, a->x.reg+ROFF); break;
      case CVSI: print("r%d = (int)r%d;\t /*CVSI*/\n", r, a->x.reg+ROFF); break;
      case CVSU: print("r%d = (unsigned int)r%d;\t /*CVSU*/\n", r, a->x.reg+ROFF); break;
      case CVDF: print("fr%d = (float)dr%d;\t /*CVDF*/\n", r, a->x.reg+ROFF); break;
      case CVFD: print("dr%d = (double)fr%d;\t /*CVFD*/\n", r, a->x.reg+ROFF); break;
      case CVUC: print("r%d = (char)r%d;\t /*CVUC*/\n", r, a->x.reg+ROFF); break;
      case CVUS: print("r%d = (int)r%d;\t /*CVUS*/\n", r, a->x.reg+ROFF); break;
      case CVIC: print("r%d = (char)r%d;\t /*CVIC*/\n", r, a->x.reg+ROFF); break;
      case CVIS: print("r%d = (int)r%d;\t /*CVIS*/\n", r, a->x.reg+ROFF); break;
      case CVIU: print("r%d = (unsigned int)r%d;\t /*CVIU*/\n", r, a->x.reg+ROFF); break;
      case CVUI: print("r%d = (int)r%d;\t /*CVUI*/\n", r, a->x.reg+ROFF); break;
      case CVPU: print("r%d = pr%d;\t /*CVPU*/\n", r, a->x.reg+ROFF); break;
      case CVUP: print("pr%d = (void *)r%d;\t /*CVUP*/\n", r, a->x.reg+ROFF); break;
      case RETD:
         retflush(p);    if (!cfunc->sync) assert(p->rframes==0);
         Epilog(cfunc->sync);                            /*endet auf mo==0*/
         print("return dr%d;\t /*RETD*/\n", a->x.reg+ROFF);
         break;
      case RETF:
         retflush(p);    if (!cfunc->sync) assert(p->rframes==0);
         Epilog(cfunc->sync);                            /*endet auf mo==0*/
         print("return fr%d;\t /*RETF*/\n", a->x.reg+ROFF);
         break;
      case RETI:
         retflush(p);    if (!cfunc->sync) assert(p->rframes==0);
         Epilog(cfunc->sync);                            /*endet auf mo==0*/
         print("return r%d;\t /*RETI*/\n", a->x.reg+ROFF);
         break;
      case SRETD:
         error("No shared return value in ForkLight!\n");
         break;
      case SRETF:
         error("No shared return value in ForkLight!\n");
         break;
      case SRETI:
         error("No shared return value in ForkLight!\n");
         break;
      case RETV:
         retflush(p);
         Epilog(cfunc->sync);     /*endet auf mo==?*/
         print("return;\t /*RETV*/\n");
         break;
      case ADDRGP: /* vorher Basisregister setzen! */ /*CWK*/
         print("{ extern %s;\n", 
                    typestring( p->syms[0]->type, p->syms[0]->x.name ));
         print("  pr%d = &%s;}\t /*ADDRGP*/\n", r, p->syms[0]->x.name );
#if 0
         if (isarray(p->syms[0]->type))   /*Notnagel 980709*/
            print("  pr%d = *((%s *)pr%d);\t /*ADDRGP2*/\n", r, 
                typestring( atop(p->syms[0]->type),""), r );
#endif
         break;
      case ADDRLP:
         print("pr%d = &%s;\t /*ADDRLP*/\n", r, p->syms[0]->x.name);
         // keine Klammern um Name, weil sonst via address nicht funktioniert
#if 0
         if (isarray(p->syms[0]->u.c.loc->type)) {
           print("getlo\t %s,r31\n", p->syms[0]->u.c.loc->type->size );
           print("sub\t r31,r%d,r%d /*ADDRLP-Korrektur*/\n", r,r); /*950320*/
         }
#endif
         break;
      case ADDRFP:
         print("pr%d = &%s;\t /*ADDRFP*/\n", r, p->syms[0]->name, r);
                                    /* statt x.name 980709*/
         break; /*weil der lcc fuer Parameter trotzdem Indirektionen einfuegt */
      case CNSTC:
         print("r%d = %s;\t /*CNSTC*/\n", r, p->syms[0]->x.name);
         break;
      case CNSTP:
         print("pr%d = %s;\t /*CNSTP*/\n", r, p->syms[0]->x.name);
         break;
      case CNSTS:
         print("r%d = %s;\t /*CNSTS*/\n", r, p->syms[0]->x.name);
         break;
      case CNSTU:
         print("r%d = %s;\t /*CNSTU*/\n", r, p->syms[0]->x.name);
         break;
      case CNSTI:
         print("r%d = %s;\t /*CNSTI*/\n", r, p->syms[0]->x.name);
         break;
      case JUMPV:
         if (p->kids[0]->op==ADDRGP) /*CWK 980716*/
            print("goto %s;\t /*JUMPV1*/\n\n", p->kids[0]->syms[0]->x.name);
         else
            print("_jump(r%d);\t /*JUMPV*/\n", a->x.reg+ROFF);/*CWK*/
         break;
      case ASGNB:
         if (a->syms[0] && a->syms[0]->shared)
           print("_SMwrite((void **)pr%d, pr%d, %s);\t /*ASGNB shared*/\n", 
                    a->x.reg+ROFF, b->x.reg+ROFF, p->syms[0]->x.name);
         else {
           if (!a->syms[0]) {
             print("if (_isshared((void**)pr%d))\n", a->x.reg+ROFF);
             print("_SMwrite((void **)pr%d, pr%d, %s);\t /*ASGNB shared*/\n", 
                    a->x.reg+ROFF, b->x.reg+ROFF, p->syms[0]->x.name);
             print("else\n");
           }
           print("memcpy(pr%d,pr%d,%s);\t /*ASGNB*/\n",
                    a->x.reg+ROFF, b->x.reg+ROFF, p->syms[0]->x.name);
         }
         break;
      case ASGND:
         if (a->syms[0] && a->syms[0]->shared)
           print("_SMwrite((void **)pr%d, (void *)&dr%d, 8);\t /*ASGND shared*/\n", 
                    a->x.reg+ROFF, b->x.reg+ROFF);
         else {
           if (!a->syms[0]) {
             print("if (_isshared((void**)pr%d))\n", a->x.reg+ROFF);
             print("_SMwrite((void **)pr%d, (void *)&dr%d, 8);\t /*ASGND if shared*/\n", 
                    a->x.reg+ROFF, b->x.reg+ROFF);
             print("else\n");
           }
           print("*((double *)pr%d) = dr%d;\t /*ASGND*/\n", a->x.reg+ROFF, b->x.reg+ROFF);
         }
         break;
      case ASGNF:
         if (a->syms[0] && a->syms[0]->shared)
           print("_SMwrite((void **)pr%d, _ftovp(fr%d), %d);\t /*ASGNF shared*/\n", 
                    a->x.reg+ROFF, b->x.reg+ROFF, floattype->size);
         else {
           if (!a->syms[0]) {
             print("if (_isshared((void**)pr%d))\n", a->x.reg+ROFF);
             print("_SMwrite((void **)pr%d, _ftovp(fr%d), %d);\t /*ASGNF if shared*/\n", 
                    a->x.reg+ROFF, b->x.reg+ROFF, floattype->size);
             print("else\n");
           }
           print("*((float *)pr%d) = fr%d;\t /*ASGNF*/\n", a->x.reg+ROFF, b->x.reg+ROFF);
         }
         break;
      case ASGNC:
         if (a->syms[0] && a->syms[0]->shared)
           print("_SMwrite((void **)pr%d, (void *)r%d, 1);\t /*ASGNC shared*/\n", 
                    a->x.reg+ROFF, b->x.reg+ROFF);
         else {
           if (!a->syms[0]) {
             print("if (_isshared((void**)pr%d))\n", a->x.reg+ROFF);
             print("_SMwrite((void **)pr%d, (void *)r%d, 1);\t /*ASGNC if shared*/\n", 
                    a->x.reg+ROFF, b->x.reg+ROFF);
             print("else\n");
           }
           print("*(char *)pr%d = r%d;\t /*ASGNC*/\n", a->x.reg+ROFF, b->x.reg+ROFF);
         }
         break;
      case ASGNI: 
      case ASGNS:
         if (a->syms[0] && a->syms[0]->shared)
           print("_SMwrite((void **)pr%d, (void *)r%d, %d);\t /*ASGNI shared*/\n", 
                    a->x.reg+ROFF, b->x.reg+ROFF, inttype->size);
         else {
           if (!a->syms[0]) {
             print("if (_isshared((void**)pr%d))\n", a->x.reg+ROFF);
             print("_SMwrite((void **)pr%d, (void *)r%d, %d);\t /*ASGNI if shared*/\n", 
                    a->x.reg+ROFF, b->x.reg+ROFF, inttype->size);
             print("else\n");
           }
           print("*((int *)pr%d) = r%d;\t /*ASGNI*/\n", a->x.reg+ROFF, b->x.reg+ROFF);
         }
         break;
      case ASGNP:
         if (a->syms[0] && a->syms[0]->shared)
           print("_SMwrite((void **)pr%d, pr%d, %d);\t /*ASGNP shared*/\n", 
                    a->x.reg+ROFF, b->x.reg+ROFF, voidptype->size);
         else {
           if (!a->syms[0]) {
             print("if (_isshared((void**)pr%d))\n", a->x.reg+ROFF);
             print("_SMwrite((void **)pr%d, pr%d, %d);\t /*ASGNP if shared*/\n", 
                    a->x.reg+ROFF, b->x.reg+ROFF, voidptype->size);
             print("else\n");
           }
           print("*((void **)pr%d) = pr%d;\t /*ASGNP private*/\n",
                    a->x.reg+ROFF, b->x.reg+ROFF);
         }
         break;
      /* case ARGB kann nicht vorkommen! NOARGB eingeschaltet CWK */
      case ARGB: assert(0);
         /*save(p->x.busy&0x3f);*/
         print("movc3 $%s,(r%d),%d(sp)   ARGB  \n", p->syms[0]->x.name,
            a->x.reg+ROFF, p->x.argoffset);
         /*restore(p->x.busy&0x3f);*/
         break;
      case ARGD:
         argtyp[pargnr++] = 'd';
         print("dpar%d = dr%d;\t /*ARGD Nr.%d*/\n", pargnr, a->x.reg+ROFF,pargnr);
         break;
      case ARGF:
         argtyp[pargnr++] = 'f';
         print("fpar%d = fr%d;\t /*ARGF Nr.%d*/\n", pargnr, a->x.reg+ROFF,pargnr);
         break;
      case ARGP:
         argtyp[pargnr++] = 'p';
         print("ppar%d = pr%d;\t /*ARGP Nr.%d*/\n", pargnr, a->x.reg+ROFF,pargnr);
         break;
      case ARGI:
         argtyp[pargnr++] = 'i';
         print("ipar%d = r%d;\t /*ARGI Nr.%d*/\n", pargnr, a->x.reg+ROFF,pargnr);
         break;
      /* case RARGB kann nicht vorkommen! NOARGB eingeschaltet   CWK*/
      case RARGD: case RARGF: case RARGI: case RARGP:          /*CWK*/
         assert(0);   /*nicht vorgesehen in FL*/
         parreg = firstfreeparreg();   /* liefert 1..4 */
         print("par%d = r%d\t /*RARGx*/\n", parreg, a->x.reg+ROFF );
         break;
      /* case SARGB kann nicht vorkommen! NOARGB eingeschaltet   CWK*/
      case SARGD: case SARGF: case SARGI: case SARGP: case SARGV:  /*CWK*/
         /* in FL: nicht erlaubt! */
         error("shared arguments not allowed in ForkLight!\n");
         break;
      case CALLB:   /*961104 bisher assert(0);     /*CWK: unverarzteter Fall */
         error("Function returning a struct would lead to inefficient code.\n\
                Please pass the result via a pointer to work around.\n");
         /*Der Rest funktioniert noch nicht. CWK 961104*/
         break;
      case CALLD: case CALLF: case CALLI: case CALLV:
         freeallparregs();  /*CWK*/
         /* Es gibt keine shared Argumente mehr in FL und daher keinen aps. */
         if (a->syms[0]) {
            //print("/* call function %s: */\n", a->syms[0]->name );
            if (p->op == CALLV) 
               print("%s(/*CALLV*/ ", a->syms[0]->name);
            else
            if (p->op == CALLF)
               print("fr%d = %s(/*CALLF*/ ", r, a->syms[0]->name);
            else
            if (p->op == CALLD)
               print("dr%d = %s(/*CALLD*/ ", r, a->syms[0]->name);
            else
               print("r%d = (int)%s(/*CALLI*/ ", r, a->syms[0]->name);
         }
         else {
            print("/* call function via function pointer */\n");
            if (p->op == CALLV) {
               print("{ void (*_xxxxy)() = pr%d;\t /*CALLV*/\n", a->x.reg+ROFF);
               print("  (*_xxxxy)(/*CALLV*/ ");
            }
            else
            if (p->op == CALLF) {
               print("{ float (*_xxxxy)() = pr%d;\t /*CALLF*/\n", a->x.reg+ROFF);
               print("  fr%d = (*_xxxxy)(/*CALLF*/ ", r); /*1*/
            }
            else
            if (p->op == CALLD) {
               print("{ double (*_xxxxy)() = pr%d;\t /*CALLD*/\n", a->x.reg+ROFF);
               print("  dr%d = (*_xxxxy)(/*CALLD*/ ", r); /*1*/
            }
            else {
               print("{ int (*_xxxxy)() = pr%d;\t /*CALLI*/\n", a->x.reg+ROFF);
               print("  r%d = (*_xxxxy)(/*CALLI*/ ", r);
            }
         }
         /* print string of parameters 980709:*/
         { int j;
           for (j=1; j<pargnr; j++) print("%cpar%d,", argtyp[j-1], j);
           if (pargnr) print("%cpar%d", argtyp[pargnr-1], pargnr);
         }
         if (a->syms[0]) print(");\t /*CALL*/\n");
         else            print(");}\t /*CALL via pointer*/\n");
         if (p->synchron) {
            // print("barrier(); /*=======(CALL sync)=*/\n");
            // in FL weg nach Vorschlag von Helmut
         }
         /*restore(p->x.busy&0xfff);*/
         pargnr = 0;        /*reset. CWK*/
         break;
      case EQF:   fcompare("=="); break; /*feql CWK 951128*/
      case EQD:   dcompare("=="); break; /*feql CWK 951128*/
      case EQI:   compare("==" ); break; /*eql*/
      case GEF:   fcompare(">=" ); break;
      case GED:   dcompare(">=" ); break;
      case GEI:   compare(">=" ); break; /*geq*/
      case GEU:   compare(">="); break; /*gequ*/
      case GTF:   fcompare(">" ); break;
      case GTD:   dcompare(">" ); break;
      case GTI:   compare(">" ); break; /*gtr*/
      case GTU:   compare(">"); break; /*gtru*/
      case LEF:   fcompare("<=" ); break;
      case LED:   dcompare("<=" ); break;
      case LEI:   compare("<=" ); break; /*leq*/
      case LEU:   compare("<="); break; /*lequ*/
      case LTF:   fcompare("<" ); break;
      case LTD:   dcompare("<" ); break;
      case LTI:   compare("<" ); break; /*lss*/
      case LTU:   compare("<"); break; /*lssu*/
      case NEF:   fcompare("!=" ); break;
      case NED:   fcompare("!=" ); break;
      case NEI:   compare("!=" ); break; /*neq*/
      case LABELV:
         print("%s:\n", p->syms[0]->x.name);
         break;
      case ADDRREGB: case ADDRREGF: case ADDRREGD: case ADDRREGP:
      case ADDRREGI:        assert(0);   /*CWK: vorerst nicht benutzen!*/
         print("MOV par%d,r%d /*ADDRREGx %s r%d*/\n", p->syms[0]->parreg, r,
                p->syms[0]->x.name, r);
         break;
      case ADR_PROZ_NUMP:                                   /*CWK*/
         print("pr%d = _gpp+7;\t /*load addr of $*/\n", r);
         break;
      case ADR_GRP_NUMP:                                    /*CWK*/
         print("pr%d = _gpp+6;\t /*load addr of @*/\n", r);
         break;
      case ADDRSGP:
         if (!isfunc(p->syms[0]->type)) {
           print("{extern int %s;/*ADDRSGP*/\n", p->syms[0]->x.name);
           print(" pr%d = (void*)&(_gsstack[%s]);} /*ADDRSGP*/\n", r, p->syms[0]->x.name);
         }
         else
           print(" pr%d = %s; /*ADDRSGP*/\n", r, p->syms[0]->x.name);
         break;
      case ADDRSLP:
         /* Bemerkung: fuer FL kann der fps ganz eliminiert werden,
          * wenn man fuer synchrone Funktionen immer einen
          * eigenen Gruppenframe anlegt. Daher Fall 1 auskommentiert*/
#if 0
         /* 970903*/
         if (p->syms[0]->x.framedepth == 0)  /* access at top level of fn. */
           if (!cfunc->sync)  /*980129: start bastelt einen fake-fps!*/
             print("r%d = fps+%d\t /*ADDRSLP a*/\n", r, 1+p->syms[0]->x.offset);
           else
             print("r%d = fps+%d\t /*ADDRSLP b*/\n", r, 1+p->syms[0]->x.offset);
               /*vorher 2 statt 1 ^ da Fn-Grfr. dazw., jetzt retval weg */
         else   /*framedepth > 0:*/
#endif
         if (p->shframedepth - p->syms[0]->x.framedepth == 1) {  /*new 970902*/
           print(" pr%d = (void**)_gpp[3]+%d;\t /*ADDRSLP Leveldiff = 1 = %d - %d*/\n",
                    r,       /* 4* */(4 + p->syms[0]->x.offset/voidptype->size),
                    p->shframedepth, p->syms[0]->x.framedepth ); 
         }
         else
         if (p->shframedepth - p->syms[0]->x.framedepth > 1) {  /*new 970902*/
           int j;
           print("{void **r31 = _gpp[0];  /*ADDRSLP, Leveldiff=%d = %d-%d*/\n",
             p->shframedepth - p->syms[0]->x.framedepth,
             p->shframedepth, p->syms[0]->x.framedepth);
           for ( j=p->shframedepth - p->syms[0]->x.framedepth - 1; j>1; j--)
             print(" r31 = *r31; /*ADDRSLP, nested(%d)*/\n", j);
           print(" r31 = *(r31+3); /*ADDRSLP, nested(1)*/\n");
           print(" pr%d = r31+%d; }\t /*ADDRSLP c*/\n",
                    r,      4 + p->syms[0]->x.offset/voidptype->size);
         }
         else  /*declared by same group:*/
           print("pr%d = &(_gps[%d]);\t /*ADDRSLP same level*/\n", 
                  r,       4 + p->syms[0]->x.offset/voidptype->size);
         break;
      case ADDRSFP:
         assert(0);   /*in FL nicht moeglich*/
         print("r%d = %s\t /*ADDRSFP*/\n", r, p->syms[0]->x.name);
         break; /*weil der lcc fuer Parameter trotzdem Indirektionen einfuegt*/

      case SYNCV:                /*CWK*/
         /*falls Moduloausgleich erforderlich, hier einfuegen. Start mit mo==0*/
         /*assert( p->synchron==1 );  /*cfunc->synchron && rausgeworfen 950324*/
         print("barrier();\t /*==========SYNCV==*/\n");
         break;

     case SHSPACEV:                       /*970902*/
         /* allocate space for shared block-local variables */
         if (Pcodepar > 0)
            print("_sps += %d;\t /*alloc. stack space for sh locals*/\n",
                   (Pcodepar+3)/voidptype->size );
         break;

      case SPLITV:                /*CWK: berechne Trennzelle im SM*/
#if 0
         print("_SLICESIZE = (int)(_eps-_sps) >> 3;\t /*split*/\n");
         print("_NROFSUBGROUPS = 2;\t /*split*/\n");
#endif
         print("_makegroupframe( %d );\t /*SPLITV*/\n", Pcodepar);
         break;

      case NEXTCASEV:                /*CWK, dummy*/
         /* Pcodepar==0 -> then,  ==1 -> else. */
#if 0
         /* Die Adresse der Trennzelle liegt oben auf dem pStack. */
         print("_pop(&Ret,1);\t /*nextcase%d*/\n", Pcodepar);            /*0*/
#endif
         /* lege shared Gruppenframe an: */
         print("_entergroup(%d);\t /*nextcase%d*/\n", Pcodepar, Pcodepar );
         break;

      case LGRPIFV:                /*CWK*/
         if (Pcodepar==2)
            print("_leavegroup();\t /*LGRPIF*/\n");               /*0*/
         else if (Pcodepar==1)
            print("_leaveprivategroup();\t /*LGRPIF*/\n");               /*0*/
         else assert(0);
         break;

      case MKGRPV:                /*CWK, a->x.reg+ROFF enthaelt Gruppengroesse */
         /* ...berechne Aufteilung des SM:*/
         /* jeder Proz. $ legt priv. Gruppenframe an, einige den shared G.: */
         print("_makegroupframe(r%d);\t /*mkgrp*/\n", a->x.reg+ROFF);
         break;

      case ENGRPV:                /*CWK*/
         /* erst synchronisieren: DIVI/MODI kann zur Asynchronitaet fuehren! */
#if 0
fuer FL noetig??
         print("barrier(); /*engrp*/\n");    /*CWK950324*/
#endif
         print("{int ichmachmit = (int)_gpp[6]>=0&&(int)_gpp[6]<_NROFSUBGROUPS;\n");
         print("if (!ichmachmit) {_barrier(_gpp[0],_gps);_barrier(_gpp[0],_gps);\n\
                                  if(1/*!_rootgroup*/)_barrier(_gpp[0],_gps);\n\
                                  _leaveprivategroup();\n\
                                  goto _ExitFork%d;}}\n", Pcodepar);
         print("_entergroup( (int)_gpp[6] );\t /*engrp*/\n");
         // auch die, die nicht reinsollen, m"ussen wie die anderen 
         // bei den barriers in entergroup mitmachen
         break;

      case EXGRPV:                /*CWK*/
         print("_leavegroup();\t /*exgrp*/\n");
         print("_ExitFork%d:\n", Pcodepar);
         break;

      case SPROCV:                /*CWK*/
         /* Frueher: Falls ein Ausdruck start(e) spezifiziert wurde, enthaelt */
         /* Register a->x.reg die Anzahl der zu startenden Prozessoren.*/
         /* Ansonsten (a==NULL) wird als default STARTED_PROCS genommen*/
         /* Test, ob die Anzahl der gestarteten Pr. ueberschritten wuerde: */
         if (a) error("no argument of start allowed!\n");

         /* Synchronisation nicht erforderlich, weil die Prozessoren bislang
          * synchron geblieben sind. Erzeuge neuen shared Gruppenframe:*/
         print("_makegroupframe( 1 );\t /*SPROCV*/\n");
         print("_entergroup(0);\t       /*SPROCV*/\n");
#if 0
         print("fps = _gps;\t /*sproc: fake fps for ADDRSL*/\n");/*980129*/
         nicht mehr noetig, wenn in ADDRSGP nicht ueber fps zugegr. wird
#endif
         break;

      case XPROCV:                /*CWK*/
         /*!alle Aenderungen hier muessen auch nach retflush() uebertragen werden!*/
         /*Die Gruppenrahmen vor der start-Anweisung werden wiederhergestellt.*/
         print("_leavegroup();\t /*xproc*/\n");
         print("barrier();\t /*xproc*/\n");
         break;

      case ENLGRPV:                /*CWK*/
         /* Es wird ein neuer shared Gruppenframe angelegt fuer die Gruppe *
          * der Prozessoren, die die Schleife ausfuehren. Der private      *
          * Gruppenframe bleibt unveraendert, ebenso der _eps.              *
          * Die Synchronisationszelle wird mit dem alten Wert initialisiert. */
         /* Pcodepar gibt Art der Schleife (while, for, do) an  950504 */
         print("_makegroupframe( 1 );\t /*enlgrp*/\n");
         print("_entergroup(0);\t /*enlgrp*/\n");
         break;

      case EXLGRPV:                /*CWK, dummy*/
         /* am Ende von privaten Schleifen. Der shared Gruppenframe fuer   *
          * die iterierenden Prozessoren wird abgeraeumt.                  */
         print("_leavegroup();\t /*exlgrp*/\n");
         break;

      case SIZEV:                  /*CWK*/
         /* bestimme vor jeder Iteration, wieviele Prozessoren diese Schleife
          * noch ausfuehren. Nachdem alle Prozessoren der Schleifengruppe 
          * synchronisiert sind, genuegt es, die Synchronisationszelle zu nullen
          * und parallel eine 1 zu addieren. */
         /* Pcodepar gibt Art der Schleife (while, for, do) an  950504 */
         /* fuer FL: Nichtiterierende Prozessoren fliegen einfach raus
          * und tragen sich automatisch aus -> es ist gar nix zu tun. */
         // print("barrier(); /*SIZEV: muss sein, sonst krachts*/\n");
         print("/*SIZEV: empty*/\n");
#if 0
         print("*(_gps+1) = 0;\t /*size: init s.cell*/\n");              /*1*/
         print("atomic_add(_gps+1, 1);\t /*size:#active pr*/\n");             /*1*/
#endif
         break;

      case FLUSHFRAMESV:                /*CWK*/
         /*zuerst in der obersten Gruppe austragen:*/
         for (label1=Pcodepar; label1 > 0; label1--) {
            print("_leavegroup();\t /*FLUSHFRAME(%d of %d)*/\n",
                                              label1, Pcodepar);
         }
         break;
      case BEGSEQV:                /*CWK 970310*/
         /*synchron. Bestimme leader: Proz. mit kleinster MPADD-priority*/
         print("if (_gpp[7]) goto _ENDSEQ%d;\t /*BEGSEQV%d*/\n",
                Pcodepar, Pcodepar);
         /* jetzt koennte noch ein shared Gruppenframe fuer 1 Prozessor
          * aufgebaut werden, um barriers im seq-Rumpf zu erlauben !
          * das macht aber bei 1 Prozessor wenig Sinn.
          * Ein privater Frame waere dann auch noetig, damit flushframes
          * ordentlich arbeitet.*/
         break;
      case ENDSEQV:                /*CWK 970310*/
         /*asynchron. Label und barrier ->weiter synchron in parallel*/
         /* und genau hier muesste dieser Frame wieder abgeraeumt werden. */
#if 0
         raus fuer FL nach Diskussion mit Helmut
         print("_ENDSEQ%d: barrier(); /*ENDSEQV%d*/\n", Pcodepar, Pcodepar);
#else
         print("_ENDSEQ%d: \t/*ENDSEQV%d*/\n", Pcodepar, Pcodepar);
#endif
         break;
      default: assert(0);
      }
   }
}

/* function - generate code for a function */
void function(Symbol f, Symbol caller[],
   Symbol callee[], int ncalls) {
   int i;

   proffset = 0;  /*statt 4 CWK*/
   shoffset = 1;  /*CWK*/
   resetshoffset = 0;
   shframedepth = 0;  /*970902*/
   freeallparregs();  /*CWK, fuer alle Faelle*/
   for (i = 0; caller[i] && callee[i]; i++) {
      if (callee[i]->shared) {   /*CWK*/
        assert(0);  /* nicht erlaubt: alle Parameter in FL sind private! */
        shoffset = roundup(shoffset, caller[i]->type->align);
        callee[i]->x.offset = caller[i]->x.offset = shoffset;
        callee[i]->x.name = caller[i]->x.name = stringf("aps,%d", shoffset); /*CWK*/
        shoffset += caller[i]->type->size;
      }
      else {
        proffset = roundup(proffset, caller[i]->type->align);
        callee[i]->x.offset = caller[i]->x.offset = proffset;
        callee[i]->x.name = caller[i]->x.name = stringf("app+%d", proffset); /*CWK*/
        proffset += caller[i]->type->size;
      }
      callee[i]->sclass = AUTO;
   }
   usedmask = argbuildsize = prframesize = shframesize
            = shoffset = proffset = 0; /*CWK*/
   print("\n%s (\n", typestring(f->type->type, f->x.name));  /*CWK*/
     {int comma=0;
      for (i = 0; caller[i] && callee[i]; i++) {
       if (comma) print(","); else comma=1;
       if (!(callee[i]->shared)) /*CWK*/
        print(" %s", typestring(callee[i]->type, callee[i]->name));
       else error("no shared function parameters in ForkLight!\n");
      }
     }
   print(" ) {\n"); /*}*/
   if (strcmp( f->x.name, "main" )==0) {    /* m a i n ( ) */
      print("#ifdef P4\n");
      print("int _myargc = 0;\nchar *_myargv = \"_myargv\";\n");
      print("p4_initenv(");
       {int comma=0;
        for (i = 0; caller[i] && callee[i]; i++) {
         if (comma) print(","); else comma=1;
          print(" %s", typestring(callee[i]->type, callee[i]->name));
        }
        if (!comma) print(" &_myargc, &_myargv ");   /* no argc, argv*/
       }
      print(" );\n");
      print("#endif\n");
      print("_beginparallelsection(%d);\n", STARTED_PROCS);
      print("#ifndef P4\n");
      print("}\nvoid _main( void )\n");
      print("#endif\n");
   }
   print("{\n");
   /* spaeter alle R-Namen mit Underscore versehen, sonst evtl name clash!*/
   print(" int r18, r19, r20, r21, r22, r23, r24, r25, r26, r27;\n");
   print(" void *pr18, *pr19, *pr20, *pr21, *pr22, *pr23, *pr24, *pr25, *pr26, *pr27;\n");
   print(" float fr18, fr19, fr20, fr21, fr22, fr23, fr24, fr25, fr26, fr27;\n");
   print(" double dr18, dr19, dr20, dr21, dr22, dr23, dr24, dr25, dr26, dr27;\n");
   print(" int ipar1, ipar2, ipar3, ipar4, ipar5, ipar6, ipar7, ipar8;\n");
   print(" void *ppar1, *ppar2, *ppar3, *ppar4, *ppar5, *ppar6, *ppar7, *ppar8;\n");
   print(" float fpar1, fpar2, fpar3, fpar4, fpar5, fpar6, fpar7, fpar8;\n");
   print(" double dpar1, dpar2, dpar3, dpar4, dpar5, dpar6, dpar7, dpar8;\n");
   gencode(caller, callee);
   assert(shframedepth==0);
   if (strcmp( f->x.name, "main" )==0) {
      print("_allocsharedglobals( _SHAREDGLOBALSTACKSIZE ); /*bytes for sh globals*/\n");
   }
   if (f->sync) {
     print("_makegroupframe( 1 ); /*Funktionsgruppe*/\n");
     print("_entergroup( 0 );  /*Funktionsgruppe*/\n");
     /*ibs kann shallfree funktionsbezogen arbeiten*/
   }
   /* framesize += (4*) nregs + argbuildsize; */
   /*CWK: Nach Neuorganisation des Stackframes brauchen wir die nregs und die
    * argbuildsize nicht mehr. Wenig sinnvoll, weil als naechster Frame auch 
    * ein privater Gruppenframe kommen kann. Also bleibt __framesize == |__locals|.*/
   /*print("subl2 $%d,sp\n", framesize);     CWK*/
  
   if (isstruct(freturn(f->type)))
       error("no struct return values supported, sorry!\n");
   emitcode();
   //if (strcmp( f->x.name, "main" )==0) 
       print("}\n");  /*inneren Block zumachen*/
   print("} \n\n");
}

void Epilog(sync)   /*CWK: alten privaten Stackframe wiederherstellen */
   int sync;        /*0 iff asynchronous function, then drop shared pointers*/
{                   /*     aufgerufen von RETx             940915     */
   if (sync) {  /*Funktionsgruppe zumachen:*/
     print("_leavegroup();\t /*aus Funktionsgruppe austragen*/\n");
     print("barrier();\t /*nach Fn-Ruecksprung gemeinsam weiter*/\n");
   }
   if (strcmp(cfunc->x.name,"main")==0)
     print("_endparallelsection(%d);\n", STARTED_PROCS);
}

/* gen - generate code for the dags on list p */
Node gen(Node p) {
   Node head, *last;

   debug(1,id = 0);
   for (last = &head; p; p = p->link)
      last = linearize(p, last, 0);
   debug(rflag,(lhead = head, lprint(head," before ralloc")));
   for (p = head; p; p = p->x.next) {
      ralloc(p);
      if (p->count == 0 && sets(p))
         putreg(p);
   }
   debug(rflag,lprint(lhead," after ralloc"));
   return head;
}

/* getreg - allocate 1 or 2 registers for node p */
static void getreg(Node p) {
   int r, m = optype(p->op) == D ? 3 : 1;

   for (r = 0; r < nregs; r++)
      if ((rmask&(m<<r)) == 0) {
         p->x.rmask = m;
         p->x.reg = r;
         if (p->syms[0])  p->syms[0]->reg = r;     /*CWK*/
         rmask |= sets(p);
         usedmask |= sets(p);
         debug(rflag,fprint(2,"allocating %s to node #%d\n", rnames(sets(p)), p->x.id));
         return;
      }
   debug(rflag,lprint(lhead, " before spillee"));
   r = spillee(p, m);
   spill(r, m, p);
   debug(rflag,lprint(lhead, " after spill"));
   assert((rmask&(m<<r)) == 0);
   getreg(p);
}

/* genreloads - make the nodes after dot use reloads of temp instead of p's register */
static void genreloads(Node dot, Node p, Symbol temp) {
   int i;
   Node last;

   for (last = dot; dot = dot->x.next; last = dot)
      for (i = 0; i < MAXKIDS; i++)
         if (dot->kids[i] == p) {
            dot->kids[i] = newnode(INDIR + typecode(p),
               newnode(ADDRL+P, 0, 0, temp), 0, 0);
            dot->kids[i]->count = 1;
            p->count--;
            linearize(dot->kids[i], &last->x.next, last->x.next);
            last = dot->kids[i];
         }
   assert(p->count == 0);
}

/* genspill - generate code to spill p's register and return the temporary used */
static Symbol genspill(Node p) {
   Symbol temp = newtemp(AUTO, typecode(p));
   Node q = p->x.next;

   linearize(newnode(ASGN + typecode(p),
      newnode(ADDRLP, 0, 0, temp), p, 0),
      &p->x.next, p->x.next);
   rmask &= ~1;
   for (p = p->x.next; p != q; p = p->x.next)
      ralloc(p);
   rmask |= 1;
   return temp;
}

/* global - global id */
void global(Symbol p) {
/*
   switch (p->type->align) {
   case 2: print(".align 1; "); break;
   case 4: print(".align 2; "); break;
   case 8: print(".align 3; "); break;
   }
*/
   if (p->shared) {
     print("int %s = %d;   /*offset into _gsstack*/\n", 
            p->x.name,  shglobalptr / voidptype->size );
     p->x.offset = shglobalptr;
     // neu 980811:
     shglobalptr = roundup(shglobalptr + p->type->size, p->type->align);
     shglobalptr = roundup(shglobalptr, voidptype->align);
     // damit sh chars nicht von der folgenden shvar geschluckt werden.
     //shglobalptr += p->type->size;
     warning("Shared globals work only in the file containing main()!\n");
/*
     print("%s ", typestring(p->type, stringf(" _%s", p->x.name)));
*/
   }
   else
     print("%s ", typestring(p->type, p->x.name));
}

/* linearize - linearize node list p */
static Node *linearize(Node p, Node *last, Node next) {
   if (p && !p->x.visited) {
      last = linearize(p->kids[0], last, 0);
      last = linearize(p->kids[1], last, 0);
      p->x.visited = 1;
      *last = p;
      last = &p->x.next;
      debug(1,if (p->x.id == 0) p->x.id = ++id);      
      debug(rflag,{fprint(2,"listing node "); nprint(p);})
   }
   *last = next;
   return last;
}

/* local - local variable */
void local(Symbol p) {
  if (p->shared) {  /*CWK*/
     p->x.offset = shoffset; //  + 1; 980810
     p->x.framedepth = p->shframedepth;  /*970902*/
     p->x.name = stringf("fps+%d", shoffset + 1);  /*CWK*/
     /* diese beiden vorgezogen 950814 CWK. neu: + 1  */
     shoffset = roundup(shoffset + p->type->size, p->type->align);
     shoffset = roundup(shoffset, voidptype->align);  // 1->4  neu 980811
  } /*shared*/
  else {  /*private -> im Klartext generieren fuer FL*/
     p->x.offset = 4711; // zur Kontrolle 980811. Vorher: proffset;  /*CWK*/
     if (*(p->name) >='0' && *(p->name) <='9') {  // generierte Variable
       assert(p->generated);
       proffset ++;
       /*p->x.name = stringf("%d(fp)", -offset);*/
       p->x.name = stringf("_generated_local%d", proffset);
       //proffset = roundup(proffset + p->type->size, p->type->align);
       //proffset = roundup(proffset, 1);  /* 1 statt 4 CWK */
     }
     else
        p->x.name = stringf("%s", p->name);
  } /*private*/
  p->sclass = AUTO;
}

/* needsreg - does p need a register? */
static int needsreg(p) Node p; {
   assert(opindex(p->op) > 0 && opindex(p->op) < sizeof reginfo/sizeof reginfo[0]);
   return reginfo[opindex(p->op)]&(0x1000<<optype(p->op));
}

/* progbeg - beginning of program */
void progbeg(int argc, char *argv[]) {
   extern int atoi(char *);      /* (omit) */
   while (--argc > 0)
      if (**++argv == '-' && argv[0][1] >= '0' && argv[0][1] <= '9')
         nregs = atoi(*argv + 1);
      else if (strcmp(*argv, "-r") == 0)   /* (omit) */
         rflag++;         /* (omit) */
   rmask = ((~0)<<nregs)|1;
   print("#include %c../lib/libfl.h%c\n\n", '"', '"');
#ifdef SBPRAM
   print("typedef struct { unsigned int hi; unsigned int lo;\
    } sbo_time_t; extern void  sbo_m_time(sbo_time_t *time);\n\n");
#endif
#if 0
   print(".section %c.gsdata%c, .data\n", '"','"');
#endif
#if 0
   print("int ___STARTED_PROCS__ = %d\n", STARTED_PROCS);
   print("___ACTIVE_PROCS__:.int %d\n", 1);    /*gueltig nach Startupcode*/
   abgeschafft, weil Probleme mit der Mehrfachcompilation 
   __STARTED_PROCS__ wird jetzt in der forklib.asm angelegt und initialisiert.
#endif
/*
   print(".section %c.text%c, .text\n", '"','"');
   print("jra\t forklib_startup\n\n");
*/
}

/* putreg - decrement register usage */
static void putreg(Node p) {
   if (p && --p->count <= 0)
      { assert(p->x.rmask);
      rmask &= ~sets(p);
      debug(rflag,fprint(2,"deallocating %s from node #%d\n", rnames(sets(p)), p->x.id)); }
}

/* ralloc - assign a register for p */
static void ralloc(Node p) {
   int i;

   assert(p);
   assert(p->x.rmask == 0);
   switch (generic(p->op)) {
   case ARG: /* SARG wird explizit gehandelt, RARG braucht keinen Stackplatz */
      /*CWK: brauche argoffset/argbuildsize nicht fuer FORK. Daher keine
       *     Unterscheidung zw. shared und private argoffset/-buildsize noetig.*/
      argoffset = roundup(argoffset, p->syms[1]->u.c.v.i);
      p->x.argoffset = argoffset;
      argoffset += p->syms[0]->u.c.v.i;
      if (argoffset > argbuildsize)
         argbuildsize = roundup(argoffset, 1);  /*statt 4 CWK*/
      break;
   case CALL:
      argoffset = 0;
      break;
   case SARG: break;  /*FL*/
   default:assert(valid(p->op));
   }
   for (i = 0; i < MAXKIDS; i++)              /*spaeter bei FlOps putreg nachher*/
      putreg(p->kids[i]);                     /*wegen exception-Handling     CWK*/
   p->x.busy = rmask;
   if (needsreg(p))
      getreg(p);
}

/* restore - restore registers in mask */
static void restore(unsigned mask) {
   int i;

   for (i = nregs-1; i > 0; i--)         /* BUGFIX: in umgekehrter Rf. wieder poppen */
      if (mask&(1<<i)) {
         /*print("movl %d(fp),r%d\n", (4*)i - framesize + argbuildsize, i);*/
         print("_pop(&r%d,1);\t /*restore r%d*/\n", i+ROFF, i+ROFF ); /*CWK*/
      }
}

/* save - save registers in mask */
static void save(unsigned mask) {
   int i;

   for (i = 1; i < nregs; i++)
      if (mask&(1<<i)) {
         /*print("movl r%d,%d(fp)\n", i, (4*)i - framesize + argbuildsize, i);*/
         print("pshg\t r%d,_spp\t\t /*save r%d*/\n", i+ROFF, i+ROFF );   /*CWK*/
      }
}

/* segment - switch to logical segment s */
void segment(int s) {      /* Neue Segmente eingefuehrt CWK */
#if 0
   print(".section %c",'"');  /*CWK fuer PRASS */
   switch (s) {               /*CWK: Segmentname*/
   case   CODE: print(".text");   break;
   case    LIT: /*fall through. was: print(".text 1\n"); break;  Konstanten */
   case GSDATA: print(".gsdata");   break;
   case  GSBSS: print(".gsbss");   break;
   case   DATA: print(".gpdata");   break;
   case    BSS: print(".gpbss");   break;
   default: assert(0);
   }
   print("%c, ",'"');  /*CWK fuer PRASS */
   switch (s) {               /*CWK: Segmenttyp*/
   case   CODE: print(".text\n");   break;
   case    LIT:
   case GSDATA: case  DATA: print(".data\n");   break;
   case  GSBSS: case  BSS:  print(".bss\n");   break;
   default: assert(0);
   }
#endif
}

/* spill - spill all registers that overlap (r,m) */
static void spill(int r, unsigned m, Node dot) {
   int i;
   Node p = dot;

   while (p = p->x.next)
      for (i = 0; i < MAXKIDS; i++)
         if (p->kids[i] && sets(p->kids[i])&(m<<r)) {
            Symbol temp = genspill(p->kids[i]);
            rmask &= ~sets(p->kids[i]);
            genreloads(dot, p->kids[i], temp);
         }
}

/* spillee - identify the most-distantly-used register */
static int spillee(Node dot, unsigned m) {
   int bestdist = -1, bestreg = /*0*/ 32-FREE_REGS, dist, r;
   Node q;

   debug(rflag,fprint(2,"spillee: dot is node #%d\n", dot->x.id));
   for (r = 1; r < nregs - (m>>1); r++) {
      dist = 0;
      for (q = dot->x.next; q && !(uses(q)&(m<<r)); q = q->x.next)
         dist++;
      assert(q);   /* (omit) */
      debug(rflag,fprint(2,"r%d used in node #%d at distance %d\n", r, q->x.id, dist));
      if (dist > bestdist) {
         bestdist = dist;
         bestreg = r;
      }
   }
   debug(rflag,fprint(2,"spilling %s\n",rnames(m<<bestreg)));
   assert(bestreg);   /* (omit) */
   return bestreg;
}

/* uses - return mask of registers used by node p */
static unsigned uses(Node p) {
   int i;
   unsigned m = 0;

   for (i = 0; i < MAXKIDS; i++)
      if (p->kids[i])
         m |= sets(p->kids[i]);
   return m;
}

/* valid - is operator op a valid operator ? */
static int valid(op) {
   return opindex(op) > 0 && opindex(op) < sizeof reginfo/sizeof reginfo[0] ?
      reginfo[opindex(op)]&(1<<optype(op)) : 0;
}

#ifdef DEBUG
/* lprint - print the nodelist beginning at p */
static void lprint(Node p, char *s) {
   fprint(2, "node list%s:\n", s);
   if (p) {
      char buf[100];
      sprintf(buf, "%-4s%-8s%-8s%-8s%-7s%-13s%s",
         " #", "op", "kids", "syms", "count", "uses", "sets");
      fprint(2, "%s\n", buf);
   }
   for ( ; p; p = p->x.next)
      nprint(p);
}

/* nprint - print a line describing node p */
static void nprint(Node p) {
   int i;
   char *kids = "", *syms = "", buf[200];

   if (p->kids[0]) {
      static char buf[100];
      buf[0] = 0;
      for (i = 0; i < MAXKIDS && p->kids[i]; i++)
         sprintf(buf + strlen(buf), "%3d", p->kids[i]->x.id);
      kids = &buf[1];
   }
   if (p->syms[0] && p->syms[0]->x.name) {
      static char buf[100];
      buf[0] = 0;
      for (i = 0; i < MAXSYMS && p->syms[i]; i++) {
         if (p->syms[i]->x.name)
            sprintf(buf + strlen(buf), " %s", p->syms[i]->x.name);
         if (p->syms[i]->u.c.loc)
            sprintf(buf + strlen(buf), "=%s", p->syms[i]->u.c.loc->name);
      }
      syms = &buf[1];
   }
   sprintf(buf, "%2d. %-8s%-8s%-8s %2d    %-13s",
      p->x.id, opname(p->op), kids, syms, p->count, rnames(uses(p)));
   sprintf(buf + strlen(buf), "%s", rnames(sets(p)));
   fprint(2, "%s\n", buf);
}

/* rnames - return names of registers given by mask m */
static char *rnames(unsigned m) {
   static char buf[100];
   int r;

   buf[0] = buf[1] = 0;
   for (r = 0; r < nregs; r++)
      if (m&(1<<r))
         sprintf(buf + strlen(buf), " r%d", r);
   return &buf[1];
}
#endif

#ifndef V9
#include <errno.h>
#ifndef errno
extern int errno;
#endif

/* strtol - interpret str as a base b number; if ptr!=0, *ptr gets updated str */
long strtol(str, ptr, b) char *str, **ptr; {
   long n = 0;
   char *s, sign = '+';
   int d, overflow = 0;

   if (ptr)
      *ptr = str;
   if (b < 0 || b == 1 || b > 36)
      return 0;
   while (*str==' '||*str=='\f'||*str=='\n'||*str=='\r'||*str=='\t'||*str=='\v')
      str++;
   if (*str == '-' || *str == '+')
      sign = *str++;
   if (b == 0)
      if (str[0] == '0' && (str[1] == 'x' || str[1] == 'X')) {
         b = 16;
         str += 2;
      } else if (str[0] == '0')
         b = 8;
      else
         b = 10;
   for (s = str; *str; str++) {
      if (*str >= '0' && *str <= '9')
         d = *str - '0';
      else if (*str >= 'a' && *str <= 'z' || *str >= 'A' && *str <= 'Z')
         d = (*str&~040) - 'A' + 10;
      else
         break;
      if (d >= b)
         break;
      if (n < (LONG_MIN + d)/b)
         overflow = 1;
      n = b*n - d;
   }
   if (s == str)
      return 0;
   if (ptr)
      *ptr = str;
   if (overflow || (sign == '+' && n == LONG_MIN)) {
      errno = ERANGE;
      return sign == '+' ? LONG_MAX : LONG_MIN;
   }
   return sign == '+' ? -n : n;
}
#endif


/* === Funktionen fuer ex-p-code Befehle, CWK-neu 940628: ==================== */

/* shspace(): allocate space for shared block-local variables */ 
void shspace(int k)      /*970902*/
{
    Tree e = tree(SHSPACE+V, voidtype, 0, 0);
    code(Pcode);
    codelist->u.node = listnodes( e, 0, 0 );
    codelist->par = k;
}

/* splitSM(): erzeuge Code zur Berechnung der Trennzelle,
 * um freien SM-Bereich gleichmaessig aufzuteilen;
 * gibt Backpatch-Pointer zurueck.
 */
int *splitSM( void )
{
   Tree e = tree(SPLIT+V, voidtype, 0, 0);
   code(Pcode);
   codelist->u.node = listnodes( e, 0, 0 );
   codelist->par = 2;
   return &(codelist->par); 
}

/* nextcase(zweiter): erzeuge Code, um Speicher gemaess Trennzelle aufzuteilen
 * und Gruppenrahmen fuer then-Gruppe anzulegen (zweiter->else-Gruppe) */
void nextcase( int zweiter )
{
   Tree e = tree(NEXTCASE+V, voidtype, 0, 0);
   code(Pcode);
   codelist->u.node = listnodes( e, 0, 0 );
   codelist->par = zweiter;
}

/* lgrp_if(): erzeuge Code zum Verlassen angelegter Gruppenrahmen bei if-Anw.
 * einsoderzwei: 2 -> verlasse shared + private frame
 *               1 -> verlasse nur private frame
 */
void lgrp_if( int einsoderzwei )
{
   Tree e = tree(LGRPIF+V, voidtype, 0, 0);
   code(Pcode);
   codelist->u.node = listnodes( e, 0, 0 );
   codelist->par = einsoderzwei;
}

/* synchronize(): erzeuge Code zum Synchronisieren der Blattgruppen */
void synchronize() 
{
   Tree e = tree(SYNC+V, voidtype, 0, 0);
   code(Pcode);
   codelist->u.node = listnodes( e, 0, 0 );
}

/* engrp(): Gruppen betreten bei Fork-Anweisung */
void engrp( int forkexitlabel )
{
   Tree e = tree(ENGRP+V, voidtype, 0, 0);
   code(Pcode);
   codelist->u.node = listnodes( e, 0, 0 );
   codelist->par = forkexitlabel;
}

/* exgrp(): Gruppen verlassen nach Fork-Anweisung */
void exgrp( int forkexitlabel )
{
   Tree e = tree(EXGRP+V, voidtype, 0, 0);
   code(Pcode);
   codelist->u.node = listnodes( e, 0, 0 );
   codelist->par = forkexitlabel;
}

/* xproc(): Prozessoren verlassen nach start-Anweisung */
void xproc()
{
   Tree e = tree(XPROC+V, voidtype, 0, 0);
   code(Pcode);
   codelist->u.node = listnodes( e, 0, 0 );
}

/* enlgrp(): Gruppenerzeugung fuer Schleifen */
void enlgrp( looptyp )
{
   Tree e = tree(ENLGRP+V, voidtype, 0, 0);
   code(Pcode);
   codelist->u.node = listnodes( e, 0, 0 );
   codelist->par = looptyp;    /*950504*/
}

/* exlgrp(): Gruppen verlassen nach Schleife */
void exlgrp()
{
   Tree e = tree(EXLGRP+V, voidtype, 0, 0);
   code(Pcode);
   codelist->u.node = listnodes( e, 0, 0 );
}

/* size(): Bestimmung der Gruppengroesse vor Schleifeneintritt */
void size()
{
   Tree e = tree(SIZE+V, voidtype, 0, 0);
   code(Pcode);
   codelist->u.node = listnodes( e, 0, 0 );
}

/* flushframes( k ):  flush k group frames (private and shared) */
void flushframes( k )
   int k;
{
   Tree e;
   assert( k>=0 );
   if (!k) return;
   e = tree(FLUSHFRAMES+V, voidtype, 0, 0);
   code(Pcode);
   codelist->u.node = listnodes( e, 0, 0 );
   codelist->par = k;
   /*shframedepth --; muss weg, weil die shframedepth eine
     statische und keine dynamische Groesse ist! 980129 */
   /*weil der Compiler zu schlau ist
     und das naechste lgrpif o.dgl. wegoptimiert*/
}


/* retflush():  flush some shared group frames, care about starts CWK */
void retflush( p )  Node p; {
 int i;
 assert( p->rframes >= 0); assert( p->started >=0 );
 /*shframedepth -= p->rframes;   /*970902*/
   /*muss weg, weil die shframedepth eine
     statische und keine dynamische Groesse ist! 980129 */
   /*shframedepth --; weil der Compiler zu schlau ist
     und das naechste lgrpif o.dgl. wegoptimiert*/
 for (i = p->rframes; i > 0; i--) {
    print("_leavegroup();\t /*RETFLUSH(%d)*/\n", i);
 }
 if (p->started) {     /*issue an xproc(): */
         /*Die Gruppenrahmen vor der start-Anweisung werden wiederhergestellt.*/
    print("_leavegroup();\t /*retxproc*/\n");
 }
}


/* begseq(): enter seq body, mask out all but one processor 970310 */
void begseq( int labelnr ) 
{
   Tree e = tree(BEGSEQ+V, voidtype, 0, 0);
   code(Pcode);
   codelist->u.node = listnodes( e, 0, 0 );
   codelist->par = labelnr;
}

/* endseq(): exit seq body: label, barrier   970310 */
void endseq( int labelnr ) 
{
   Tree e = tree(ENDSEQ+V, voidtype, 0, 0);
   code(Pcode);
   codelist->u.node = listnodes( e, 0, 0 );
   codelist->par = labelnr;
}


/* ================= STAB - Funktionen    CWK 940921 ================== */
/* adaptiert aus lcc 3.1, files sparc.c und symbolic.c */

#include "stab.h"
static char *currentfile;       /* current file name */
static int ntypes;

static void asgncode (Type, int);
static void dbxout (Type);
static int dbxtype (Type);
static int emittype (Type, int, int);

/* asgncode - assign type code to ty */
static void asgncode(ty, lev) Type ty; {
	if (ty->x.marked || ty->x.typeno)
		return;
	ty->x.marked = 1;
	switch (ty->op) {
	case VOLATILE: case CONST: case VOLATILE+CONST:
		asgncode(ty->type, lev);
		ty->x.typeno = ty->type->x.typeno;
		break;
	case POINTER: case FUNCTION: case ARRAY:
		asgncode(ty->type, lev + 1);
		/* fall thru */
	case VOID: case CHAR: case SHORT: case INT: case UNSIGNED:
	case FLOAT: case DOUBLE:
		break;
	case STRUCT: case UNION: {
		Field p;
		for (p = fieldlist(ty); p; p = p->link)
			asgncode(p->type, lev + 1);
		/* fall thru */
	case ENUM:
		if (ty->x.typeno == 0)
			ty->x.typeno = ++ntypes;
		if (lev > 0 && (*ty->u.sym->name < '0' || *ty->u.sym->name > '9'))
			dbxout(ty);
		break;
		}
	default:
		assert(0);
	}
}

/* dbxout - output .stabs entry for type ty */
static void dbxout(ty) Type ty; {
	ty = unqual(ty);
	if (!ty->x.printed) {
		int col = 0;
		print(".stabs \""), col += 8;
		if (ty->u.sym && !(isfunc(ty) || isarray(ty) || isptr(ty)))
			print("%s", ty->u.sym->name), col += strlen(ty->u.sym->name);
		print(":%c", isstruct(ty) || isenum(ty) ? 'T' : 't'), col += 2;
		emittype(ty, 0, col);
		print("\",%d,0,0,0\n", N_LSYM);
	}
}

/* dbxtype - emit a stabs entry for type ty, return type code */
static int dbxtype(ty) Type ty; {
	asgncode(ty, 0);
	dbxout(ty);
	return ty->x.typeno;
}

/*
 * emittype - emit ty's type number, emitting its definition if necessary.
 * Returns the output column number after emission; col is the approximate
 * output column before emission and is used to emit continuation lines for long
 * struct, union, and enum types. Continuations are not emitted for other types,
 * even if the definition is long. lev is the depth of calls to emittype.
 */
static int emittype(ty, lev, col) Type ty; {
	int tc = ty->x.typeno;

	if (isconst(ty) || isvolatile(ty)) {
		col = emittype(ty->type, lev, col);
		ty->x.typeno = ty->type->x.typeno;
		ty->x.printed = 1;
		return col;
	}
	if (tc == 0) {
		ty->x.typeno = tc = ++ntypes;
/*              fprint(2,"`%t'=%d\n", ty, tc); */
	}
	print("%d", tc), col += 3;
	if (ty->x.printed)
		return col;
	ty->x.printed = 1;
	switch (ty->op) {
	case VOID:	/* void is defined as itself */
		print("=%d", tc), col += 1+3;
		break;
	case CHAR:	/* unsigned char is a subrange of int */
		if (ty == unsignedchar)
			print("=r1;0;255;"), col += 10;
		else	/* following pcc, char is a subrange of itself */
			print("=r%d;-128;127;", tc), col += 2+3+10;
		break;
	case SHORT:	/* short is a subrange of int */
		if (ty == unsignedshort)
			print("=r1;0;65535;"), col += 12;
		else	/* signed */
			print("=r1;-32768;32767;"), col += 17;
		break;
	case INT:	/* int is a subrange of itself */
		print("=r1;%d;%d;", INT_MIN, INT_MAX), col += 4+11+1+10+1;
		break;
	case UNSIGNED:	/* unsigned is a subrange of int */
		print("=r1;0;-1;"), col += 9;
		break;
	case FLOAT: case DOUBLE:	/* float, double get sizes instead of ranges */
		print("=r1;%d;0;", ty->size), col += 4+1+3;
		break;
	case POINTER:
		print("=*"), col += 2;
		col = emittype(ty->type, lev + 1, col);
		break;
	case FUNCTION:
		print("=f"), col += 2;
		col = emittype(ty->type, lev + 1, col);
		break;
	case ARRAY:	/* array includes subscript as an int range */
		if (ty->size && ty->type->size)
			print("=ar1;0;%d;", ty->size/ty->type->size - 1), col += 7+3+1;
		else
			print("=ar1;0;-1;"), col += 10;
		col = emittype(ty->type, lev + 1, col);
		break;
	case STRUCT: case UNION: {
		Field p;
		if (!ty->u.sym->defined) {
			print("=x%c%s:", ty->op == STRUCT ? 's' : 'u', ty->u.sym->name);
			col += 2+1+strlen(ty->u.sym->name)+1;
			break;
		}
		if (lev > 0 && (*ty->u.sym->name < '0' || *ty->u.sym->name > '9')) {
			ty->x.printed = 0;
			break;
		}
		print("=%c%d", ty->op == STRUCT ? 's' : 'u', ty->size), col += 1+1+3;
		for (p = fieldlist(ty); p; p = p->link) {
			if (p->name)
				print("%s:", p->name), col += strlen(p->name)+1;
			else
				print(":"), col += 1;
			col = emittype(p->type, lev + 1, col);
			/*if (p->lsb)
				print(",%d,%d;", 8*p->offset +
					(IR->little_endian ? fieldright(p) : fieldleft(p)),
					fieldsize(p));
			else CWK*/
				print(",%d,%d;", 8*p->offset, 8*p->type->size);
			col += 1+3+1+3+1;	/* accounts for ,%d,%d; */
			if (col >= 80 && p->link) {
				print("\\\\\",%d,0,0,0\n.stabs \"", N_LSYM);
				col = 8;
			}
		}
		print(";"), col += 1;
		break;
		}
	case ENUM: {
		Symbol *p;
		if (lev > 0 && (*ty->u.sym->name < '0' || *ty->u.sym->name > '9')) {
			ty->x.printed = 0;
			break;
		}
		print("=e"), col += 2;
		for (p = ty->u.sym->u.idlist; *p; p++) {
			print("%s:%d,", (*p)->name, (*p)->u.value), col += strlen((*p)->name)+3;
			if (col >= 80 && p[1]) {
				print("\\\\\",%d,0,0,0\n.stabs \"", N_LSYM);
				col = 8;
			}
		}
		print(";"), col += 1;
		break;
		}
	default:
		assert(0);
	}
	return col;
}

/* stabblock - output a stab entry for '{' or '}' at level lev */
void stabblock(brace, lev, p)  Symbol *p; {
	if (brace == '{')
		while (*p)
			stabsym(*p++);
	print(".stabd 0x%x,0,%d\n", brace == '{' ? N_LBRAC : N_RBRAC, lev);
}

/* stabfend - end of function p */
void stabfend(p, line) Symbol p; {}

/* stabinit - initialize stab output */
void stabinit(file, argc, argv) char *file, *argv[]; {
	typedef void (*Closure)(Symbol, void *);

	if (file && *file) {
                extern char *MYPATH;  /*main.c  CWK*/
                print(".stabs \"%s\",0x%x,0,0,Ltext\n", MYPATH, N_SO); /*CWK*/
                print(".stabs \"%s\",0x%x,0,0,Ltext\n", file, N_SO);
		/*(*IR->segment)(CODE);*/ segment( CODE ); /*CWK*/
		print("Ltext:");
		currentfile = file;
	}
	dbxtype(inttype);
	dbxtype(chartype);
	dbxtype(doubletype);
	dbxtype(floattype);
	dbxtype(longdouble);
	dbxtype(longtype);
	dbxtype(shorttype);
	dbxtype(signedchar);
	dbxtype(unsignedchar);
	dbxtype(unsignedlong);
	dbxtype(unsignedshort);
	dbxtype(unsignedtype);
	dbxtype(voidtype);
	foreach(types, GLOBAL, (Closure)stabtype, (void *)0 /*CWK, statt NULL*/);
}

/* stabline - emit stab entry for source coordinate *cp */
void stabline(cp) Coordinate *cp; {
	if (cp->file && cp->file != currentfile) {
		int lab = genlabel(1);
		print("L%d: .stabs \"%s\",0x%x,0,0,L%d\n", lab,
				cp->file, N_SOL, lab);
		currentfile = cp->file;
	}
	print(".stabd 0x%x,0,%d\n", N_SLINE, cp->y);
}

/* stabsym - output a stab entry for symbol p */
void stabsym(p) Symbol p; {
	int code, tc, sz = p->type->size;

	if (p->generated || p->computed)
		return;
	if (isfunc(p->type)) {
		print(".stabs \"%s:%c%d\",%d,0,0,%s\n", p->name,
			p->sclass == STATIC ? 'f' : 'F', dbxtype(freturn(p->type)),
			N_FUN, p->x.name);
		return;
	}
        /*CWK auskommentiert:
	if (!IR->wants_argb && p->scope == PARAM && p->structarg) {
		assert(isptr(p->type) && isstruct(p->type->type));
		tc = dbxtype(p->type->type);
		sz = p->type->type->size;
	} else
        weil argb vorlaeufig uninteressant */
		tc = dbxtype(p->type);
	if (p->sclass == AUTO && p->scope == GLOBAL || p->sclass == EXTERN) {
		print(".stabs \"%s:G", p->name);
		code = N_GSYM;
	} else if (p->sclass == STATIC) {
		print(".stabs \"%s:%c%d\",%d,0,0,%s\n", p->name, p->scope == GLOBAL ? 'S' : 'V',
			tc, p->u.seg == BSS ? N_LCSYM : N_STSYM, p->x.name);
		return;
	} else if (p->sclass == REGISTER) {
		if (p->scope > PARAM) {
			int r = p->reg /* statt p->x.regnode->number CWK */;
			/*if (p->x.regnode->set == FREG)
				r += 32;	* floating point */
			print(".stabs \"%s:r%d\",%d,0,", p->name, tc, N_RSYM);
			print("%d,%d\n", sz, r);
		}
		return;
	} else if (p->scope == PARAM) {
		print(".stabs \"%s:p", p->name);
		code = N_PSYM;
	} else if (p->scope >= LOCAL) {
		print(".stabs \"%s:", p->name);
		code = N_LSYM;
	} else
		assert(0);
	print("%d\",%d,0,0,%s\n", tc, code,
		p->scope >= PARAM && p->sclass != EXTERN ? p->x.name : "0");
}

/* stabtype - output a stab entry for type *p */
void stabtype(p) Symbol p; {
	if (p->type) {
		if (p->sclass == 0)
			dbxtype(p->type);
		else if (p->sclass == TYPEDEF)
			print(".stabs \"%s:t%d\",%d,0,0,0\n", p->name, dbxtype(p->type), N_LSYM);
	}
}

/* symname - print prefix, p's name, declaration source coordinate, suffix */
static void symname(p) Symbol p; {
        if (p)
                print("%s@%w.%d", p->name, &p->src, p->src.x);
        else
                print("0");
}

/* stabend - finalize stab output */
void stabend(cp, p, cpp, sp, stab) Coordinate *cp, **cpp; Symbol p, *sp, *stab; {
   } /*CWK: vorlaeufig auskommentiert
        int i;

        symname(p);
        print("\n");
        for (i = 0; cpp[i] && sp[i]; i++) {
                print("%w.%d: ", cpp[i], cpp[i]->x);
                symname(sp[i]);
                print("\n");
        }
} */
