/* C compiler: configuration parameters for VAX subset code generator */

/* include config */
/*#define VAX*/

/* type metrics: size,alignment,constants */
#ifdef SBPRAM

#define CHAR_METRICS     1,1,0    /* vormals 1,1,0 CWK */
#define SHORT_METRICS    1,1,0    /* vormals 2,2,0 CWK */
#define INT_METRICS      1,1,0
#define FLOAT_METRICS    1,1,1
#define DOUBLE_METRICS   1,1,1    /* vormals 8,4,1 CWK */
#define POINTER_METRICS  1,1,0
#define STRUCT_ALIGN     1        /* vormals 1 CWK */

#else

#define CHAR_METRICS     1,1,0    /* vormals 1,1,0 CWK */
#define SHORT_METRICS    4,4,0    /* vormals 2,2,0 CWK */
#define INT_METRICS      4,4,0
#define FLOAT_METRICS    4,4,1
#define DOUBLE_METRICS   8,4,1    /* vormals 8,4,1 CWK */
#define POINTER_METRICS  4,4,0
#define STRUCT_ALIGN     4        /* vormals 1 CWK */

#endif

#define MAXSPROCLEVEL    16       /* max. start()-Schachtelungstiefe CWK 950425*/
#define LOWADDRESSES     /* Labels koennen max. 19 Bit haben */
#define NOARGB           /* Block-Argumente als Pointer drauf uebergeben CWK */
#define MAX_PARAMS_IN_REGISTER 0   /* Anzahl priv. Parameter, die in Reg. ueberg.*/
#define LEFT_TO_RIGHT    /* evaluate args left-to-right */
#define LITTLE_ENDIAN    /* right-to-left bit fields */
#define JUMP_ON_RETURN   0
#define PARREG1          7  /*Nr. erstes Parameterregister*/
#define PARREG2          8  /*zweites ''*/
#define PARREG3          9  /*drittes ''*/
#define PARREG4         10  /*viertes ''*/
#define FREE_REGS       12  /*Reg. 18,...,29 zur freien Verfuegung */
#define ROFF            17  /*letztes vorbelegtes Spezialregister*/
                            /*Reg. 30,31 scratch registers, not saved*/
/* end config */

/* include Env */
typedef struct {
   unsigned rmask;
   int proffset;   /*vormals offset CWK*/
   int shoffset;   /*CWK*/
   int framedepth; /*970902: save old framedepth*/
} Env;
/* end Env */
/* include Xnode */
typedef struct {
   int id;             /* node id number (omit) */
   unsigned visited:1; /* 1 if dag has been linearized */
   int reg;            /* register number */
   unsigned rmask;     /* unshifted register mask */
   unsigned busy;      /* busy regs */
   int argoffset;      /* ARG: argument offset */
   Node next;          /* next node on emit list */
} Xnode;
/* end Xnode */
/* include Xsymbol */
typedef struct {
   char *name;      /* name for back end */
   int offset;      /* frame offset */
   int framedepth;  /* 970902 */
} Xsymbol;
/* end Xsymbol */

/* include defaddress */
#define defaddress(p) print("extern void * %s;\n", (p)->x.name)
/* end defaddress */
/* include export */
#define export(p) if ((p)->shared)print("extern int %s;\n", (p)->x.name);\
                else print("extern %s;\n", typestring((p)->type, (p)->x.name));
#define import(p)
/* end export */
/* include progend */
#define progend(x)
/* end progend */
/* include space */
#define space(x) /*print(".space %d\n", (x))*/
/* end space */

/* ersetzt durch Routinen in gen.c   CWK
#define stabblock(a,b,c)
#define stabend(a,b,c,d,e)
#define stabfend(a,b)
#define stabinit(a,b,c)
#define stabline(a)
#define stabsym(a)
#define stabtype(a)
*/

#ifdef vax
dclproto(extern double atof,(char *));
#define strtod(a,b) atof(a)
#endif
