/* Solaris header file for generic threads routines (Sept 1994) */

#include <thread.h>
#include <synch.h>

typedef mutex_t MUTEX;

typedef cond_t COND;

typedef thread_t THREAD;

int MutexInit (MUTEX *);

int MutexLock (MUTEX *);

int MutexUnlock (MUTEX *);

int CondInit (COND *);

int CondWait (COND *, MUTEX *);

int CondSignal (COND *);

int ThreadCreate (THREAD *, void * (*)(void *), void *);
