/* Solaris implementation of generic threads routines (Sept 1994) */
/* adapted for ForkLight 1998 by C. Kessler */

#include <stdio.h>
#include <thread.h>
#include <synch.h>

int
MutexInit (mutex_t *mu)
{
    return mutex_init(mu, USYNC_THREAD, NULL);
}

int
MutexLock (mutex_t *mu)
{
    return mutex_lock(mu);
}

int
MutexUnlock (mutex_t *mu)
{
    return mutex_unlock(mu);
}

int
CondInit (cond_t *cv)
{
    return cond_init(cv, USYNC_THREAD, NULL);
}

int
CondWait (cond_t *cv, mutex_t *mu)
{
    return cond_wait(cv, mu);
}

int
CondSignal (cond_t *cv)
{
    return cond_signal(cv);
}

int
CondBroadcast (cond_t *cv)
{
    return cond_broadcast(cv);
}

int
ThreadCreate (thread_t *t, void * (*sf)(void *), void *arg)
{
    return thr_create(NULL, 0, sf, (void *)arg,
                      /* THR_DETACHED|THR_NEW_LWP|*/ THR_BOUND, t);
}

