/* libfl.h: Aliases + Header fuer FORKLIGHT-Compilat */ 

/* include the target system's possibly required 
 * C library headers here, since includes from the
 * ForkLight source cannot be passed through flcc: 
 */
#include <math.h>
#include <stdlib.h>
#include <stdio.h>
/* #define P4 to be activated by compiler option -DP4 /*backend library*/
/* typedef unsigned int size_t;*/

#ifdef SBPRAM
#define _VOIDPTYPESIZE 1 /*bytes*/
#ifndef P4
#define P4
#endif
#else
#define _VOIDPTYPESIZE 4 /*bytes*/
#endif
#define _PSTACKSIZE 2000  /*bytes*/
#define _SSTACKSIZE 990000   /*bytes*/
#define _TEMPSTACKSIZE 10 /*words*/
#define _isshared(p) ((p)>=_sstack && (p)<_sstack+_SSTACKSIZE)
#define _MINSSTACKSIZE 4    /* words, minimum size of a shared stack */
#define _MAXNROFSUBGROUPS 16
#define _MAXJOINS 8        /* maximal number of joins in my user program */
#define _SHAREDGLOBALSTACKSIZE 100 /*bytes*/
                           /* max. size of all shared globals in prg*/
#ifdef SBPRAM
#include <sbp/spb_gop.h>
/*#include "/local/fork/fl/sbp/include/sbp/sbp_gop.h"
// ints and pointers are 32 bit wide.
// ldg(adr) is reduced to mpadd(adr,0)
// the following routines are defined in sbp_gop.h as MACROS:
// extern int sbp_mpadd_m0(void **, void *);
// extern int sbp_mpmax_m0(void **, void *);
// extern int sbp_mpand_m0(void **, void *);
// extern int sbp_mpor_m0(void **, void *);
// extern void sbp_syncadd_m1(void **, void *);
// extern void sbp_syncmax_m1(void **, void *);
// extern void sbp_syncand_m1(void **, void *);
// extern void sbp_syncor_m1(void **, void *);
*/
#endif

extern unsigned int __P__;    /* overall number of threads (static) */
extern int _alone;     /* flag, ==1 iff group consists of only 1 proc. */
extern int _rootgroup; /* flag, ==1 iff group still consists of all procs */
extern int _SLICESIZE, _NROFSUBGROUPS;
extern void *_itovp( int ), *_ftovp( float );
extern void _FatalError( char *str );

/* the stack pointers: */
extern void **_gpp, **_gps; 
extern void **_spp, **_sps, **_eps;
extern void **_gsstack, **_sstack;
extern void *_temp[_TEMPSTACKSIZE];

/* handling the private stack 
 * (mainly procedure parameters and private group frames): */

extern void _push( void *, size_t );
extern void _pop( void **, size_t );
extern void _top( void **, size_t );

/* allocating group frames: */
extern void _InitForkLightStacks(void);
extern void _makegroupframe( int ),
            _entergroup( int ),
            _leavegroup( void ),
            _leaveprivategroup( void );
extern int groupsize( void ); /*inspect sync cell*/
extern void barrier( void ), _barrier( void **, void ** );

/* fuer join() benoetigt: */ 
extern void **__SM;    /* contains ptrs to shmemory bus sections */
extern int *__gone;    /* guards access to _ticket */
extern int *__ticket;  /* semaphore to control entry of passengers */

/* handling the shared stack 
 * (group frames, synchronization, shared local variables): */
extern void _SMpush(void *, size_t);
extern void _SMpop(void **, size_t);
extern void _SMtop(void **, size_t);
extern void _SMdump( void );
#ifdef SBPRAM
extern void *shmalloc( unsigned int );
#else
extern void *shmalloc( size_t );
#endif
extern void _allocsharedglobals( size_t );
extern void **_globaladdress( size_t );
extern void *shalloc( size_t );
extern int shavail( void );

/* the interface routines to the parallel target machine: */

extern void _SMread(void **, void *, size_t);
extern void _SMwrite(void **, void *, size_t);
extern void *_SMalloc( size_t );
extern int  fetch_add( void **, int );
extern void atomic_add( void **, int );
extern int  _PhysThreadId( void );
extern void _beginparallelsection( unsigned int );
extern void _endparallelsection( unsigned int );



/* timing routines with modified headers suitable for flcc */

#ifndef SBPRAM
#include <sys/time.h>

typedef struct itimerval itimerval_t;

extern void init_timer();
extern void clear_timer(itimerval_t *p);
extern void punch_in(itimerval_t *ptimer);
extern void punch_out(); // itimerval_t checkin, itimerval_t *ptimer);
extern itimerval_t subtract_time(itimerval_t then, itimerval_t now);
extern itimerval_t add_time(itimerval_t t1, itimerval_t t2);
extern void print_time(char * string, ... );
extern void error(char *str);
#endif
