/* stdlib.h  for the Fork95 Compiler,  CWK 950316 */


#ifndef	STDLIBHEADER
#define	STDLIBHEADER 1

/* #define double float        /* anders gehts nicht. CWK */

/* Get size_t, wchar_t and NULL from <stddef.h>.  */
#ifndef NULL
#define	NULL 0
#endif
#ifndef size_t
#define size_t unsigned int
#endif
#ifndef __ptr_t
#define __ptr_t void *
#endif

extern int errno;

#ifndef ERRNOHEADER
#include <errno.h>
#endif

/* Returned by `div'.  */
typedef struct {
    int quot;			/* Quotient.  */
    int rem;			/* Remainder.  */
} div_t;

/* Returned by `ldiv'.  */
typedef struct {
    long int quot;		/* Quotient.  */
    long int rem;		/* Remainder.  */
} ldiv_t;

/* The largest number rand will return (same as INT_MAX).  */
#define	RAND_MAX	2147483647

/* We define these the same for all machines.
   Changes from this to the outside world should be done in `_exit'.  */
#define	EXIT_FAILURE	1	/* Failing exit status.  */
#define	EXIT_SUCCESS	0	/* Successful exit status.  */

/* CWK: convert decimal integer to string buffer: */
extern void itoa ( int, char * );   /* -> forklib2.asm */
/* Convert a string to a floating-point number.  */
extern double atof ( const char *nptr);
/* Convert a string to an integer.  */
extern int atoi ( const char *nptr);
/* Convert a string to a long integer.  */
extern long int atol ( const char *nptr);

/* Convert a string to a floating-point number.  */
extern double strtod ( const char *nptr, char **endptr);
/* Convert a string to a long integer.  */
extern long int strtol ( const char *nptr, char **endptr, int base);
/* Convert a string to an unsigned long integer.  */
extern unsigned long int strtoul (const char *__nptr, char **endptr, int base);


/* Return a random integer (32bit, signed). CWK */
extern int rand (void);

/* Seed the random number generator with the given number.  */
/* This number should be odd and individual for each processor! CWK */
extern void srand (unsigned int seed);

/* Random number generator with parameter:  x = random( &seed )   CWK */
extern int random ( int *seed );


/* Allocate SIZE bytes of memory.  */
extern char * malloc (size_t size);
/* Re-allocate the previously allocated block
   in __ptr_t, making the new block SIZE bytes long.  */
extern __ptr_t realloc (__ptr_t ptr, size_t size);
/* Allocate NMEMB elements of SIZE bytes each, all initialized to 0.  */
extern __ptr_t calloc (size_t nmemb, size_t size);
/* Free a block allocated by `malloc', `realloc' or `calloc'.  */
extern void free (__ptr_t ptr);


/* Abort execution and generate a core-dump.  */
extern void abort (void);


/* Register a function to be called when `exit' is called.  */
extern int atexit (void (*__func) (void));


/* Call all functions registered with `atexit'
   in the reverse of the order in which they were registered
   perform stdio cleanup, and terminate program execution with STATUS.  */
extern void exit (int __status);


/* Return the value of envariable NAME, or NULL if it doesn't exist.  */
extern char *getenv ( char *__name);


/* Execute the given line as a shell command.  */
extern int system (char *__command);


/* Do a binary search for KEY in BASE, which consists of NMEMB elements
   of SIZE bytes each, using COMPAR to perform the comparisons.  */
extern __ptr_t bsearch (const __ptr_t key, const __ptr_t base,
			     size_t nmemb, size_t size,
			     int (*compar) (const __ptr_t, const __ptr_t));

/* Sort NMEMB elements of BASE, of SIZE bytes each,
   using COMPAR to perform the comparisons.  */
extern void qsort (__ptr_t base, size_t nmemb, size_t keysize,
		    int (*compar) (      __ptr_t,       __ptr_t));


/* Return the absolute value of X.  */
extern int abs (int __x);
extern long int labs (long int __x);


/* Return the `div_t' or `ldiv_t' representation
   of the value of NUMER over DENOM. */
extern div_t div (int __numer, int __denom);
extern ldiv_t ldiv (long int __numer, long int __denom);

#endif /* stdlib.h  */
