/* SBPRAM-ForkLight header ForkLight.h     CWK 940628 */

#ifndef __FORK_HEADER__
#define __FORK_HEADER__
/* required declarations for this header file: */
#define _NO_LONGLONG
#define myassert(x) \
 if(x==0) { fprintf(stderr,"\nASSERTION FAILED! file %d line %d\n",\
                           __FILE__, __LINE__);\
                           exit(1); }

extern unsigned int __P__;
extern void _eprintf( char *, ...);
extern csync void *shalloc( unsigned int );
            /*allocate shared heap space. No explicit free(). Use shallfree()*/
extern int shavail( void );     /* returns #free shar. memory words */
extern int fetch_add( int*, int );
extern void atomic_add( int*, int );

extern void *shmalloc( unsigned int );
extern void *_SMalloc( unsigned int );
/* allocate permanent shared heap space */

extern void shfree( void * );     /*dummy permanent shared heap free()*/

extern void exit( int );
extern int groupsize( void );
extern int parentgroupsize( void );
extern int _groupsize( unsigned int ); /*new 970901*/

/* fuer join() benoetigt: */ 
extern void **__SM;    /* contains ptrs to shmemory bus sections */
extern int *__gone;    /* guards access to __ticket */
extern int *__ticket;  /* semaphore to control entry of passengers */

 

/* =================  L O C K S :  ======================================== */

/* Lock types, as proposed by J. Roehrig in his Master Thesis, 1995,
 *             Saarbruecken University, taken from his p4 library implementation
 *             for the SB-PRAM: 
 *
 * 4 different locks are provided:
 *
 *     simple locks, safe locks, fair locks & reader/writer-locks
 *
 * simple locks work faster than safe locks and fair locks
 * safe locks provide some features useful for debugging
 * fair locks guarantee access to a lock in demand order (when using simple
 *   or safe locks, processors with low IDs will always get access before
 *   processors with high IDs because of the multiprefix order)
 *
 * reader/writer-locks provide the following mechanism:
 * - several readers can own the lock simultaneously
 * - a reader and a writer can't own the lock simultaneously
 * - two different writers can't own the lock simultaneously
 *
 * the locking mechanism is based on the following functions:
 * (MODULO is the modulo bit which toggels on each round)
 *
 * initialization of a lock  - must be called before any attempt to catch
 * a lock and should only be executed by one process (master)
 *
 *    void simple_lock_init(simple_lock *lock)
 *    void safe_lock_init(safe_lock *lock)
 *    void fair_lock_init(fair_lock *lock)
 *    void rw_lock_init(rw_lock *lock)
 *
 * catch a lock - lock must be initialized
 * (will loop until the lock could be locked - there's no timeout !) 
 *
 *    void simple_lockup(simple_lock *lock)
 *    void safe_lockup(safe_lock *lock)
 *    void fair_lockup(fair_lock *lock)
 *    void rw_lockup(rw_lock *lock, PTYPE)
 *         where "PTYPE" in {SBP_RW_READER, SBP_RW_WRITER)
 *
 * unlock a lock - executing process must be owner of the lock
 *
 *  simple version/fair version
 *  ---------------------------  
 *  (theoretically it's possible that a proccess that doesn't hold a lock l
 *  can unlock l - this will lead to unpredictable results and must be
 *  avoided by the programmer)
 * 
 *  this function will always return 0 (for compatibility with the safe version)
 *
 *    int simple_unlock(lock *lock)
 *    int fair_unlock(fair_lock *lock)
 * 
 *  safe version
 *  ------------ 
 *  (return code:
 *      0 - unlock was successful
 *      1 - tried to unlock a lock that wasn't locked
 *      2 - tried to unlock a lock whose owner was another process
 *   in case 1 and 2, the state of the lock isn't changed)
 *
 *    int safe_unlock(safe_lock *lock)
 * 
 *  reader/writer-lock
 *  ------------------
 * 
 *   void rw_unlock(rw_lock *lock, PTYPE, int wait)
 *        "PTYPE" in {SBP_RW_READER, SBP_RW_WRITER)
 *        "wait" is the delay a writer waits before freeing the rw-lock
 *               for other writers after having freed it for readers
 *               (delay corresponds to wait*3 SBPRAM-rounds
 */

typedef int simple_lock;     /* simple locks */

typedef struct {             /* fair locks */
   int nextnum;
   int actnum;
} fair_lock;

typedef struct {             /* safe locks */
   int cell;                     /* memory cell holding the lock */
   int owner;                    /* process ID of lock owner */
} safe_lock;

typedef struct {             /* reader-writer-locks */
   unsigned int readercounter;   /* Bits 0-29 used as reader counter */
                                 /* Bit 30 is used as writer flag */
   fair_lock writerlock;         /* current and next number */
} rw_lock;

#define RW_READ 0
#define RW_WRITE 1

/* the following routines are implemented in forklib2.asm */

#define simple_lock_init(slock) slock=0
extern void simple_lockup( simple_lock * );
#define simple_unlock(slock) *(slock)=0

extern void fair_lock_init(fair_lock *lock);
extern void fair_lockup( fair_lock * );
extern int fair_unlock( fair_lock * );

#define safe_lock_init(slock) slock={0,-1}
extern void safe_lockup( safe_lock * );
extern int safe_unlock( safe_lock * );

/* the following routines are implemented in async.c: */
extern void rw_lock_init( rw_lock * );
extern void rw_lockup( rw_lock *, int );
extern int rw_unlock( rw_lock *, int, int );


/* critical sections: some useful macros */

#define _enter_crit_sect(adr) simple_lockup(adr) 
#define _exit_crit_sect(adr) simple_unlock(adr)

#if 0
/*other alternatives:*/
#define _enter_crit_sect(adr) fair_lockup(adr)
#define _exit_crit_sect(adr) fair_unlock(adr)
/*or*/
#define _enter_crit_sect(adr) safe_lockup(adr)
#define _exit_crit_sect(adr) safe_unlock(adr)
/*or*/
#define _enter_crit_sect(adr) rw_lockup(adr,RW_WRITE)
#define _exit_crit_sect(adr) rw_unlock(adr,RW_WRITE,10)
#endif

/*#define DEBUG_CRIT_SECT      /* print locking and unlocking events on screen */
#ifdef DEBUG_CRIT_SECT
#define enter_crit_sect(adr) {\
      write(1,"Eingang",7);prIln(__LINE__);\
      _enter_crit_sect(adr);}
#else
#define enter_crit_sect(adr) _enter_crit_sect(adr);
#endif

#ifdef DEBUG_CRIT_SECT
#define exit_crit_sect(adr) {_exit_crit_sect(adr);write(1,"Ausgang",7);prIln(__LINE__);} 
#else
#define exit_crit_sect(adr) myassert(!_exit_crit_sect(adr)) /*alock=0*/
#endif

#undef myassert
#undef prIln


/* simple global forall and group-wide forall loop as macros: */

#define forall(i,lb,ub) for(i=__PROC_NR__+(lb);i<(ub);i+=__STARTED_PROCS__)
#define gforall(i,lb,ub,p) for(i=$+(lb);i<(ub);i+=(p))


/* ==============    J O I N    ---    the bus concept    950918 ============= */

/* global variables for the bus concept: */

/* the following macro implements a simplified variant of the bus concept. */
/* it should only be applied in asynchronous context. */
/* switching to synchronous context is done by two pragma-like directives */
/* that should not be used in common Fork95 programs. *./

/* Parameters:
    _joinID denotes the bus number and must be equal for all processors
           calling the same function
    _delaystmt should evaluate to != 0 as soon as the bus should go.
    _throwoutcond  should evaluate to !=0 if a processor that entered the bus
                   should leave immediately when starting. 
    _SMsize the memory size to be allocated by the driver for the bus's shared memory
    _retry  whether procs that missed the bus or sprang off should retry from beginning
    _body   the bus tour.
    _busywait the statement to be executed by procs that missed the bus or spring off
 */

#define join(_joinID , _SMsize) { \
  extern void **_sps, **_eps, **_gps;\
  int _blubber;\
  int _redo = 0;\
  int _oldalone = _alone;\
  _alone = 0;\
  do { \
    _SMread(&_blubber, &(__gone[_joinID]), 1);\
    if (!_blubber) { \
      _blubber = (int)fetch_add( &(__ticket[_joinID]), 1 ); /* pull a ticket */ \
      /* I am allowed to enter the bus. */ \
      if (_blubber==0) { \
            /* I am the bus driver and set up its shared memory: */ \
            _makegroupframe( 1 );\
            _sps = (void **)shmalloc(_SMsize);\
            _SMwrite(&(__SM[_joinID]), _sps, 4);\
            printf("driver %d %d %d\n", _sps, _eps, _SMsize); \
            _entergroup( 0, 0 /*no barrier*/ );\
            _eps = _gps + _SMsize-1;\
            printf("driver %d %d %d\n", _sps, _eps, _SMsize); \
            /* now the bus is ready for departure. Close the door: */ \
            /*_delaystmt; *wait*/ ;

#define jointakeoff(_joinID, _SMsize) \
            printf("gone!\n"); \
            __gone[_joinID] = 1; \
      } \
      else { \
           /* I am not the bus driver. I build my private group frame. */ \
           /* Then I have to wait until he has set up shared */ \
           /* memory for me; then I can adjust my shared pointers. */ \
            _blubber = 0;\
            _makegroupframe( 1 );\
            do    _SMread(&(_blubber),&(__gone[_joinID]),1);\
            while (_blubber != 1);\
            printf(" see gone=1, ticket=%d, $=%d\n",__ticket[_joinID], $); \
            /* now the value in __SM[joinID] is valid: */ \
            _SMread(&_sps,&(__SM[_joinID]),1);\
            _entergroup( 0, 0 /*no barrier*/ );\
            _eps = _gps + _SMsize-1;\
      } \
      /* departure of the bus: __gone=1, and __ticket is fixed */ 

#define jointhrowout(_throwoutcond) \
      if (_throwoutcond) { \
            /* I am thrown out of the bus. My membership must be cancelled: */ \
            _leavegroup();\
            _alone = _oldalone;\
            printf("thrown out\n");\
            /* now remove the frames and reset the stack pointers: */ \
            goto ELSEJOINID;\
            /*_busywait;*/ \
            /*if (_retry) _redo = 1;*/ \
      } \
      else { \
            /* I ride: synchronize and take off */ \
            barrier();\
            beginsync { /* enter a synchronous section */

#define joinreturn(_joinID) \
            }           /* quit a synchronous section */\
            if ($==0) printf("returned\n",9);\
            /* Now the bus has returned: */ \
            if ($==0) {  /*driver opens the door:*/\
               _SMwrite(&(__ticket[_joinID]),0,1);\
               _SMwrite(&(__gone[_joinID]),0,1); /* re-open ticket automaton */ \
            } \
            _redo = 0; \
            /* now remove the frames and reset the stack pointers: */ \
            _leavegroup();\
            _alone = _oldalone;\
      } \
    }

#define joinelse( _retry, _busywait ) \
    else { \
      ELSEJOINID:\
      /* The bus has gone; I am not allowed to enter. */ \
      _busywait; \
      if (_retry) _redo = 1; \
    }

#define joinend \
  } \
  while (_redo); \
} \
/* end of join macro. */


#endif
