/* ----------------------------------------------------------------------
 *  file name:  timeit.h
 *
 *  Programmer:  chsmith@agate.cs.unh.edu (Craig H Smith)
 *  Description: Declares timing routines, types and unit conversion
 *    symbols.
 *
 *  Date: Sun Sep 17 14:50:01 1995
 *
 *  Modification History
 * 
 * ----------------------------------------------------------------------- */

#ifndef timeit_h
#define timeit_h

#include <sys/time.h>

#define START_SECS   10000
#define START_USECS      0
#define SEC_TO_USECS 1000000

typedef struct itimerval itimerval_t;

extern void init_timer();
extern void clear_timer(itimerval_t *p);
extern void punch_in(itimerval_t *ptimer);
extern void punch_out(itimerval_t checkin, itimerval_t *ptimer);
extern itimerval_t subtract_time(itimerval_t then, itimerval_t now);
extern itimerval_t add_time(itimerval_t t1, itimerval_t t2);
extern void print_time(char * string, itimerval_t total);
extern void error(char *str);

#endif
