/* testpq.c  -  test the parallel FIFO queue implementation.
 * C.W. Kessler 4/99
 */

#include <fork.h>
#include <io.h>

#include <../util/pqueue.h>


void main( void )
{
 start {
    sh PQueue pq;
    sh int counter = 1;
    sh int K = 4;
    PQItem *e;
    int i;

    seq printf("Initialization started\n");
    pq = new_PQueue( K ); 
    seq printf("Initialization completed\n");
    seq pq->print(pq);
    farm {
      for (i=mpadd(&counter,1); i<10; i=mpadd(&counter,1))
      {
         pprintf("Put data %d\n", i*i );
         pq->put( pq, (void *) (i*i) );
      }
      for (i=mpadd(&counter,1); i<28; i=mpadd(&counter,1)) {
         pprintf("Got data %d\n", pq->get( pq ) );
         pprintf("Put data %d\n", i*i );
         pq->put( pq, (void *) (i*i) );
      }
    }
    seq pq->print(pq);
 }
 barrier;
}
