/*************************************************/
/*                                               */
/*      testRTree.c                              */
/*      random search tree implementation test   */
/*	in fork95                                */
/*      v0.11                                    */
/*      13.4.1999 Oliver Fritzen                 */
/*                                               */
/*************************************************/

#include "io.h"
#include "fork.h"
#include "RTree.h"

sh RTree T;
sh char text[110000];
sh char *in_use_list[4096];
sh int sh_i;
sh simple_lock *otlk;

int new_strcmp(char *a, char *b) {
  int 
    i,max,max2,ret=0;
  
  max = strlen(a);
  max2 = strlen(b);
  if(max > max2) max = max2;
  for(i=0; i<max; i++) {
    if(a[i] > b[i]) {
      ret = (ret<<1) + 1;
    }
    else {
      if(a[i] < b[i]) {
	ret = (ret<<1) - 1;
      }
    }
  }
  if(max != max2) ret = (ret<<1) - 1;
  return ret;
}

int comp(void *a, void *b) {
  int ret = new_strcmp((char *) a, (char *) b);
  //pprintf("strcmp(%s,%s) = %d\n",(char *) a,(char *) b,ret);
  return ret;
}

async void main(void) 
{
  FILE *fp;
  char stdin_buffer[16];  /* bug-workaround; should be removed 
                             after bugfix */
  char c;
  char *tempword,*tempword2;
  char *s;
  int i=0;
  int state=0,flag;
  int textlength,
    from,to,
    wordstart,wordend;

 start {
  seq {
    otlk = new_SimpleLock();
    T = new_RTree(comp);
    sh_i = 0;
    if(! (fp = fopen("input.txt","r"))) {
      prS("input file not found, bailing out\n");
      exit(1);
    }
    printf("----- Program executed by %d processors -----\n",
	    __STARTED_PROCS__);
    printf("\n\nreading text");
    while((c = fgetc(fp)) != EOF) {
      text[sh_i++]=c;
      if( !(sh_i % 100)) prS(".");
    }
    printf("\n\ntext read\n\n now going to fill tree\n\n");
  }
  initTracing( 100000 );
  startTracing();
  farm {
   textlength = sh_i;
   from = __PROC_NR__ * (textlength / __STARTED_PROCS__);
   to =   (__PROC_NR__ +1) * (textlength / __STARTED_PROCS__) -1;
   //to = from + 100;
   for(i=from; i<to; i++) {
    c=text[i];
    switch(state) {
    case 0:                    /* Skip (rest of) first word */
      if(!isalpha(c)) state=1;
      break;
    case 1:                    /* Seek for begin of new word */
      if(isalpha(c)) {
        wordstart=i;
        state=2;
      }
      break;
    case 2:                    /* Seek for end of new word */
      if(!isalpha(c)) {
        wordend=i;
        text[i] = '\0';
        state=1;
        tempword = (text+wordstart);
	pprintf("Inserting %s\n", tempword);
	RTreeInsert(T,tempword,tempword);
      }
    }
   }        /* end switch */
  }
  stopTracing();
  seq {
    printf("\n\n\n\n======= BEFORE REBALANCING: =========\n\n");
    output(T);
  }
  RTreeRebal(T);
  seq {
    printf("\n\n\n\n======= AFTER REBALANCING: =========\n\n");
    output(T);  
  }
  writeTraceFile("RTREE", "RTree example (small input)");
 }
}





