#include <fork.h>
#include <io.h>
#include <stdlib.h>
#include "HashTable.h"
#define MAX_RUNS 1000 

sh HashTable HT;
sh SimpleLock outlock;
sh int seed = 69069;
sh int randVals[MAX_RUNS];
sh char stdin_buffer[16];

int newRand(void) {
  int r = rand();
  if (r<0) return -r; else return r;
}

void output( HashTable H ) 
{
  int i;
  int *c;
  char ch;
  HashTableItem item;
  printf("HashTable %p:\n", H );
  printf("number of elements: %d\n", H->NumElts );
  printf("head array size: %d\n", H->Size );
  for(i=0;i<(H->Size);i++) {
    item = H->Head[i];
    if (item!=NULL) printf("\n  Head %3d: ",i);
    while (item != NULL) {
      c = item->data;
      if (c) printf(" --> %4d", (int) *c);
      item = item->next;
    }
  }
  printf("\n===========================\n");
}


int hFn (void *number) { return *((int *)number); }
  
  
int compare(void *a, void *b) 
{
  return (*((int *)a) == *((int *)b));
}

void main(void) 
{
 int i, randWhat, randHowmany, randVal;
 start {
   sh int rehash_counter=0;
   sh int p = 0;
   sh int si;
   int run, j;
   HT = new_HashTable( hFn, 10 );
   seq {
     outlock = new_SimpleLock();
     prS("Old Hashtable: ---\n");
     output(HT);
   }
   farm {
     srand($*$*seed - $*$*$ + 4*$ );
     FORALL( i, &p, 0, MAX_RUNS, 1 )
        randVals[i] = newRand() % 50;
   }

   p = groupsize();
   farm {
     forall (run, 0, 200, p ) {
	  randWhat = newRand() % 128;
	  randWhat = randWhat * randWhat + $;
	  randWhat = randWhat%2;
	  if (run>100) randWhat+=2+$;
	  syncadd( &rehash_counter, 1 );
	  
	  switch(randWhat) {
	    int i, *ret;
	  case 0:
            simple_lockup(outlock);
	    HT->insert( HT, (void *)(randVals+run) );
	    pprintf("[%d]insert %d\n", run, randVals[run]);
            simple_unlock(outlock);
	    break;
	  case 1: 
 	    HT->singleInsert(HT, (void *)(randVals+run),compare);
            simple_lockup(outlock);
	    pprintf("[%d]singleInsert %d\n", run, randVals[run]);
            simple_unlock(outlock);
	    break;
	  case 2: 
 	    ret = (int *) HT->remove(HT, (void *)(randVals+run),compare); 
            simple_lockup(outlock);
 	    if (ret==NULL) 
                 pprintf("[%d]remove %d: NOT FOUND\n", run, *(randVals+run)); 
 	    else pprintf("[%d]remove %d = %d\n", run, randVals[run], *ret);
            simple_unlock(outlock);
 	    break;
	  default:  
	    ret = (int *) HT->lookup(HT,(void *)(randVals+run),compare); 
            simple_lockup(outlock);
 	    if(ret==NULL)  
                 pprintf("[%d]lookup %d: NOT FOUND\n", run, *(randVals+run)); 
            else pprintf("[%d]lookup %d = %d\n", run, *(randVals+run),*ret); 
            simple_unlock(outlock);
 	    break; 
 	  }

          if (rehash_counter > 50) {
             barrier;
             if ($==0) {
                 simple_lockup(outlock);
	         prS("\n ===================== \n");
	         output(HT);
                 si = HT->size(HT);
                 simple_unlock(outlock);
             }
             barrier;
             beginsync HashTableRehash( HT, hFn, si*2 );
             rehash_counter = 0;
             barrier;
             if ($==0) {
                 simple_lockup(outlock);
                 output(HT);
                 prS("\n ===================== \n");
                 simple_unlock(outlock);
             }
           }
      }
    }
    seq output(HT);
    free_HashTable( HT );
  }
}
