/* pqueue.h  -  Implementation of a parallel FIFO queue.
 * C.W. Kessler 3/97, 4/99 following J. Roehrig's proposal
 */


typedef struct pqitem {
   struct pqitem *next, *prev;
   void *data;
} *PQItem;
   
extern PQItem new_PQItem( void *dat );
extern void PQItemFree( PQItem e );


typedef struct pqueue {
   int k;        // k-way parallel FIFO queue
   PQItem *head; // array of pointers to sublist heads
   PQItem *tail; // array of pointers to sublist tails
   fair_lock **lock;  // array of locks for the sublists
   int ngets, nputs;  // global ngets / nputs counter
   int *listngets, *listnputs; // list-local ngets/nputs counters
   int Size;     // current #elements, including pending puts
   void (*put)(struct pqueue *, void *); // enqueue operation
   void *(*get)(struct pqueue *);  // dequeue operation
   void (*print)(struct pqueue *); // print current status, not lock-protected
   int (*empty)(struct pqueue *);  // 0 if nonempty
   int (*size)(struct pqueue *);   // returns current Size
} *PQueue;

extern sync PQueue new_PQueue( sh int k );
