/*************************************************/
/*                                               */
/*      RTree.h                                  */
/*      random search tree implementation        */
/*	in fork95                                */
/*      v0.23                                    */
/*      14.7.1999 Oliver Fritzen                 */
/*                                               */
/*************************************************/

#include "fork.h"



typedef struct treenode {     
  /*****************************/
  /*     node of search tree   */
  /*****************************/

  /* size of tree with root=this */
  int size;
  void *key;
  void *inf;
  struct treenode *left,*right;
  int isAlive;
  int alive;
  rw_lock *leftlock;
  rw_lock *rightlock;   
} *node;

typedef struct tree {
  int size,
    depth,
    alive;  
  node root;
  rw_lock *rootlock;
  int (*compare)(void *,void *);
} *RTree;


extern RTree new_RTree(int (*cmp_keys)(void *,void *));
/* constructor */

extern void RTreeKill (RTree T);
/* destructor */

extern int RTreeAlives(RTree T);
/* returns 1 if there ARE items in the tree, and 0 if not */

extern int RTreeGetSize(RTree T);
/* returns size of tree ( = #leaves of the tree) */

extern void *RTreeLookup(RTree T, void *key);
/* returns data with key '*key' if it is in tree; returns NULL if not */

extern void RTreeInsert(RTree T, void *key, void *inf);
/* inserts data '*inf' with key '*key' into tree */

extern void RTreeSingleInsert(RTree T, void *key, void *inf);

/* inserts data '*inf'with key '*key' into tree, if the tree */ 
/* doesn't yey contain a node with a key '*key'. If so, the  */
/* inf-pointer of the existing node with the key '*key'      */
/* is replaced by the new inf-pointer, the reference to the  */
/* previous contained information is lost.                   */
   
/**********************************************************/
/*                         WARNING!                       */
/*                                                        */
/* THIS OPERATION IS NOT YET IMPLEMENTED. THE CODE BELOW  */
/* IS EXTREMELY BUGGY AND WON'T WORK!!!                   */
/* (If you wan't to implement a SingleInsert function,    */
/* I recommend you to rewrite it completely. The given    */
/* fragments in RTree.c won't be very useful...)          */
/*                                                        */
/**********************************************************/




extern void RTreeDelete(RTree T, void *key);
/* deletes data with key '*key' */

sync void RTreeRebal(sh RTree T);
/* rebalances tree and deletes empty nodes */



