/*************************************************/
/*      HashTable.h                              */
/*      Hashtable implementation in Fork95 v0.71 */
/*      with Rehash-Function                     */
/*      26.2.1999 Oliver Fritzen                 */
/*      18.3.1999 Christoph W. Kessler           */
/*      18.6.1999 stylistically beautified CWK   */
/*************************************************/

#ifndef _HASHTABLE_H_
#define _HASHTABLE_H_

typedef struct hti {
  void *data;
  struct hti *next;
} *HashTableItem;

extern HashTableItem new_HashTableItem (void *);

/* The variant with Rehash function: */

typedef struct ht {
  HashTableItem *Head;
  FairLock *Lock;
  int *Length;
  RWLock RehashLock;
  int Size;
  int (*hashFn)(void *);
  int NumElts;
  int (*size)(struct ht *);       // returns Size
  int (*numElts)(struct ht *);    // returns NumElts
  int (*length)(struct ht *, int);// returns #elements in list i
  void (*print)(struct ht *);     // prints current contents
  void (*insert)(struct ht *, void * );
  void (*singleInsert)(struct ht *, void *, int (*)(void*,void*));
  void * (*lookup)(struct ht *, void *, int (*)(void*,void*));
  void * (*remove)(struct ht *, void *, int (*)(void*,void*));
  sync void (*rehash)(sh struct ht *, sh int (*)(void *), sh int nsiz );
} *HashTable;

extern sync HashTable new_HashTable ( int (*hashFn)(void *), int Size );
extern sync void free_HashTable ( sh HashTable H );
extern void HashTableInsert   (HashTable H, void *entry); 
extern void HashTableSingleInsert(HashTable H, void *entry, 
				 int (*equals)(void *,void *));
extern void *HashTableLookup (HashTable H, void *entry, 
		       int (*equals)(void *, void *));
extern void *HashTableRemove(HashTable H, void *entry, 
		       int (*equals)(void *, void *));
extern sync void HashTableRehash( sh HashTable H, sh int (*newHashFn)(void *), 
			          sh int newSize );
extern int HashTableSize( HashTable H);
extern int HashTableNumElts( HashTable H);
extern int HashTableListLength( HashTable H,int index);

#endif
