/* math.h   mathematical functions for the Fork95 compiler: */

/* double precision routines are NOT available! */

#ifndef MATHHEADER
#define MATHHEADER 1

#define double float

#define max(a,b) ((a>=b)?(a):(b))
#define min(a,b) ((a<=b)?(a):(b))


/* fast integer sqrt()  macro 01/1995 by C.W. Kessler */

extern float sqrt( float );    /* see forklib2.asm */

#define isqrt(p) (1<<((ilog2(p))>>1))

/* to compute the square root of a positive integer p which is a power of 2.
 * If p is not a power of 2, this macro will produce an underestimation
 * with sqrt(p/2) < isqrt(p) < sqrt(p).
 */

/*#define pow(x,y) 1.0  /* eliminate linker complaints. to be implemented later CWK*/

/* Routines located in math.c: */

extern int itento( int );
extern float tento( int );

extern const float PI;
extern float sin( float );
extern float cos( float );

extern float asin( float ); /* arcus sinus */
extern float acos( float ); /* arcus cosinus */
extern float atan( float ); /* arcus tangens */
extern float acot( float ); /* arcus cotangens */
extern float arsinh( float ); /* arcus sinus hyperbolicus */
extern float arcosh( float ); /* arcus cosinus hyperbolicus */
extern float artanh( float ); /* arcus tangens hyperbolicus */
extern float arcoth( float ); /* arcus cotangens hyperbolicus */

extern float log10( float );   /* base 10 logarithm */

/* The ln routine is additional to the ANSI math library: */
extern float ln( float );   /* base e logarithm */

/* Routines located in forklib2.asm: */

extern int ftoi( float );
extern float itof( int );

extern float modf( float , float  * );
extern float  ceil( float  );
extern float  floor( float  );
extern float  fabs( float  );

//extern int abs( int );  //stdlib.h

extern float pow( float, float );
extern float exp( float );
#endif
