/*  BPL.h    CWK 941027    BPL FORK implementation header */

#define Dmax 4            /* max. dimension of an array */
#define TRANSP 1

typedef struct {          /* 1D array access, long version for arbitrary arrays */
    void *el;             /* pointer to the array */
    int bdim;             /* bound dimension # */
    int lb,ub,st,ix;      /* range */
    int index[Dmax];      /* index list */
} Vector;

typedef float *vector;    /* 1D array access, short version, only for 1D arrays */ 

typedef struct {          /* 2D array access, long version for >=2D arrays*/
    void *el;             /* pointer to the array */
    int bdim[2];          /* 2 bound dimension #s */
    int lb[2],ub[2],st[2],ix[2];  /* 2 ranges */
    int index[Dmax];      /* index list */
} Matrix;

typedef float **matrix;   /* 2D array access, short version, only for 2D arrays */ 

extern sync void _MV( sh int, sh int, sh int, sh vector, sh matrix, sh vector, sh float, sh vector, sh int);
extern sync void _VAADD( sh int, sh int, sh vector, sh vector);
extern sync void _SV( sh int, sh int, sh vector, sh float, sh vector);
extern sync void _VAADDSV( sh int, sh int, sh vector, sh float, sh vector);
extern sync void _VADDSV( sh int, sh int, sh vector, sh float, sh vector, sh vector);extern sync void _VCOPY( sh int, sh int, sh vector, sh vector);
extern sync void _SSP( sh int, sh int, sh float *, sh vector, sh vector, sh float);
extern sync void _VQSUM( sh int, sh int, sh float *, sh vector, sh float);
extern sync void _VWRITE( sh int, sh int, sh vector );

