/* Syscall interface */

#ifndef SYSCALLHEADER
#define SYSCALLHEADER 1

#ifndef SYSCALL
#define SYSCALL(NR, RETTYPE, NAME, PROTO, PARM) \
extern RETTYPE NAME PROTO;
#endif

#ifndef SYSCALL_D
#define SYSCALL_D(a...)
#endif

SYSCALL_D( 0, int,  open, (const char *file, int mode, int flags), (file, mode, flags))
SYSCALL( 1, int,  read, (int fd, void *buffer, int number), (fd, buffer, number))
SYSCALL( 2, int,  write, (int fd, const void *buffer, int number), (fd, buffer, number))
SYSCALL( 3, int,  close, (int fd), (fd))
SYSCALL( 4, int,  lseek, (int fd, int offset, int origin), (fd, offset, origin))
SYSCALL( 5, int,  sys_std_open, (int fd), (fd))
SYSCALL( 6, int,  sys_abort, (int pc, int reason), (pc, reason))
SYSCALL( 7, int,  sys_getnr, (void), ())
SYSCALL( 8, int,  sys_exit, (void), ())
SYSCALL( 9, int,  sys_getct, (void), ())
SYSCALL(10, int,  sys_get_extimer, (int *time_64_bit), (time_64_bit))
SYSCALL(11, int,  sys_fork, (int ppid), (ppid))
SYSCALL(12, int,  sys_getbas, (void), ())
SYSCALL(13, void, sys_putbas, (int base), (base))
SYSCALL(14, int,  sys_getpr, (void), ())
SYSCALL(15, int,  sys_procend, (void), ())

#endif
/*ifndef SYSCALLHEADER*/
