/*  pipe.c   by C.W.Kessler 05/95
 *  
 *  pipelined integer global sum implementation in Fork95
 *
 *  n must be a power of 2 and at least be p/2.
 *  p must be a power of 2 minus 1.
 *
 *  Condition: group-relative Processor ID's '$' must be consecutively
 *             numbered from 0 to groupsize - 1.
 */

#include <fork.h>
#include <syscall.h>
#include <stdlib.h>
#include <io.h>

#define max(a,b) ((a)>=(b)?(a):(b))

sh int n = 33;
sh int p = 15;

/* Pipeline graph consisting of p nodes: */

struct Node {
  int data;
  int left, right;   /*predecessors*/
  int stage;
};

typedef struct Node *Graph;


sync void tree_pipeline( sh Graph pipeline, sh int *depth, sh int p ) 
{
  pr mystage;
  *depth = ilog2( p );
  pipeline[$].data = 0;
  if ($ < p/2) {
    pipeline[$].left = 2*$+1;    /*initialize predecessor link in parallel*/
    pipeline[$].right = 2*$+2;   /*initialize predecessor link in parallel*/
  } else {
    pipeline[$].left = -1;       /*leaf processors have no predecessor*/
    pipeline[$].right = -1; 
  }
  mystage = $;
  mystage = *depth - ilog2( mystage+1 );
  pipeline[$].stage = mystage;
}


sync int work( sh Graph pipeline, sh int *A, sh int depth )
{
  if (pipeline[$].stage == 0) 
      pipeline[$].data = A[2*($-((1<<depth)-1))] + A[2*($-((1<<depth)-1)) + 1];   /* leaf computation */ 
  else
      pipeline[$].data = pipeline[ pipeline[$].left ].data
                       + pipeline[ pipeline[$].right ].data;
  farm if ($==0) fpprintf(1, "work returns %d\n", pipeline[0].data );
  return pipeline[0].data;
}


void printpipe( Graph pipeline, int p )
{
  pr int i;
  for (i=0; i<p; i++)
     pprintf(" Node %d:  stage %d,  left %d,  right %d\n",
               i, pipeline[i].stage, pipeline[i].left, pipeline[i].right );
} 


void main( void ) 
{
 pr int i;
 start if ($<p) {
   sh int t;
   sh int sum = 0;   /* accumulates partial sums */
   sh int depth;
   sh int slice = 1<<(ilog2(p)+1);
   sh int *a;

   /* build the pipeline graph: */
   sh Graph pipeline = (struct Node *) shalloc( p );
   tree_pipeline( pipeline, &depth, p );
   farm if ($==0) pprintf("depth: %d\n", depth);
   farm if ($==0) printpipe( pipeline, p );
   farm if ($==0) pprintf("slice = %d\n", slice);

   /* preset the input array: */
   a = (int *) shalloc(n + p);   /* p additional items to flush pipeline */
   farm if ($==0) prS("\nSource Array:\n");
   farm srand(17+2*$*$);
   farm for (i=$; i<n; i+=p)  a[i] = rand() & 0x1fff;  /*range 0..8191*/
   a[n+$] = 0;          /*additional items to flush the pipeline correctly*/
   farm if ($==0) {
          for (i=0; i<n; i++) pprintf(" %d\n", a[i] );
          pprintf("\n");
        }

   /* pipelined computation: */
   for (t=0; t< n/slice + 1 + depth; t++) 
     if (t >= pipeline[$].stage) {
       farm fpprintf(1, "Slice %d\n", t );
       sum += work( pipeline, a+t*slice, depth );
       farm fpprintf(1, "sum[%d] = %d\n", t, sum );
     }
 }
}
