#include <fork.h>
#include <io.h>
#include <stdlib.h>
#include "HashTable.h"
#define MAX_RUNS 1000 

sh int ps=0; 
sh HashTable *HT;
sh simple_lock *inlock,*outlock;
sh int seed = 69069;
sh int randVals[MAX_RUNS];
sh char stdin_buffer[16];

int newRand(void) {
  int r = rand();
  if (r<0) return -r; else return r;
}

void output(HashTable *H) 
{
  int i;
  int *c;
  char ch;
  HashTableItem *item;
  printf("Processor nr.:%d\n",__PROC_NR__);
  printf("number of Elements: %d\n",HashTableNumElts(H));
  printf("Head Array Size: %d\n",HashTableSize(H));
  for(i=0;i<(H->Size);i++) {
    item = H->Head[i];
    if (item!=NULL) printf("\n  Head %3d: ",i);
    while(item != NULL) {
      c = (int *) item->data;
      if (c!=NULL) printf(" --> %4d",*c);
      item = item->next;
    }
  }
  printf("\n===========================\n");
}

#if 0
void buggyoutput(HashTable *H) 
{
  int i = 0;
  int *c;
  HashTableItem *item;
  HashTableIterator *iter;
  listoutput( H );
  iter = new_HashTableIterator( H );
  printf("Processor nr.:%d\n",__PROC_NR__);
  printf("number of Elements: %d\n",HashTableNumElts(H));
  printf("Head Array Size: %d\n",HashTableSize(H));
  while ( ( item = HashTableIteratorNextItem( iter )) != NULL) 
  {
    printf("[%d]", iter->currentListHeadIdx );
    if (i++ & 0x1000) printf("\n");
    c = (int *) item->data;
    if (c!=NULL) printf(" %3d", *c);
    else printf(" NULL");
  }
  printf("\n===========================\n");
}
#endif

int hFn (void *number) 
{
  int *c;
  c = (int *) number;
  return (int) (*c);
}
  
  
int compare(void *a, void *b) 
{
  int *x,*y;
  x = (int *) a;
  y = (int *) b;
  return (*x == *y);
}

async void main(void) 
{
  int i, p, randWhat, randHowmany, randVal;
  if(__PROC_NR__==0) {
    HT = new_HashTable(hFn,10);
    prS("Old Hashtable: ---\n");
    output(HT);
  }
  p=0;
  srand(seed);
  for(i=mpadd(&p,1); i<MAX_RUNS; i=mpadd(&p,1)) randVals[i] = newRand() % 50;
  barrier;
  start {
    sh int rehash_counter=0;
    fork(2; @=$%2; $=$/2);
    @ = __PROC_NR__ % 2;
    farm {
      simple_lockup(outlock);
      //printf("Mark A: @ = %d $ = %d rc = %d randwhat = %d\n",
      //@,$,rehash_counter,randWhat);
      simple_unlock(outlock);
    }
    if(@==0) {
      pr int run;
      p = 0;
      for(run = __PROC_NR__; run < 200; run+=__STARTED_PROCS__) {
	int j;
	if (rehash_counter > 50) {
	  seq {
	    simple_lockup(outlock);
	    prS("\n ===================== \n");
	    output(HT);
	    prS("\n ===== Rehashing ===== \n");
	    simple_unlock(outlock);
	  }
	  HashTableRehash(HT,hFn,20);
	  rehash_counter=0;
	  seq {
	    simple_lockup(outlock);
	    output(HT);
	    prS("\n ===================== \n");
	    simple_unlock(outlock);
	  }
	}
	else for(j=0;j<2000;j++);
      }
    }
    else {
      farm {
	pr int run;
	for(run=__PROC_NR__; run<200; run+=__STARTED_PROCS__) {
	  randWhat = newRand() % 5000;
	  randWhat = randWhat * randWhat;
	  randWhat = randWhat%2;
	  if(run>100) randWhat+=2;
	  rehash_counter++;
	  simple_lockup(outlock);
	  //printf("MarkB: @ = %d $ = %d rc = %d randwhat = %d\n",
	  //@,$,rehash_counter,randWhat);
	  simple_unlock(outlock);
	  
	  switch(randWhat) {
	    pr int i;
	    pr int *ret;
	  case 0:
	    HashTableEnter(HT, (void *)(randVals+run));
	    simple_lockup(outlock);
	    printf("PROC %d - Enter %d\n",__PROC_NR__,randVals[run]);
	    //output(HT);
	    simple_unlock(outlock);
	    break;
	  case 1: 
 	    HashTableSingleEnter(HT, (void *)(randVals+run),compare);
	    simple_lockup(outlock);
	    printf("PROC %d - SingleEnter %d\n",__PROC_NR__,randVals[run]);
	    //output(HT);
	    simple_unlock(outlock);
	    break;
	  case 2: 
 	    ret = (int *) HashTableExtract(HT, (void *)(randVals+run),compare); 
 	    simple_lockup(outlock); 
 	    if (ret==NULL) printf("PROC %d - Extract %d: NOT FOUND\n",__PROC_NR__,*(randVals+run)); 
 	    else printf("PROC %d - Extract %d = %d\n",__PROC_NR__,randVals[run],*ret);
 	    //output(HT);
	    simple_unlock(outlock); 
 	    break;
	  default:  
	    ret = (int *) HashTableLookup(HT,(void *)(randVals+run),compare); 
 	    simple_lockup(outlock); 
 	    if(ret==NULL)  
 	      printf("PROC %d - Lookup %d: NOT FOUND\n",__PROC_NR__,*(randVals+run)); 
 	    else printf("PROC %d - Lookup %d = %d\n",__PROC_NR__,*(randVals+run),*ret); 
 	    //soutput(HT);
	    simple_unlock(outlock); 
 	    break; 
 	  }
	  simple_lockup(outlock);
	  //printf("MarkB4: @ = %d $ = %d rc = %d\n",@,$,rehash_counter);
	  simple_unlock(outlock);
	}
      }
    }
  }
  if (__PROC_NR__==0) {
    prS("\n");
    output(HT);
  }
  barrier;
  HashTableKill(HT);
  barrier;
}
