/********************************************************/
/*      hashtable.h                                     */
/*      simple hashtable implementation in Fork95 v0.71 */
/*      26.2.1999 Oliver Fritzen                        */
/*      18.3.1999 Christoph W. Kessler                  */
/********************************************************/

#ifndef _SIMPLE_HASHTABLE_H_
#define _SIMPLE_HASHTABLE_H_


#ifndef _HASHTABLEITEM_H_
#define _HASHTABLEITEM_H_
typedef struct HTIstruct {
  struct HTIstruct *next;
  void *data;
} HashTableItem;
#endif

/* the simple variant: */

typedef struct {
  HashTableItem **Head;
  fair_lock *Lock;
  int Size;
  int (*hashFn)(void *);
  int NumElts;
} hashtable;

extern hashtable *new_hashtable (int (*hashFn)(void *), int Size);
extern void hashtableKill    (hashtable *H);
extern void hashtableEnter   (hashtable *H, void *entry); 
extern void hashtableSingleEnter(hashtable *H, void *entry, 
				 int (*equals)(void *,void *));
extern void *hashtableLookup (hashtable *H, void *entry, 
		       int (*equals)(void *, void *));
extern void *hashtableExtract(hashtable *H, void *entry, 
		       int (*equals)(void *, void *));
extern int hashtableSize(hashtable *H);
extern int hashtableNumElts(hashtable *H);


#if 0
still buggy. do not use this iterator:
/* Iterator and operations: */

typedef struct htIterator {
  hashtable *hashtable;
  int currentListHeadIdx;
  HashTableItem *currentElemPtr;
} hashtableIterator;

extern hashtableIterator *new_hashtableIterator( hashtable *H ); 
extern void hashtableIteratorReset( hashtableIterator *i );
extern HashTableItem *hashtableIteratorNextItem( hashtableIterator *i );
#endif

#endif
