/*************************************************/
/*      HashTable.h                              */
/*      Hashtable implementation in Fork95 v0.71 */
/*      with Rehash-Function                     */
/*      26.2.1999 Oliver Fritzen                 */
/*      18.3.1999 Christoph W. Kessler           */
/*************************************************/

#ifndef _HASHTABLE_H_
#define _HASHTABLE_H_

#ifndef _HASHTABLEITEM_H_
#define _HASHTABLEITEM_H_
typedef struct HTIstruct {
  struct HTIstruct *next;
  void *data;
} HashTableItem;
#endif


/* The variant with Rehash function: */

typedef struct {
  HashTableItem **Head;
  fair_lock *Lock;
  int *Length;
  rw_lock RehashLock;
  int Size;
  int (*hashFn)(void *);
  int NumElts;
} HashTable;

extern HashTable *new_HashTable (int (*hashFn)(void *), int Size);
extern void HashTableKill    (HashTable *H);
extern void HashTableEnter   (HashTable *H, void *entry); 
extern void HashTableSingleEnter(HashTable *H, void *entry, 
				 int (*equals)(void *,void *));
extern void *HashTableLookup (HashTable *H, void *entry, 
		       int (*equals)(void *, void *));
extern void *HashTableExtract(HashTable *H, void *entry, 
		       int (*equals)(void *, void *));
extern sync void HashTableRehash(HashTable *H,int (*newHashFn)(void *), 
			      int newSize);
extern int HashTableSize(HashTable *H);
extern int HashTableNumElts(HashTable *H);
extern int HashTableListLength(HashTable *H,int index);


#if 0
Still buggy. Do not use this iterator.

/* Iterators and operations: */

typedef struct HTIterator {
  HashTable *HashTable;
  int currentListHeadIdx;
  HashTableItem *currentElemPtr;
} HashTableIterator;

extern HashTableIterator *new_HashTableIterator( HashTable *H ); 
extern void HashTableIteratorReset( HashTableIterator *i );
extern HashTableItem *HashTableIteratorNextItem( HashTableIterator *i );
#endif

#endif
