/* shmalloc.c, included into stdlib.c      by Christoph W. Kessler 10/96 */

/* Shared memory allocator, based on list of free blocks. */

/*#define TESTING 1 /**/

/* Hashing over log of block sizes. Parallelization of list access is
 * optional (not yet implemented). */

/* shmallocated block has shape  | Next | Size | data0 | ... | data(Size-1) |
   which is allocated on the heap using alloc( Size+2 ).   */
#define Next(p) (*(p))
#define Size(p) (int)(*((p)+1))
#define Pdata(p) (char *)((p)+2)

/* Table of lists of blocks: */
sh char * blocktable[16] = { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 };
#define BLOCKTABSIZE 15    /* #lists - 1 */
#define SHMALLOC_CRITICAL_SIZE 8
 /* if a reusable block is more than that too large, it will be split */

/* A lock protects each list in blocktable[]: */
sh simple_lock blocklock[16] = { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 };


async void * shmalloc( pr unsigned int n ) 
{
 pr char *p, *pred;
 pr int i, N;
 N = n;
 i = ilog2( N );
 if (i>BLOCKTABSIZE) i = BLOCKTABSIZE;   /* XXL */

 pred = NULL;
 simple_lockup( &(blocklock[i]) );
 p = blocktable[i];
 while( p ) {
   if (Size(p) >= N)  break;   /* first fit */
   pred = p;
   p = (char *)Next(p);
 }
 if (p) {    /* found suitable block in list i. Unlink it: */
   if (pred) { /* was not the first element in list: */
      *(char **)pred = (char *)Next(p);
   }
   else {   /* was the first list element: */
      blocktable[i] = (char *)Next(p);
   }
   simple_unlock( &(blocklock[i]) );
   if (Size(p)-N-2 > SHMALLOC_CRITICAL_SIZE) { /*block is too large*/
      /* split it for space economy: */
      pr char *pnew = Pdata(p) + n; 
#if TESTING
      pprintf("splitting block: %d+2+%d\n", N, Size(p)-N-2);
#endif
      /*Next(pnew)=NULL  not important because not linked*/ 
      *((int *)pnew+1) = Size(p)-N-2;    /*size of remaining block*/
      /* and insert the remaining block in the appropriate list: */
      shfree( Pdata(pnew) );
   }
#if TESTING
   pprintf("reuse block of size %d\n", Size(p));
#endif
   return Pdata(p);
 }
 else {      /* found no suitable block in list i. Get a new one: */
   simple_unlock( &(blocklock[i]) );
#if TESTING
   pprintf("alloc block of size %d+2\n", N );
#endif
   p = alloc( N + 2 );
   /* Next(p) = NULL;   not important because not linked */
   *((int *)p+1) = N;    
#if TESTING
   pprintf("return pointer %p\n", Pdata(p) );
#endif
   return Pdata(p);
 }
}


async void shfree( pr void *ptr )
{
 /* ! This will crash if ptr is not allocated by shmalloc() ! */
 /* Dynamic typechecking by setting Next to 2^30 may help later. */
 pr int size = *((int *)ptr - 1);
 pr int i = ilog2( size );
 if (i>BLOCKTABSIZE) i = BLOCKTABSIZE;   /* XXL */
#if TESTING
 pprintf("insert block of size %d+2 in Liste %d\n", size, i );
#endif
 simple_lockup( &(blocklock[i]) );
 *((char **)ptr-2) = blocktable[i];        /* prepend to list */
 blocktable[i] = (char *)ptr - 2;
 simple_unlock( &(blocklock[i]) );
}
