Return-Path: smith 
>From smith  Fri Apr  3 18:10:49 1998
Return-Path: <smith>
Received: from aragorn.Uni-Trier.DE by eowyn.Uni-Trier.DE (5.x/2.01) with SMTP id AA15311
	for kessler; Fri, 3 Apr 1998 18:10:45 +0200
Received: by aragorn.Uni-Trier.DE (5.x/client-1.3)
	id AA08731; Fri, 3 Apr 1998 18:10:44 +0200
Date: Fri, 3 Apr 1998 18:10:44 +0200
Message-Id: <9804031610.AA08731@aragorn.Uni-Trier.DE>
From: Craig Smith <smith>
To: kessler
Cc: smith
Subject: fork utility function


You might find this function useful.  It combines a critical section
with a simple_lockup inside one printf call. The first argument is the
processor number to execute the print or -1 indicating all processors
should execute the print, i.e.

LOCK_printf(-1, "all processors, i = %d\n", i);

or just processor 3,

LOCK_printf(3, "i = %d\n", i);

Here is the source code, followed by the .h file:

/* ************************************************************************
 *  file name:  forkutil.c
 *
 *  Programmer:  smith@aragorn (Craig Smith)
 *  Description: 
 *
 *  Date: Fri Apr  3 17:33:08 1998
 *
 *  Modification History
 * 
 * *********************************************************************** */

#include "forkutil.h"

sh simple_lock LOCKlock;

async void
LOCK_printf(int type, char *fmt, ...)
{
  static int init = 0;
  va_list ap;

  if ( init == 0 )
  {
	simple_lock_init(LOCKlock);
	init = 1;
  }

  /*
   * Make sure the user does not select a process that doesn't
   * exist.
   */

  if ( type >= __STARTED_PROCS__ )
  {
	simple_lockup(&LOCKlock);
	if ( __PROC_NR__ == 0 )
	{
	  fprintf(stderr, "LOCK_printf: process %d does not exist, max is %d\n",
			  type, __STARTED_PROCS__);
	}
	simple_unlock(&LOCKlock);
	barrier;
	exit(1); /* non-zero is failure */
  }

  /*
   * -1 means all processors print
   * otherwise a particular processor prints the value.
   */
  if ( type == -1 || type == __PROC_NR__ )
  {
	simple_lockup(&LOCKlock);
	va_start(ap, fmt);
/*	prS("before vfprintf\n"); */
	fprintf(stdout, "pid = %d: ", __PROC_NR__);
	(void) vfprintf(stdout, fmt, ap);
/*	prS("after vfprintf\n"); */
	va_end(ap);
	simple_unlock(&LOCKlock);
  }
  /*
   * synchronize all the threads to make sure
   * all output complete before exiting function.
   * otherwise program could terminate after the
   * call to this function and the output would
   * never be completed.
   */
  barrier;
}

------------------------ forkutil.h ------------------------------

/* ************************************************************************
 *  file name:  forkutil.h
 *
 *  Programmer:  smith@aragorn (Craig Smith)
 *  Description: 
 *
 *  Date: Fri Apr  3 17:33:16 1998
 *
 *  Modification History
 * 
 * *********************************************************************** */


#ifndef FORKUTIL_H
#define FORKUTIL_H

#include <fork.h>
#include <io.h>
#include <string.h>

extern async void LOCK_printf(int type, char *fmt, ...);


#endif
