/* graphic.c   simple graphic output routines    CWK 961017 */
/* to recompile, touch "stdlib.c"

/* async void init_pixel( pr int height, int breadth )     *SEQ*
/* async void set_pixel( pr int x, y, color )
 * async int  get_pixel( pr int x, y )
 * async void par_clear_pixel( void )
 * async void clear_pixel( void )
 * async void flush( pr const char *filename )             *SEQ*
 *       writes black/white pixel buffer to X bitmap file
 *       to view the picture, you may use "xv <filename>"
 * See example program at the bottom. 
 */

#include <fork.h>
#include <io.h>
#include <graphic.h>

sh int H_pixel; /*default 243*/
sh int B_pixel; /*default 221*/
sh int *pixel;


/* init_pixel should be executed by only one processor, because   */
/* (p-1) times as much memory is wasted if called by p processors */

void init_pixel( int height, int breadth )
{
  if (height > 0) H_pixel = height;
  else            H_pixel = 243;   /* some default */
  if (breadth > 0) B_pixel = breadth;
  else             B_pixel = 221;
  pixel = (int *)  shmalloc( H_pixel*B_pixel);
}


void set_pixel(int x, int y, int color)
{
 if (x>=0 && x<B_pixel && y>=0 && y<H_pixel)   pixel[y*B_pixel+x] = color;
}


int get_pixel(int x, int y)
{
 if (x>=0 && x<B_pixel && y>=0 && y<H_pixel)   return pixel[y*B_pixel+x];
 else return 0;
}


void par_clear_pixel( void )  
{
 pr int i,j;
 pr int p=async_groupsize();   /*result is equal for all processors*/
 for (i=$; i<B_pixel; i+=p)
    for (j=0; j<H_pixel; j++)
       set_pixel(i,j,0);    /*clear*/
}


void clear_pixel( void )  
{
 int i,j;
 for (i=0; i<B_pixel; i++)
     for (j=0; j<H_pixel; j++)
        set_pixel(i,j,0);    /*clear*/
}


/* flush_pixel() should be called by only one processor: */

void flush_pixel( const char *filename )
{
  int i,j, pos, nl;
  unsigned char byte;
  FILE *out;

  out = fopen(filename, "w");
  if (!out) { printf("Fehler!\n"); exit(1); }
  fprintf(out,"#define Box_width %d\n", B_pixel );
  fprintf(out,"#define Box_height %d\n", H_pixel );
  fprintf(out,"static short Box[] = {\n");
  byte = 0; pos=0; nl=64;
  for (i=0; i<B_pixel*H_pixel; i++,pos++) {
      if (pixel[i])  byte += (1<<pos);
      if (pos==7 || (i%B_pixel==B_pixel-1) || (i==B_pixel*H_pixel-1)) {
         /* flush and start new byte */
         fprintf(out, "0x%x", byte);
         if (i<H_pixel*B_pixel-1) fprintf(out,", ");
         byte = 0;
         pos = -1;
      }
      if (--nl==0) {nl=64; fprintf(out,"\n");}
  }
  fprintf(out,"};\n");
  fclose( out );
}


#if 0
/* Example application: */
main()
{
  int i,j;
  
   if ($==0) init_pixel( 300,300 );
   barrier;
   par_clear_pixel();
   barrier;
   for (i=$; i<300; i+=__STARTED_PROCS__)     /*in parallel*/
     for (j=i; j<300; j++)
       set_pixel(i,j,1);    /*draw the picture*/
   barrier;
   if ($==0) flush_pixel("blubb.bitmap");
   barrier; exit(0);
}
#endif
