/*  io.h   by C.W.Kessler 03/95
 *
 *  header for io.c, simple I/O routines for Fork95 compiler
 */

#ifndef __IO_HEADER__
#define __IO_HEADER__

#include <stdarg.h>
#include <fork.h>

#ifndef SYSCALLHEADER
#include <syscall.h>
#endif
#ifndef __MYFCNTL__
#include <myfcntl.h>
#endif

#ifndef size_t
#define size_t unsigned int
#endif
#ifndef NULL
#define	NULL	0
#endif
extern char __CR__[];   /*= "\n", io.c*/

typedef struct {   /* FILE pointer */
  char *name;      /* File name. */
  int fd;          /* UNIX file descriptor. 0=stdin, 1=stdout, 2=stderr */
  int flag;        /* error indicator: 0 or _IOERR or _IOEOF */
  int mode;        /* Access mode. See myfcntl.h */
  char *buffer;    /* Buffer for ungetc(). No user access! */
  int buffersize;  /* Size of buffer. */
  int current;     /* index (current read position) in this buffer */
  simple_lock lock; /* to guarantee sequential access to a file */
} FILE; 

#define __UNBUFALLOC__ malloc(100)   /* buffer for ungetc() */
#define __UNBUFSIZE__ 100

extern unsigned int strlen( const char * );
#define prS(mystring) {write(1,mystring,strlen(mystring));}
#define puts(mystring) {write(1,mystring,strlen(mystring));write(1,__CR__,1);}

extern void pr3( int n, int leading );
 /* prints 3 digits of unsigned n ranging from 0 to 999 */

extern void prI( int n, int leading );
 /* prints signed integer n ranging from -10^12+1 to 10^12-1 */
 /* leading!=0 indicates that leading zeroes are to be printed */

extern void prX( int x );
extern void prF( float x );
 /* prints signed float x with 3 digits after decimal point */
 
extern void prstat( void );
 /* prints status message containing Processor ID, current $ and @ values */

extern unsigned int _barrcnt;    /*990119, defined in forklib2.asm*/
extern sh unsigned int _shldgcnt;   /*        printed by printAccStat*/
extern sh unsigned int _shstgcnt;
extern sh unsigned int _mpaddcnt;
extern sh unsigned int _mpmaxcnt;
extern sh unsigned int _mpandcnt;
extern sh unsigned int _mporcnt;
extern unsigned int _myshldgcnt;   /*        printed by printAccStat*/
extern unsigned int _myshstgcnt;
extern unsigned int _mympaddcnt;
extern unsigned int _mympmaxcnt;
extern unsigned int _mympandcnt;
extern unsigned int _mymporcnt;
extern void printAccStat( void );   /*990119*/
 /* prints shared memory access statistics for this processor */

extern sh char __CR[];

#define prIln(n) {prI(n,0);write(1,"\n",1);}
#define prXln(n) {prX(n);write(1,"\n",1);}
#define prFln(n) {prF(n);write(1,"\n",1);}


/* source is in print.c: */

extern int PUTC( int fild, char c );
extern int __printf(const char *format, ...);
#define printf __printf        /*to make things work properly CWK*/
extern int fprintf(FILE *fp, const char *format, ...);


/* The following 2 routines have been extracted from sbo.h,
 * written by Jochen Roehrig,  (c) 1994 by bird@cs.uni-sb.de */
/* ported to Fork95 by CWK 950320. Source is "print.c". */

extern int  pprintf(char *format, ...);
extern int  fpprintf(int fd, char *format, ...);

/* - writes a formatted sequence S of characters to stdout (printf()/
 *   pprintf()) or to the file specified by descriptor fd
 *   (fprintf/fpprintf());
 *   fd must have been obtained by using the system call open()
 * - the p-variants (pprintf()/fpprintf()) additionally write
 *   the processor-id __PROC_NR__
 * 
 * - formating follows the principles of common printf() with some
 *   exceptions (cf. printf()-man page):
 *
 *   + the additional conversion character "b" specifies a conversion  
 *     to binary representation                                        
 *   + the flag "#" is not supported                                   
 *   + the precision field is not supported                            
 *   + floating point conversion (conversion characters (f, e, E, g, G)
 *     is not yet working correctly
 *
 * return:
 *
 * -  total number of written characters in case of success
 * -  -1 in case of failure (S may be written partially to stdout (fd))
 *
 * remark:
 *
 * - these functions use a buffer B of size 160 (2 lines on a 80 column
 *   terminal) to build up the formatted sequence of characters;
 *   this implies that every 160 characters B is written to stdout (fd)
 *   even if S is longer;
 *   therefore S may be truncated in several subsequence which may cause
 *   unexpected effects if several processors write simultaneously to
 *   stdout (fd)
 */


/* in io.c stehen folgende zusammengeknaupte Routinen: */

extern int scanf( const char *fmt, ...);
extern int sscanf( char *string, const char *fmt, ...);
extern int mygetchar( char *stdin_buffer );
extern int unmygetchar( int c, char *stdin_buffer ); 

/* neue File-I/O Routinen: */


#define	_NFILE	20	/* initial number of streams: SPARC ABI and default */
extern int _filepos[_NFILE]; /* store current (physical) r/w position in file */
#define FILEALLOC malloc   /* allocation routine for generating FILE ptrs */

#define	_IOFBF		0000	/* full buffered */
#define	_IOLBF		0100	/* line buffered */
#define	_IONBF		0004	/* not buffered */
#define	_IOEOF		0020	/* EOF reached on read */
#define	_IOERR		0040	/* I/O error from system */

#define	_IOREAD		0001	/* currently reading */
#define	_IOWRT		0002	/* currently writing */
#define	_IORW		0200	/* opened for reading and writing */
#define	_IOMYBUF	0010	/* stdio malloc()'d buffer */

#ifndef EOF
#define	EOF (-1)
#endif

#define __DEFAULT_MASK__ 0644   /* File access mask for created files */

extern FILE *__iob[_NFILE];
#define	stdin	(__iob[0])
#define	stdout	(__iob[1])
#define	stderr	(__iob[2])
#define STDINBUFFERSIZE 16
extern char stdinbuffer[STDINBUFFERSIZE]; /*io.c*/


extern int	fclose(FILE *);
extern int	fflush(FILE *);
extern FILE	*fopen(const char *, const char *);

/* no freopen() available, sorry
extern FILE	*freopen(const char *, const char *, FILE *);
*/

/* no buffering provided, sorry.
extern void	setbuf(FILE *, char *);
extern int	setvbuf(FILE *, char *, int, size_t);
*/

extern int	fscanf(FILE *, const char *, ...);
extern int	vscanf(const char *, va_list);
extern int	vfscanf(FILE *, const char *, va_list);

/* currently not working:
extern int	sprintf(char *, const char *, ...);
extern int	vsprintf(char *, const char *, va_list);
*/

extern int	vfprintf(FILE *, const char *, va_list);
extern int	vprintf(const char *, va_list);

extern int	fgetc(FILE *);
extern int	ungetc(int, FILE *);
extern char	*fgets(char *, int, FILE *);
extern int	fputc(int, FILE *);
extern int	fputs(char *, FILE *);
extern int	getc(FILE *);
extern char	*gets(char *);
/*extern int	putc(int, FILE *);*/
#define putc(c,fp) fputc(c,fp)

extern int	fseek(FILE *, long, int);
extern long	ftell(FILE *);
#define	SEEK_SET	0
#define	SEEK_CUR	1
#define	SEEK_END	2

/* OTHER DIRECT FILE ACCESS NOT YET SUPPORTED, SORRY
extern size_t	fread(void *, size_t, size_t, FILE *);
extern size_t	fwrite(const void *, size_t, size_t, FILE *);
extern int	fgetpos(FILE *, fpos_t *);
extern int	fsetpos(FILE *, const fpos_t *);
extern void	rewind(FILE *);
*/

/* Something to set/reset a user-accessible file lock is planned: */
#if 0
extern void	flockfile(FILE *);
extern void	funlockfile(FILE *);
#endif

#define	clearerr(p)	((void)((p)->flag &= ~(_IOERR | _IOEOF)))
#define	feof(p)		((p)->flag & _IOEOF)
#define	ferror(p)	((p)->flag & _IOERR)
#define	fileno(p)	((p)->fd)
#define getchar() mygetchar(stdin->buffer)
#define	putchar(x)	PUTC(1,(char)(x))        /* in print.c */

#endif
