
/* graphic.h  header for simple graphic output routines    CWK 961017 */

/* routines located in lib/graphic.c */

#ifndef GRAPHIC_HEADER
#define GRAPHIC_HEADER 1

typedef struct pixarray {
  int Xsize, Ysize;      /* size of picture in pixels */
  int *pixel;            /* dynamically allocated pixel array */
} pict;

extern sync pict *init_pict( sh int height, sh int breadth ) ;
extern sync void switch_to_pict( pict * );
extern      void set_pixel( int x, int y, int color) ;
extern      int  get_pixel( int x, int y) ;
extern sync void clear_pixels( int color )  ;
extern sync void write_pixmap( const char *name ) ;
extern      void set_line_pixels ( int, int, int, int );
extern sync void line ( int x1, int y1, 
                        int xn, int yn, int color, int width ) ;
extern      void seq_line ( int x1, int y1, 
                            int xn, int yn, int color, int width ) ;

#endif
