/* SBPRAM-FORK header fork.h     CWK 940628 */
/* last change: Dec 4, 1995 */

#ifndef __FORK_HEADER__
#define __FORK_HEADER__
/* required declarations for this header file: */
extern int write ( int, const void *, int );
extern pr void *reltoabs( pr void * );
extern void exit( int );
extern unsigned int strlen( const char * );
extern void prI( int n, int leading );
#define prIln(n) {prI(n,0);write(1,"\n",1);}
#if 0
#define assert(x) if(x==0){write(1,"\nASSERTION FAILED! file ",24);\
                           write(1,__FILE__,strlen(__FILE__)); write(1," line ",6);\
                           prIln(__LINE__);\
                           exit(1);}
#endif

extern pr int __mp_dummyvar;        /* make multiprefix work correctly */
#define mpadd(a,b) (__mp_dummyvar = mpadd((a),b))
#define mpmax(a,b) (__mp_dummyvar = mpmax((a),b))
#define mpand(a,b) (__mp_dummyvar = mpand((a),b))
#define mpor(a,b) (__mp_dummyvar = mpor((a),b))
                                    /* bug fix to guarantee side effect */
extern void syncadd (int *, int);
extern void syncmax (int *, int);
extern void syncand (int *, int);
extern void syncor (int *, int);

extern sh const int __STARTED_PROCS__; /* number of started processors */
                                       /* generally unknown at compile time */
extern pr const int __PROC_NR__;       /* original consecutive process ID,
                                        * starting with 0 */
#define NULL 0

extern char *malloc( unsigned int );   /*allocate private heap space. No free() */
extern sync char *shalloc( sh unsigned int );
            /*allocate shared heap space. No explicit free(). Use shallfree()*/
extern sync void shallfree( void ); 
              /*release all blocks shalloc()ed in the current (sync) function*/ 

extern async void *shmalloc( unsigned int );
extern async void *alloc( unsigned int );
/* allocate permanent shared heap space:
   alloc for new space, shmalloc for reuse */

extern async void shfree( void * );     /*dummy permanent shared heap free()*/
extern async int pravail( void );     /* returns #free priv. memory words */
extern async int shavail( void );     /* returns #free shar. memory words */

extern void exit( int );
extern unsigned int getct( void );   /* get global time counter, 1cc=4msec */

extern sync int groupsize( void );
extern async int async_groupsize( void );   /* same function, but other prototype */
                                            /* required for consistency reasons */
extern sync int parentgroupsize( void );
extern sync int _groupsize( unsigned int ); /*new 970901*/

extern int *__TICKETP__;   /* points to my current busTicket counter 990128*/
extern int *__RANKP__;   /* points to my current busRank counter 990128*/
#define __NUM_PR__ (*__TICKETP__)
#define __RANK__ (*__RANKP__)


/* =================  L O C K S :  ======================================== */

/* Lock types, as proposed by J. Roehrig in his Master Thesis, 1995,
 *             Saarbruecken University, taken from his p4 library implementation
 *             for the SB-PRAM: 
 *
 * 4 different locks are provided:
 *
 *     simple locks, safe locks, fair locks & reader/writer-locks
 *
 * simple locks work faster than safe locks and fair locks
 * safe locks provide some features useful for debugging
 * fair locks guarantee access to a lock in demand order (when using simple
 *   or safe locks, processors with low IDs will always get access before
 *   processors with high IDs because of the multiprefix order)
 *
 * reader/writer-locks provide the following mechanism:
 * - several readers can own the lock simultaneously
 * - a reader and a writer can't own the lock simultaneously
 * - two different writers can't own the lock simultaneously
 *
 * the locking mechanism is based on the following functions:
 * (MODULO is the modulo bit which toggels on each round)
 *
 * initialization of a lock  - must be called before any attempt to catch
 * a lock and should only be executed by one process (master)
 *
 *    void simple_lock_init(simple_lock *lock)
 *    void safe_lock_init(safe_lock *lock)
 *    void fair_lock_init(fair_lock *lock)
 *    void rw_lock_init(rw_lock *lock)
 *
 * catch a lock - lock must be initialized
 * (will loop until the lock could be locked - there's no timeout !) 
 *
 *    void simple_lockup(simple_lock *lock)
 *    void safe_lockup(safe_lock *lock)
 *    void fair_lockup(fair_lock *lock)
 *    void rw_lockup(rw_lock *lock, PTYPE)
 *         where "PTYPE" in {SBP_RW_READER, SBP_RW_WRITER)
 *
 * unlock a lock - executing process must be owner of the lock
 *
 *  simple version/fair version
 *  ---------------------------  
 *  (theoretically it's possible that a proccess that doesn't hold a lock l
 *  can unlock l - this will lead to unpredictable results and must be
 *  avoided by the programmer)
 * 
 *  this function will always return 0 (for compatibility with the safe version)
 *
 *    int simple_unlock(lock *lock)
 *    int fair_unlock(fair_lock *lock)
 * 
 *  safe version
 *  ------------ 
 *  (return code:
 *      0 - unlock was successful
 *      1 - tried to unlock a lock that wasn't locked
 *      2 - tried to unlock a lock whose owner was another process
 *   in case 1 and 2, the state of the lock isn't changed)
 *
 *    int safe_unlock(safe_lock *lock)
 * 
 *  reader/writer-lock
 *  ------------------
 * 
 *   void rw_unlock(rw_lock *lock, PTYPE, int wait)
 *        "PTYPE" in {SBP_RW_READER, SBP_RW_WRITER)
 *        "wait" is the delay a writer waits before freeing the rw-lock
 *               for other writers after having freed it for readers
 *               (delay corresponds to wait*3 SBPRAM-rounds
 */

typedef int simple_lock;     /* simple locks */

typedef struct {             /* fair locks */
   int nextnum;
   int actnum;
} fair_lock;

typedef struct {             /* safe locks */
   int cell;                     /* memory cell holding the lock */
   int owner;                    /* process ID of lock owner */
} safe_lock;

typedef struct {             /* reader-writer-locks */
   unsigned int readercounter;   /* Bits 0-29 used as reader counter */
                                 /* Bit 30 is used as writer flag */
   fair_lock writerlock;         /* current and next number */
} rw_lock;

typedef struct {             /* reader-writer-locks */
   unsigned int readercounter;   /* Bits 0-29 used as reader counter */
                                 /* Bit 30 is used as writer flag */
   fair_lock writerlock;         /* current and next number */
   int deleteflag;               /* if 1, this lock is going to be deleted */
} rwd_lock;

#define RW_READ 0
#define RW_WRITE 1
#define RW_DELETE 2

/* the following routines are implemented in forklib2.asm */

extern simple_lock *new_simple_lock( void );
#define simple_lock_init(pslock) *(pslock)=0
extern void simple_lockup( simple_lock * );
#define simple_unlock(pslock) *(pslock)=0

extern fair_lock *new_fair_lock( void );
extern void fair_lock_init(fair_lock *lock);
extern void fair_lockup( fair_lock * );
extern int fair_lockup_delflag( fair_lock *, int * );
extern void fair_unlock( fair_lock * );

extern safe_lock *new_safe_lock( void );
#define safe_lock_init(slock) slock={0,-1}
extern void safe_lockup( safe_lock * );
extern int safe_unlock( safe_lock * );   /* returns an error code */

/* the following routines are implemented in async.c: */
extern rw_lock *new_rw_lock( void );
extern void rw_lock_init( rw_lock * );
extern void rw_lockup( rw_lock *, int );
extern void rw_unlock( rw_lock *, int, int );

extern rwd_lock *new_rwd_lock( void );
extern void rwd_lock_init( rwd_lock * );
extern int rwd_lockup( rwd_lock *, int );  /* returns 0 if failed, 1 if lock acquired */
extern void rwd_unlock( rwd_lock *, int, int );


/* critical sections: some useful macros */

#define _enter_crit_sect(adr) simple_lockup(adr) 
#define _exit_crit_sect(adr) simple_unlock(adr)

#if 0
/*other alternatives:*/
#define _enter_crit_sect(adr) fair_lockup(adr)
#define _exit_crit_sect(adr) fair_unlock(adr)
/*or*/
#define _enter_crit_sect(adr) safe_lockup(adr)
#define _exit_crit_sect(adr) safe_unlock(adr)
#endif

/*#define DEBUG_CRIT_SECT      /* print locking and unlocking events on screen */
#ifdef DEBUG_CRIT_SECT
#define enter_crit_sect(adr) {\
      write(1,"Eingang",7);prIln(__LINE__);\
      _enter_crit_sect(adr);}
#else
#define enter_crit_sect(adr) _enter_crit_sect(adr);
#endif

/*#undef assert*/
#undef prIln


/* simple global forall and group-wide forall loop as macros: */

#define forall(i,lb,ub) for(i=__PROC_NR__+(lb);i<(ub);i+=__STARTED_PROCS__)
#define gforall(i,lb,ub,p) for(i=$+(lb);i<(ub);i+=(p))



/* ======      B A R R I E R     (group-relative resynchronization) ===== */

#define barrier barrier()


/* ==============    J O I N    ---    the bus concept    950918 ============= */

/* Old implementation of the join construct as a macro
 * is now obsolete. Use the join statement supported by
 * the compiler, it has more features and is easier to use
 * than this macro.
 * The macro is classified as deprecated in version 1.8 and
 * will no longer be supported in future versions.
 */

/* global variables for the bus concept: */

#define _MAXJOINS 8         /* maximal number of joins in my user program */

extern sh char *_SM[_MAXJOINS];    /* contains ptr to shmemory section of each join*/
extern sh int _gone[_MAXJOINS];    /* guards access to _ticket */
extern sh int _ticket[_MAXJOINS];  /* semaphore to control entry of passengers */

#define init_joins() \
   /* to be called as early as possible. */\
{ pr int i; \
  for (i=0; i<_MAXJOINS; i++)  _gone[i] = _ticket[i] = 0; \
}

#define str( s ) #s
#define force_modulo_0 asm("bmc\t 0")

/* the following macro implements a simplified variant of the bus concept. */
/* it should only be applied in asynchronous context. */
/* switching to synchronous context is done by two pragma-like directives */
/* that should not be used in common Fork95 programs. *./

/* Parameters:
    _joinID denotes the bus number and must be equal for all processors
           calling the same function
    _delaystmt should evaluate to != 0 as soon as the bus should go.
    _throwoutcond  should evaluate to !=0 if a processor that entered the bus
                   should leave immediately when starting. 
    _SMsize the memory size to be allocated by the driver for the bus's shared memory
    _retry  whether procs that missed the bus or sprang off should retry from beginning
    _body   the bus tour.
    _busywait the statement to be executed by procs that missed the bus or spring off
 */

#define JOIN(_joinID,_delaystmt,_throwoutcond,_SMsize,_retry,_body,_busywait) { \
  pr int _old_dollar = $;  \
  pr int _redo = 0;  \
  do { \
    if (!_gone[_joinID]) { \
      $ = mpadd( &( _ticket[_joinID]), 1 ); /* pull a ticket */ \
      /* I am allowed to enter the bus. */ \
      if ($==0) { \
            /* I am the bus driver and set up its shared memory: */ \
            _SM[_joinID] = (char *)shmalloc(_SMsize); /*malloc returns abs.value*/\
            /*pprintf("driver\n");*/ \
            asm("pshg\t gps,spp"); \
            asm("pshg\t eps,spp"); \
            asm("pshg\t sps,spp"); \
            asm("pshg\t gpp,spp"); \
            asm("add\t spp,-1,gpp"); \
            asm("pshgc\t spp"); /* @ = 0 */ \
            asm("pshgc\t spp"); /* new $ is 0 */ \
            asm("gethi\t __SM,gps"); /* compute new gps: */ \
            asm("add\t gps,__SM & 0x1fff,gps"); \
            asm("getlo\t " str(_joinID) ",r31"); /* compute new gps: */ \
            force_modulo_0; \
            asm("ldg\t gps,r31,gps"); \
            asm("nop"); \
            asm("mov\t gps,sps"); \
            asm("pshgc\t sps"); /* no previous gps */ \
            asm("getlo\t " str(_SMsize-1) ",r30"); \
            asm("add\t gps,r30,eps"); /* compute new sps */ \
            asm("pshgc\t sps"); /* preset sync cell */ \
            /* now the bus is ready for departure. Close the door: */ \
            _delaystmt; /*wait*/ ; \
            /*write(1,"gone!\n",6);*/ \
            _gone[_joinID] = 1; \
            asm("nop\nnop\nnop\nnop\nnop\nnop\nnop"); \
            /* now __ticket is stable: */ \
            asm("gethi\t __ticket,r30"); /* r30 <- _ticket[_joinID]:*/ \
            asm("add\t r30,__ticket & 0x1fff,r30"); \
            asm("getlo\t " str(_joinID) ",r31"); \
            force_modulo_0; \
            asm("ldg\t r30,r31,r30"); \
            asm("nop"); \
            asm("stg\t r30,gps,1"); /* set sync cell */ \
      } \
      else { \
           /* I am not the bus driver. I build my private group frame. */ \
           /* Then I have to wait until he has set up shared */ \
           /* memory for me; then I can adjust my shared pointers. */ \
            asm("ldg\t gpp,2,r31"); /* new $ */ \
            asm("pshg\t gps,spp"); \
            asm("pshg\t eps,spp"); \
            asm("pshg\t sps,spp"); \
            asm("pshg\t gpp,spp"); \
            asm("add\t spp,-1,gpp"); \
            asm("pshgc\t spp"); /* @ = 0 */ \
            asm("pshg\t r31,spp"); /* new $ is my ticket number */ \
            while (!_gone[_joinID]) /*wait*/; \
            /*pprintf(" see gone=1, ticket=%d, $=%d\n",_ticket[_joinID], $);*/ \
            asm("nop\nnop\nnop\nnop\nnop\nnop\nnop"); \
            /* now the value in _SM[joinID] is valid: */ \
            asm("gethi\t __SM,gps"); /* compute new gps as _SM[_joinID]: */ \
            asm("add\t gps,__SM & 0x1fff,gps"); \
            asm("getlo\t " str(_joinID) ",r31"); \
            force_modulo_0; \
            asm("ldg\t gps,r31,gps"); \
            asm("nop"); \
            asm("mov\t gps,sps"); \
            asm("getlo\t " str(_SMsize-1) ",r30"); \
            asm("add\t gps,r30,eps"); /* compute new sps */ \
            asm("add\t gps,2,sps"); \
      } \
      /* departure of the bus: _gone=1, and _ticket is fixed */ \
      if (_throwoutcond) { \
            /* I am thrown out of the bus. My membership must be cancelled: */ \
            asm("getlo\t -1,r31"); \
            asm("mpadd\t gps,1,r31"); \
            $ = _old_dollar;    /* restore old $ */ \
            /*write(1,"thrown out\n",10);*/ \
            /* now remove the frames and reset the stack pointers: */ \
            asm("ldg\t gpp,0,gpp"); \
            asm("mov\t gpp,spp"); \
            asm("popg\t spp,sps"); \
            asm("popg\t spp,eps"); \
            asm("popg\t spp,gps"); \
            _busywait; \
            if (_retry) _redo = 1; \
      } \
      else { \
            /* I ride: synchronize and take off */ \
            asm("bsrg\t spp,forklib_sync"); \
            beginsync { /* enter a synchronous section */\
               _body; \
            }           /* quit a synchronous section */\
            /*if ($==0) write(1,"returned\n",9);*/ \
            /* Now the bus has returned: */ \
            _ticket[_joinID] = 0; \
            _gone[_joinID] = 0; /* re-open ticket automaton */ \
            _redo = 0; \
            /* now remove the frames and reset the stack pointers: */ \
            asm("ldg\t gpp,0,gpp"); \
            asm("mov\t gpp,spp"); \
            asm("popg\t spp,sps"); \
            asm("popg\t spp,eps"); \
            asm("popg\t spp,gps"); \
            if ($==0) shfree( _SM[_joinID] ); \
            $ = _old_dollar;    /* restore old $ value */ \
      } \
    } \
    else { \
      /* The bus has gone; I am not allowed to enter. */ \
      $ = _old_dollar;    /* restore old $ */ \
      _busywait; \
      if (_retry) _redo = 1; \
    } \
  } \
  while (_redo); \
} \
/* end of JOIN macro. */

#endif

