/* Implementation of a parallel queue. CWK 3/97 */

#include <fork.h>
#include <io.h>

typedef struct el {
   struct el *next, *prev;
   int data;
} element;
   
typedef struct {
   element *first, *last;
   fair_lock lock;
   int nputs, ngets;
} qhead;
 
#define k 4        /*number of sublists*/

typedef struct {
   qhead *head[k];  /*array of pointers to sublist heads*/
   int ngets, nputs;
   int size;
} pqueue;


void init_pqueue( pqueue **ppq )
{
   pr int i;
   if (__PROC_NR__==0) /*mask out all but one processor*/
      *ppq = (pqueue *) shmalloc( sizeof( pqueue ));
   barrier;
   for (i=__PROC_NR__; i<k; i+=__STARTED_PROCS__) {
      (*ppq)->head[i] = (qhead *) shmalloc( sizeof (qhead ));
      (*ppq)->head[i]->first = (*ppq)->head[i]->last = NULL;
      (*ppq)->head[i]->nputs = (*ppq)->head[i]->ngets = i;
      fair_lock_init( &((*ppq)->head[i]->lock) );
   }
   (*ppq)->ngets = (*ppq)->nputs = (*ppq)->size = 0;
   barrier;
}

void put( pqueue *pq, element *e )
{
 pr int myputidx, mylistidx;
 pr qhead *mylist;
 syncadd( &(pq->size), 1);
 myputidx = mpadd( &(pq->nputs), 1);
 mylist = pq->head[myputidx % k];
 e->next = NULL;
 while (mylist->nputs != myputidx)  ;  /*wait until it's my turn*/
 fair_lockup( &(mylist->lock) );
   e->prev = mylist->last;
   if (mylist->last) mylist->last->next = e;
   else              mylist->first = e;
   mylist->last = e;
 fair_unlock( &(mylist->lock) );
 syncadd( &(mylist->nputs), 4 ); /* pq-> );*/
}

int tdr ( int *pc, int d, int b )
{
 if /*(mpadd( pc, 0 )*/ (*pc - d >= b) {  /*test*/
    if (mpadd(pc,-d) - d >= b)  /*decrement, retest*/
       return 1;           
    else {
       mpadd( pc, d );          /*failed: restore *pc*/
       return 0;
    }
 }
 else return 0;                 /*failed*/
}

element *get ( pqueue *pq )
{
 pr int mygetidx, mylistidx;
 pr qhead *mylist;
 pr element *e;
 if (tdr(&(pq->size),1,0)) { /*test-decrement-retest; enter if nonempty*/
   mygetidx = mpadd( &(pq->ngets), 1);
   mylist = pq->head[mygetidx % k];
   while (mylist->ngets != mygetidx) ;  /*wait until it's my turn*/
   while (mylist->nputs == mygetidx) ;  /*wait until put is ready*/
   fair_lockup( &(mylist->lock) );
     e = mylist->first;
     mylist->first = e->next;
     if (e->next) e->next->prev = NULL;
     else         mylist->last = NULL; 
   fair_unlock( &(mylist->lock) );
   syncadd( &(mylist->ngets), k );
   return e;
 }
 else return NULL;
}

void scan_pqueue( pqueue *pq )
{
 pr int i;
 pr element *e;
 if (__PROC_NR__==0) {  /*mask out all but one processor*/
   printf("PQUEUE %d with k = %d heads:", pq, k);
   for (i=0; i<k; i++) {
      printf("\n sublist[%d](nputs=%d,ngets=%d): ", 
              i, pq->head[i]->nputs, pq->head[i]->ngets);
      e = (pq)->head[i]->first;
      while (e) {
        printf("%d ", e->data);
        e = e->next;
      }
   }
   printf("\nnputs = %d\n", pq->nputs);
   printf("ngets = %d\n", pq->ngets);
   printf("size = %d\n", pq->size );
 }
 barrier;
}

sh pqueue *pq;

main()
{
 pr int i;
 pr element *e;
 init_pqueue( &pq ); 
 pprintf("Initialization completed\n");
 barrier;
 scan_pqueue( pq );
 barrier;
 for (i=__PROC_NR__; i<10; i+=__STARTED_PROCS__) {
    e = (element *) shmalloc( sizeof( element ));
    e->data = i;
    put( pq, e );
    pprintf("Put element %d\n", e->data );
 }
 for (i=__PROC_NR__; i<10; i+=__STARTED_PROCS__) {
    e = get( pq );
    pprintf("Get element(%d) = %d\n", i, e->data ); 
 }
 barrier;
 scan_pqueue( pq );
 barrier;
}
