/*  Dining Philosophers.
 *  This deadlock-free version may still be not fair;
 *  A philosopher tries to get both forks at once.
 *  If he doesn't get both of them, he immediately releases
 *  the fork that he possibly got, and waits for a
 *  randomly chosen amount of time before trying again.  */

#include <fork.h>
#include <stdlib.h>
#include <io.h>

#define maxP 4096     /* max. number of philosophers (processors) */
#define T 10          /* each philosopher should eat T times */
#define random_time (abs(rand()%P))
#define think_time P  /* models the time after which a philosopher 
                       * becomes hungry again */
#define max_hungry (2*P)  /* models the number of failed accesses after 
                           * which a philosopher dies from starvation */

sh int P;        /* number of philosophers */
sh int F[maxP];  /* array of locks, one for each fork */
                 /* F[x] denotes the fork to the left from philosopher x,
                  * F[(x+1)%P] that one to the right, x=0,...,P-1. */
pr int hungry = 0;

void think ( void )
{
  pr i;
  for (i=0; i<think_time; i++)  ;
}

void wait( pr int wait_time )
{
  pr i;
  for (i=0; i<wait_time; i++)  ;
}

void lay_down( pr int index_of_fork )
{
  pprintf(" lay_down fork %d\n", index_of_fork );
  F[index_of_fork] = 0;                /* atomic access on SB-PRAM */
}

void take_both_forks ( void )
{
 pprintf(" try to access forks %d and %d\n", __PROC_NR__, (__PROC_NR__+1)%P );
 do {
    pr int occ_left  = mpmax( (F+__PROC_NR__), 1 );         /* test&set */
    pr int occ_right = mpmax( &(F[(__PROC_NR__+1)%P]), 1 ); /* test&set */
    if (!occ_left && !occ_left)  break;           /*successful*/
    if (!occ_left && occ_right)  lay_down(__PROC_NR__);
    if (occ_left && !occ_right)  lay_down((__PROC_NR__+1)%P);
    hungry++;
    if (hungry > max_hungry) {
        pprintf(" +++++++ starvation! +++++++ \n");
        while(1);   /* nirvana */
    }
    wait( __PROC_NR__ * random_time ); /*before trying again*/
 } while (1);
 /* now I hold both of them */
 pprintf(" took forks %d and %d\n", __PROC_NR__, (__PROC_NR__+1)%P );
}


main() {
 pr int i;
 P = __STARTED_PROCS__;       /* each processor models one philosopher */
 F[__PROC_NR__] = 0;          /* in parallel initialize the fork locks */
 barrier;
 srand(8*__PROC_NR__*__PROC_NR__*__PROC_NR__+4*__PROC_NR__+17);
 if (__PROC_NR__==0) pprintf("%d Dining Philosophers\n\n", P );
 for (i=0; i<T; i++) {
    take_both_forks( );             /* get left AND right fork */
    pprintf(" eat for the %dth time\n", i);  /* eat */
    hungry = 0;
    lay_down( __PROC_NR__ );        /* lay_down left fork */
    lay_down( (__PROC_NR__+1)%P );  /* lay_down right fork */
    think();                        /* wait until getting hungry again */
    hungry = 1;
 }
 pprintf(" finished!\n");
 barrier;
}
