/* Parallel plotting of Julia-Fatou fractal sets
 * C.W. Kessler 3/1997
 * Reference: Becker, Doerfler: Dynamische Systeme und Fraktale.
 *            4. Auflage, Vieweg (Wiesbaden), 1992
 */
#include <fork.h>
#include <assert.h>
#include <io.h>
#include <stdlib.h>
#include <math.h>
#include <graphic.h>

#define XPIXELS 100
#define YPIXELS 100 
#define MAXITER 20

sh float right = 1.7, left = -1.7, 
         top = 1.15, bottom = -1.15;     /* the window in the complex plane */
sh float Cre = 0.7454054;
sh float Cim = 0.1130063;


async int is_in_Julia( float ax, float ay )
{
 int done = 0;
 int iter = 0;
 float x = ax;
 float y = ay;
 float xto2 = x * x;
 float yto2 = y * y;
 float dist2 = xto2 + yto2;
 for (iter=0; iter<=MAXITER; iter++) {
    y = x * y;
    y = y + y - Cim;
    x = xto2 - yto2 - Cre;
    xto2 = x * x;  yto2 = y * y;
    dist2 = xto2 + yto2;
    /* test on convergence: */
    if ((int)dist2 >= 100) break;
 }
 return iter;/* == MAXITER);*/
 /* alternative: return 1 for non-converging points, 0 otherwise: */
 /* alternative: return iter, color(x,y): iter mod NUMCOLORS */
}

sh int NextXY = 0;

main()
{
 start {
   sh int p = groupsize();
   pr int X, Y;       /* screen coordinates */
   pr int XY;         /* loop variable ranges over screen */
   pr float x, y;     /* world coordinates */
   pr int color;
   sh float dx = (right - left) / (float)XPIXELS;
   sh float dy = (top - bottom) / (float)YPIXELS;
   seq printf("dx=%f dy=%f\n", dx, dy);
   init_pict( XPIXELS, YPIXELS );
   /* clear_pixels( 0 ); not required if all points are computed*/
   farm
    for ( XY = mpadd(&NextXY,1);  XY < XPIXELS*YPIXELS; XY = mpadd(&NextXY,1)) {
      Y = XY / XPIXELS;
      X = XY % XPIXELS;
      y = bottom + (float)Y * dy;
      x = left + (float)X * dx;
      color = is_in_Julia( x, y );
      color = (0x35<<color);
      set_pixel( X, Y, color );
      /* may also give different colors to different attractor areas */
    }
   seq printf("\nDone! Writing pixmap file ...\n");
   write_pixmap( "JULIA2" );
 }
 barrier; exit(0);
}
