
/* graphic.h  header for simple graphic output routines    CWK 961017 */

/* routines located in lib/graphic.c */

#ifndef GRAPHIC_HEADER
#define GRAPHIC_HEADER 1

extern async void init_pixel( pr int height, int breadth );    /*SEQ*/
/* init_pixel should be executed by only one processor, because   */
/* (p-1) times as much memory is wasted if called by p processors */

extern async void set_pixel( pr int x, pr int y, pr int color );
extern async int  get_pixel( pr int x, pr int y );
extern async void par_clear_pixel( void );
extern async void clear_pixel( void );

extern async void flush_pixel( pr const char *filename );      /*SEQ*/
/* flush_pixel() should be called by only one processor: */
/*       writes black/white pixel buffer to X bitmap file
 *       to view the picture, you may use "xv <filename>"
 * See example program at the bottom. 
 */

#endif
