/* bus.c      Block allocator using join() or locks. CWK 10/95 */

#include <fork.h>
#include <stdlib.h>
#include <io.h>

#define N 3
#define T 64

#define desynchronize() {pr int t; for(t=0;t<$%8;t++);for(t=0;t<$/128;t++);}
#define wait(myT) {pr int t; for (t=0;t<myT;t++);}

#define SHEAPSIZE 13000
#define BLOCKSIZE 1
#define AVAILSIZE 4096

sh char HEAP[SHEAPSIZE];
sh int offset = 0;
sh char *avail[AVAILSIZE];
sh int high = 0, low = 0;


sync char *newblock( void ) 
{
  pr int my_offset = mpadd( &offset, BLOCKSIZE );
  farm prS("newblock()\n");
  if (my_offset >= SHEAPSIZE) 
      farm { pprintf("newblock failed!\n"); exit(1); }
  return HEAP + my_offset;
}


async char *asy_newblock( void ) 
{
  pr int my_offset = mpadd( &offset, BLOCKSIZE );
  prS("asy_newblock()\n");
  if (my_offset >= SHEAPSIZE) {
     pprintf("newblock failed!\n"); 
     exit(1);
  }
  return HEAP + my_offset;
}

sh simple_lock lowhighlock = 0;


async char *seqballoc( void ) 
{
  pr int pos;
  prS("seqballoc()\n");
  simple_lockup( &lowhighlock );
  if (low < high) {
     pos = low++; 
     simple_unlock( &lowhighlock );
     return avail[ pos % AVAILSIZE ];
  }
  else {
     simple_unlock( &lowhighlock );
     return asy_newblock();
  }
}


async void seqbfree( pr char *ptr ) 
{
  pr int pos;
  prS("seqbfree()\n");
  simple_lockup( &lowhighlock );
  if (high-low < AVAILSIZE)
     avail[high++] = ptr;     /* else forget it */
  simple_unlock( &lowhighlock );
}


/* modes of balloc: */
#define ALLOC 1
#define FREE 0

sync char *balloc( pr char *ptr, pr int mode ) 
{
  pr int my_index;
  /* first serve all FREE's */
  if (mode == FREE) {
     farm prS("balloc(FREE)\n");
     /* insert block ptr into list of available blocks. */
     my_index = mpadd( &high, 1 );
     /* now the new values of high and low are valid, see else case */
     avail[my_index % AVAILSIZE] = ptr;
  }
  /* then serve all ALLOC's */
  if (mode == ALLOC) { 
     farm prS("balloc(ALLOC)\n");
     my_index = mpadd( &low, 1 );
  }
  if (high - low > AVAILSIZE)  {  /* Test on overflow */
     farm pprintf("balloc: avail buffer full!\n");
     return NULL;
  }
  if (mode == ALLOC) {
     /* take available block from queue or acquire a new one */
     if (my_index >= high) { /* cannot get block from avail queue. */ 
        my_index = mpadd( &low, -1 );   /* repair low */
        if (high < low )  {  /* Test on consistency */
           farm pprintf("balloc: inconsistent!\n");
           return NULL;
        }
        else
           return newblock();
     }
     else
        return avail[my_index % AVAILSIZE];
  }
  return NULL;
}

sh int USE_JOIN;

main() 
{
  pr int i, t;
  pr char *p;           /* the value of p is unimportant here. */
  pr int mode;
  _ticket[0] = 0;
  _gone[0] = 0;
  if ($==0) { prS("Do you wish to use JOIN? (1/0) "); scanf("%d", &USE_JOIN); }
  barrier;
  srand(4*$*$*$+8*$+17);
  desynchronize();
  for (i=0; i<N; i++) {
    wait(rand() % T);   /* wait for a random time between 1 and 6T cycles */
    mode = rand() % 2;  /* toss a coin to determine query mode */
    if (USE_JOIN) {
       join ( 0, wait(2), 0, 100, 1, p = balloc(p,mode), );
    }
    else {
       if (mode==ALLOC) p=seqballoc(); else seqbfree(p);
    }
  }
  barrier;
}
