
/*  ctype.c   by C.W.Kessler 03/95
 *
 *  simple character testing routines for Fork95 compiler
 */


int isdigit( int c)
{
        return ((c >= '0') && (c <= '9'));
}


int isxdigit( int c)
{
        return ((c >= '0') && (c <= '9')
                || (c >='A') && (c<='F')
                || (c >='a') && (c<='f'));
}


int islower( int c)
{
        return ((c >='a') && (c<='z'));
}


int isupper( int c)
{
        return ((c >='A') && (c<='Z'));
}


int isalpha( int c)
{
        return ((c >= 'a') && (c <= 'z')
                || (c >='A') && (c<='Z'));
}


int isalnum( int c)
{
        return (isdigit(c) || isalpha(c));
}


int isspace( int c)
{
        return ((c == ' ') || (c == '\f') || (c =='\n') || (c=='\r')
                || (c == '\t') || (c=='v'));
}


int tolower( int c )
{
        if (isupper(c))   return c + 32;
        else              return c;
}


int toupper( int c )
{
        if (islower(c))   return c - 32;
        else              return c;
}


int isprint(  int c )
{
        if ( (c >= ' ') && (c <= '~') )    return 1;
        else                               return 0;
}


int ispunct(  int c )
{
        return (isprint(c) && !isalpha(c) && !isspace(c) && !isdigit(c));
}


int iscntrl(  int c )
{  
        return ( c < ' ' );
}


int isgraph(  int c )
{
        return (isprint(c) && !isspace(c));
}

