/* string.h   for the Fork95 compiler   CWK 950316 */

#ifndef	STRINGHEADER
#define	STRINGHEADER 1

#define	size_t unsigned int
#define __ptr_t void *


/* Copy N bytes of SRC to DEST.  */
extern __ptr_t memcpy (__ptr_t __dest, const __ptr_t __src, size_t __n);

/* Set N bytes of S to C.  */
extern __ptr_t memset (__ptr_t __s, int __c, size_t __n);

/* Compare N bytes of S1 and S2.  */
extern int memcmp (const __ptr_t __s1, const __ptr_t __s2, size_t __n);

/* Search N bytes of S for C.  */
extern __ptr_t memchr (const __ptr_t __s, int __c, size_t __n);


/* Copy SRC to DEST.  */
extern char *strcpy (char *__dest, const char *__src);
/* Copy no more than N characters of SRC to DEST.  */
extern char *strncpy (char *__dest, const char *__src, size_t __n);

/* Append SRC onto DEST.  */
extern char *strcat (char *__dest, const char *__src);
/* Append no more than N characters from SRC onto DEST.  */
extern char *strncat (char *__dest, const char *__src, size_t __n);

/* Compare S1 and S2.  in forklib2.asm CWK */
extern int strcmp (const char *__s1, const char *__s2);
/* Compare N characters of S1 and S2.  */
extern int strncmp (const char *__s1, const char *__s2, size_t __n);

/* Compare the collated forms of S1 and S2.  */
extern size_t strcoll (char *__s1, size_t maxsize, const char *__s2);

/* Find the first occurrence of C in S.  */
extern char *strchr (char *__s, int __c);
/* Find the last occurrence of C in S.  */
extern char *strrchr (const char *__s, int __c);

/* Return the length of the initial segment of S which
   consists entirely of characters not in REJECT.  */
extern size_t strcspn (const char *__s, const char *__reject);
/* Return the length of the initial segment of S which
   consists entirely of characters in ACCEPT.  */
extern size_t strspn (const char *__s, const char *__accept);
/* Find the first occurence in S of any character in ACCEPT.  */
extern char *strpbrk (const char *__s, const char *__accept);
/* Find the first occurence of NEEDLE in HAYSTACK.  */
extern char *strstr (const char *__haystack, const char *__needle);
/* Divide S into tokens separated by characters in DELIM.  */
extern char *strtok (char *__s, const char *__delim);

/* Return the length of S.  */
extern size_t strlen (const char *__s);

/* Return a string describing the meaning of the errno code in ERRNUM.  */
extern char *strerror (int __errnum);

#endif /* string.h  */

