/* math.h   mathematical functions for the Fork95 compiler: */

/* double precision routines are NOT available! */

#ifndef MATHHEADER
#define MATHHEADER 1

#define double float

#define max(a,b) ((a>=b)?(a):(b))
#define min(a,b) ((a<=b)?(a):(b))


/* fast integer sqrt()  macro 01/1995 by C.W. Kessler */

extern double sqrt( float );    /* see forklib2.asm */

#define isqrt(p) (1<<((ilog2(p))>>1))

/* to compute the square root of a positive integer p which is a power of 2.
 * If p is not a power of 2, this macro will produce an underestimation
 * with sqrt(p/2) < isqrt(p) < sqrt(p).
 */

#define pow(x,y) 1.0  /* eliminate linker complaints. to be implemented later CWK*/

/* Routines located in math.c: */

extern int itento( int );
extern float tento( int );

extern const float PI;
extern float sin( float );
extern float cos( float );

/* Routines located in forklib2.asm: */

extern int ftoi( float );
extern float itof( int );

extern float modf( float , float  * );
extern float  ceil( float  );
extern float  floor( float  );
extern float  fabs( float  );

extern int abs( int );

#endif
