/* CRCW Quicksort using fork DC strategy.    C.W. Kessler 11/95 */
/* uses as many processors as there are elements to sort.       */

#include <fork.h>
#include <assert.h>
#include <io.h>

#define N 16

sh int a[] = { 17, 3, 5, -1, 9, 4, 8, 3, 5, 3, 0, 2, 3, 5, 14, 11 };

pr int mine, myrank ;

sync void qs( sh int n )
{
 sh int num[3];
 sh int pivot;
 pr int mynewsubgroup;
 num[0] = num[1] = num[2] = 0;
 farm if ($==0) pprintf(" qs(%d)\n", n);
 if (n>2) {
   if ($==0)  pivot = mine;
   if (mine<pivot)       mynewsubgroup = 0;
   else if (mine==pivot) mynewsubgroup = 1;
        else             mynewsubgroup = 2;
   farm pprintf(" mynewsubgroup=%d\n", mynewsubgroup);
   fork ( 3; @=mynewsubgroup; $=mpadd( &(num[mynewsubgroup]), 1) )  {
      farm assert( num[@] < n );
      if (@ != 1)
         qs( num[@] );   /* computes local part of myrank  */
      if (@==1)  myrank = num[0] + $; 
      if (@==2)  myrank += num[0]+num[1];
   }
 } 
 else {
   farm pprintf("trivial case\n");
   if (n==2) {
      num[$] = mine;              /* misuse num[] as temporary storage */
      if (num[1-$] > mine) myrank = 0;  /* the other value is greater */
      else 
      if (num[1-$] < mine) myrank = 1;  /* my value is greater */
      else                 myrank = $;  /* both values are equal */
                             /* to obtain subsequent rank numbers */
   }
   else myrank = 0;
 }
}

main()
{
 if (__STARTED_PROCS__ < N) {
   if ($==0)
     printf("need %d processors!\n", N); 
   exit(0);
 }
 start {
   mine = a[$];
   myrank = 0;
   qs( N ); 
   a[myrank] = mine;
 }
 pprintf("%d rank: %d\n", mine, myrank );
 barrier; exit(0);
}

