#include <fork.h>
#include <syscall.h>
#include <io.h>

#define N 3
#define T 64
#define NOBUS 1

#define SIMPLE

#define SHEAPSIZE 13000
#define BLOCKSIZE 1
#define AVAILSIZE 4096

sh char sheap[SHEAPSIZE];
sh int offset = 0;
sh char *avail[AVAILSIZE];
sh int high = 12, low = 0;    /* partiell gefuellt */

sh FILE *out;

sync char *newblock( void ) {
  pr int my_offset = mpadd( &offset, BLOCKSIZE );
  if (my_offset >= SHEAPSIZE) {
     farm pprintf("newblock failed!\n"); 
     return NULL;
  }
  else return sheap + my_offset;
}

async char *asy_newblock( void ) {
  pr int my_offset = mpadd( &offset, BLOCKSIZE );
  if (my_offset >= SHEAPSIZE) {
     pprintf("newblock failed!\n"); 
     return NULL;
  }
  else return sheap + my_offset;
}

sh simple_lock lowhighlock = 0;

async char *seqballoc( void ) {
  pr int pos;
  simple_lockup( &lowhighlock );
#ifndef SIMPLE
  if (low < high) {
#endif
     pos = low++; 
     simple_unlock( &lowhighlock );
     return avail[ pos % AVAILSIZE ];
#ifndef SIMPLE
  }
  else {
     simple_unlock( &lowhighlock );
     return asy_newblock();
  }
#endif
}

async void seqbfree( pr char *ptr ) {
  pr int pos;
  simple_lockup( &lowhighlock );
#ifndef SIMPLE
  if (high-low < AVAILSIZE)
#endif
     avail[high++] = ptr;     /* else forget it */
  simple_unlock( &lowhighlock );
}


/* modes of balloc: */
#define ALLOC 1
#define FREE 0

sync char *balloc( pr char *ptr, pr int mode ) {
  pr int my_index;
#if 0
  pprintf("balloc %d\n", mode);
#endif
  if (mode == FREE) {
     /* insert block ptr into list of available blocks. */
     my_index = mpadd( &high, 1 );
     /* now the new values of high and low are valid, see else case */
     avail[my_index % AVAILSIZE] = ptr;
#if 0
     pprintf("inserting %p to position %d\n", ptr, my_index );
#endif
  }
  else {   /* mode == ALLOC */
     my_index = mpadd( &low, 1 );
  }
  if (high - low > AVAILSIZE)  {  /* Test on overflow */
     farm pprintf("balloc: avail buffer full!\n");
     return NULL;
  }
  if (mode == ALLOC) {
     /* take available block from queue or acquire a new one */
     if (my_index >= high) {
        /* cannot get block from avail queue. */ 
        my_index = mpadd( &low, -1 );   /* repair low */
#if 0
        pprintf("acquiring new block\n");
#endif
  if (high < low )  {  /* Test on consistency */
     farm pprintf("balloc: inconsistent!\n");
     return NULL;
  }
        return newblock();
     } else {
#if 0
        pprintf("dequeuing position %d\n", my_index);
#endif
        return avail[my_index % AVAILSIZE];
     }
  }
}


static int ran;

int rann() {
  ran = ran*$*$+((ran+743)<<5)+(ran>>6)+$+1919191;
  return ran>>1;
}

sh procs;


main() 
{
  pr int i, t;
  pr char *p;
  pr int time;
  _ticket[0] = 0;
  _gone[0] = 0;

 out = fopen("Bus.tab", "w");
#if NOBUS
 if ($==0) printf("\nAsynchrone Variante:\n");
 if ($==0) fprintf(out, "\nAsynchrone Variante:\n");
#else
 if ($==0) printf("\nBUS - Variante:\n");
 if ($==0) fprintf(out, "\nBUS - Variante:\n");
#endif
start
for (procs=1; procs<=__STARTED_PROCS__; procs *=2) 
 if ($<procs) 
 farm {
  ran = 4*$*$*$+2*$*$+8*$+13;
  for (t=0; t<$%8; t++) ;
  for (t=0; t<$/128; t++) ;
  time = getct();
  for (i=0; i<N; i++) {
    int myT = rann() % T;
    for (t=0; t<myT; t++) ;
    /*if ($==0) pprintf("i=%d\n", i);*/
#if NOBUS
    p=seqballoc();
#else
    join(0, for(t=0;t<2;t++), 0, 100, 1, p = balloc(p,ALLOC), );
#endif
    myT = rann() % T;
    for (t=0; t<myT; t++) ;
    if (p)
#if NOBUS
     seqbfree( p );
#else
     join(0, for(t=0;t<2;t++), 0, 100, 1, p = balloc(p,FREE), );
#endif
  }
  barrier;
  time = getct() - time;
  if ($==0) printf("p=%d:  %d cc = %d msec\n", procs, time, time>>8);
  if ($==0) fprintf(out, "p=%d:  %d cc = %d msec\n", procs, time, time>>8);
 }
 fclose(out);
}

