/************************************************************************\
*
* libtest -- test libevt and document typical use of the library
*
* Eric A. Brewer
* October 3, 1992
*
\************************************************************************/


#include <stdio.h>
#include "event.h"
#include "event.h"  /* to test idempotency */

typedef unsigned long Time;

#define NO_OF_PROCESSORS 16

/* example parameters used below, no semantic impact */
#define EX_PARAM1 42
#define Nk 20


/************************************************************************\
*
* Generate parameter text for trace file 
*
* The parameters are continuous ascii text consisting of lines ending
* with \n.  With ANSI C, these can be generated easily with the DefParam
* macro.  Without ANSI C, the parameters must all be listed explicitly.
*
* Note that DefParam does not work for boolean parameters; they
* must be defined explicitly or with DefFalseParam or DefTrueParam.
*
\************************************************************************/

#ifdef __STDC__  /* require ANSI C for this part */

/* The following macros require ANSI C */
/* QuoteValueOf(v) -- place double quotes around v,
   works inside another macro (in this case DefParam) */
#define QuoteValueOf(v) #v

/* DefParam(x) -- generate definition string for x */
#define DefParam(x) "#define " #x " " QuoteValueOf(x) "\n"

/* DefFalseParam(x), DefTrueParam(x) -- generate boolean parameter for x */
#define DefFalseParam(x) "#undef " #x "\n"
#define DefTrueParam(x)  "#define " #x "\n"

static char parameters[] = {

    /* example of typical fixed parameters, note that there are no
       commas between the strings -- they will be concatenated */
    "#define Ndim 1\n" 
    "#define Nk 20\n"

    /* example use of DefParam (only valid with ANSI C) */
    /* The advantage of DefParam is that it magically stores the actual value
       of the macro.  Without DefParam the parameter must have the value
       explicitly given (as with Nk and Ndim above), which is error-prone.
       (If you don't understand what DefParam does, look at the
       output of the preprocessor.) */

    DefParam(NO_OF_PROCESSORS)
    DefParam(EX_PARAM1)
    DefTrueParam(__STDC__)
    /* ...  more parameters */
  };

#else /* not ANSI C, so explicitly list parameters */

static char parameters[] = "#define NO_OF_PROCESSORS 16\n";

#endif /* ifdef __STDC__ else */



/************************************************************************\
*
* main -- Generate event file, use some of the basic routines
*
\************************************************************************/

#define MAX_TIME 100

int main() {
    int i, value;
    Time time;

    simulation_title_ = "Data From libtest";

    init_statistics_(parameters, "test.sim");

    for (time=0; time<MAX_TIME; time++) {
	for (i=1; i<16; i++) {
	    value = time;
	    IndexEvent(EV_STATE, i, value, time);
	}
    }

    TraceFileComment("eab", 3, time, "this is a test", 14);

    new_metric("libtest maxtime", MAX_TIME);

    exit_statistics_(time+1); /* pass in final simulation time */

    printf("libtest complete -- generated file \"test.sim\".\n");

    return(0);
}

