
/**************************************************************************\
 *                                                                          *
 *                 Proteus Parallel-Architecture Simulator                  *
 *                Eric A. Brewer  and  Chris N. Dellarocas                  *
 *                     Laboratory for Computer Science                      *
 *                  Massachusetts Institute of Technology                   *
 *                                                                          *
 * Module: evt-fatal.c                                                      *
 *                                                                          *
 * Description: Fatal error handler for event library                       *
 *                                                                          *
 * Last Modified: 7-10-92
 *                                                                          *
 * Global Functions:                                                        *
 *     void fatal(char *format, arg1, arg2, ..., arg6)                      *
 *                                                                          *
 * Global Variables: none                                                   *
 *                                                                          *
 ****************************************************************************
 *   Copyright 1992                                                         *
 *   Eric A. Brewer  and  Chris N. Dellarocas                               *
 *   Massachusetts Institute of Technology                                  *
 *                                                                          *
 *   Permission to use, copy, modify, and distribute this program           *
 *   for any purpose and without fee is hereby granted, provided            *
 *   that this copyright and permission notice appear on all copies         *
 *   and supporting documentation, the name of M.I.T. not be used           *
 *   in advertising or publicity pertaining to distribution of the          *
 *   program without specific prior permission, and notice be given         *
 *   in supporting documentation that copying and distribution is           *
 *   by permission of M.I.T.  M.I.T. makes no representations about         *
 *   the suitability of this software for any purpose.  It is pro-          *
 *   vided "as is" without express or implied warranty.		            *
 ***************************************************************************/

#define GLOBAL

#include <stdio.h>

#ifdef __STDC__
#include <stdarg.h>

GLOBAL void fatal(const char *fmt, ...)
{
    va_list ap;
    va_start(ap, fmt);

    fprintf(stderr, "Fatal Error: ");
    vfprintf(stderr, fmt, ap);
    fprintf(stderr, "\n\n");
    
    exit(1);
    va_end(ap);
}

#else
#define const
#include <varargs.h>

GLOBAL void fatal(va_alist)
    va_dcl
{
    va_list ap;

    va_start(ap);

    fprintf(stderr, "Fatal Error: ");
    vfprintf(stderr, va_arg(ap, const char *), ap);
    fprintf(stderr, "\n\n");
    
    exit(1);
    va_end(ap);
}

#endif /* __STDC__ */


char params_[1] = {0};
