/*
 * This file is part of the Pablo Performance Analysis Environment
 *
 *                                           TM
 * The Pablo Performance Analysis Environment   software is *not* in
 * the public domain.  However, it is freely available without fee for
 * education, research, and non-profit purposes.  By obtaining copies
 * of this and other files that comprise the Pablo Performance Analysis
 * Environment, you, the Licensee, agree to abide by the following
 * conditions and understandings with respect to the copyrighted software:
 * 
 * 1.  The software is copyrighted in the name of the Board of Trustees
 *     of the University of Illinois (UI), and ownership of the software
 *     remains with the UI. 
 *
 * 2.  Permission to use, copy, and modify this software and its documentation
 *     for education, research, and non-profit purposes is hereby granted
 *     to Licensee, provided that the copyright notice, the original author's
 *     names and unit identification, and this permission notice appear on
 *     all such copies, and that no charge be made for such copies.  Any
 *     entity desiring permission to incorporate this software into commercial
 *     products should contact:
 *
 *          Professor Daniel A. Reed                 reed@cs.uiuc.edu
 *          University of Illinois
 *          Department of Computer Science
 *          2413 Digital Computer Laboratory
 *          1304 West Springfield Avenue
 *          Urbana, Illinois  61801
 *          USA
 *
 * 3.  Licensee may not use the name, logo, or any other symbol of the UI
 *     nor the names of any of its employees nor any adaptation thereof in
 *     advertizing or publicity pertaining to the software without specific
 *     prior written approval of the UI.
 *
 * 4.  THE UI MAKES NO REPRESENTATIONS ABOUT THE SUITABILITY OF THE
 *     SOFTWARE FOR ANY PURPOSE.  IT IS PROVIDED "AS IS" WITHOUT EXPRESS
 *     OR IMPLIED WARRANTY.
 *
 * 5.  The UI shall not be liable for any damages suffered by Licensee from
 *     the use of this software.
 *
 * 6.  The software was developed under agreements between the UI and the
 *     Federal Government which entitle the Government to certain rights.
 *
 **************************************************************************
 *
 * Developed by: The TAPESTRY Parallel Computing Laboratory
 *		 University of Illinois at Urbana-Champaign
 *		 Department of Computer Science
 *		 1304 W. Springfield Avenue
 *		 Urbana, IL	61801
 *
 * Copyright (c) 1987, 1988, 1989, 1990, 1991, 1992
 * The University of Illinois Board of Trustees.
 *	All Rights Reserved.
 *
 * Author: Tara Madhyastha (tara@cs.uiuc.edu)
 * Project Manager and Principal Investigator:
 *	Daniel A. Reed (reed@cs.uiuc.edu)
 *
 * Funded by: National Science Foundation grants NSF CCR86-57696,
 * NSF CCR87-06653 and NSF CDA87-22836 (Tapestry), NASA ICLASS Contract
 * No. NAG-1-613, DARPA Contract No. DABT63-91-K-0004, and by a grant
 * from the Digital Equipment Corporation External Research Program.
 *
 */


#include "TransformFunctions.h"

TransformFunctions::TransformFunctions()
{
  TransformFunctionList.addElement(duplicateString("Pass Through"));
  TransformFunctionList.addElement(duplicateString("Linear"));
  TransformFunctionList.addElement(duplicateString("Data Range"));
  TransformFunctionList.addElement(duplicateString("Step"));
  TransformFunctionList.addElement(duplicateString("Boolean"));
}

TransformFunctions::~TransformFunctions()
{
  int i;
  for( i=0; i < TransformFunctionList.numberArgs(); i++ ) {
    delete (TransformFunctionList.getElement(i));
  }
}

DataTransform* TransformFunctions::readConfiguration(istream &is)
{
  int func = 0;
  DataTransform* TF;
  int tmp;

  Tok currentTok;
  if((currentTok = SCFParsing::getTok(is, func)) != IOERR ) {
    switch(currentTok) {
    case FIXED:
      TF = SelectFunction(func);
      if( (TF->readConfiguration(is)) == False_ ) {
	cerr << "Warning: TransformFunctions::readConfiguration: unable to \
completely configure function " << func << NL;
      }
      return TF;
    case LPAREN:
      cerr << "Warning: TransformFunctions::readConfiguration(): \
unexpected paren where configuration info expected -- defaulting to DataTransform\n";
      break;
    case RPAREN: // If there's a rparen, put it back
      is.putback(')');
      break;
    default:
      cerr << form("Warning: TransformFunctions::readConfiguration(): \
unexpected token number %d, ignoring\n", currentTok);
      break;
    }
    return (new DataTransform);
  } else {
    return (new DataTransform);
  }
}

  


DataTransform* TransformFunctions::SelectFunction(int func)
{
  switch (func) {
  case PassThrough_:
    return (new PassThrough);
    break;
  case Linear_:
    return (new Linear);
    break;
  case DataRange_:
    return (new DataRange);
    break;
  case Step_:
    return (new Step);
    break;
  case BooleanMenu_:
    return (new BooleanMenu);
    break;
  default:
    cerr << form("Warning: TransformFunctions::SelectFunction: unrecognized func %d\n", func);
    cerr << "Defaulting to function 0\n";
    return (new PassThrough);
    break;
  }
}

void TransformFunctions::printOn(ostream &os)
{
	os << "TransformFunctions\n";
}

